/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.6.19-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: drew44_newtek5
-- ------------------------------------------------------
-- Server version	10.6.19-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `ads_campaigns`
--

DROP TABLE IF EXISTS `ads_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ads_campaigns` (
  `campaign_id` int(11) NOT NULL AUTO_INCREMENT,
  `campaign_user_id` int(10) unsigned NOT NULL,
  `campaign_title` varchar(256) NOT NULL,
  `campaign_start_date` datetime NOT NULL,
  `campaign_end_date` datetime NOT NULL,
  `campaign_budget` double NOT NULL,
  `campaign_spend` double NOT NULL DEFAULT 0,
  `campaign_bidding` enum('click','view') NOT NULL,
  `audience_countries` mediumtext NOT NULL,
  `audience_gender` varchar(32) NOT NULL,
  `audience_relationship` varchar(64) NOT NULL,
  `ads_title` varchar(255) DEFAULT NULL,
  `ads_description` mediumtext DEFAULT NULL,
  `ads_type` varchar(32) NOT NULL,
  `ads_url` varchar(256) DEFAULT NULL,
  `ads_post_url` varchar(256) DEFAULT NULL,
  `ads_page` int(10) unsigned DEFAULT NULL,
  `ads_group` int(10) unsigned DEFAULT NULL,
  `ads_event` int(10) unsigned DEFAULT NULL,
  `ads_placement` enum('newsfeed','sidebar') NOT NULL,
  `ads_image` varchar(256) NOT NULL,
  `campaign_created_date` datetime NOT NULL,
  `campaign_is_active` enum('0','1') NOT NULL DEFAULT '1',
  `campaign_is_approved` enum('0','1') NOT NULL DEFAULT '0',
  `campaign_is_declined` enum('0','1') NOT NULL DEFAULT '0',
  `campaign_views` int(10) unsigned NOT NULL DEFAULT 0,
  `campaign_clicks` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`campaign_id`),
  KEY `campaign_user_id` (`campaign_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_campaigns`
--

LOCK TABLES `ads_campaigns` WRITE;
/*!40000 ALTER TABLE `ads_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_campaigns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_system`
--

DROP TABLE IF EXISTS `ads_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ads_system` (
  `ads_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `place` varchar(32) NOT NULL,
  `ads_pages_ids` text DEFAULT NULL,
  `ads_groups_ids` text DEFAULT NULL,
  `code` mediumtext NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_system`
--

LOCK TABLES `ads_system` WRITE;
/*!40000 ALTER TABLE `ads_system` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `affiliates_payments`
--

DROP TABLE IF EXISTS `affiliates_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `affiliates_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `affiliates_payments`
--

LOCK TABLES `affiliates_payments` WRITE;
/*!40000 ALTER TABLE `affiliates_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `affiliates_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcements` (
  `announcement_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `title` varchar(256) NOT NULL,
  `type` varchar(32) NOT NULL,
  `code` mediumtext NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  PRIMARY KEY (`announcement_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_users`
--

DROP TABLE IF EXISTS `announcements_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `announcements_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `announcement_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `announcement_id_user_id` (`announcement_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_users`
--

LOCK TABLES `announcements_users` WRITE;
/*!40000 ALTER TABLE `announcements_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auto_connect`
--

DROP TABLE IF EXISTS `auto_connect`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auto_connect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `country_id` int(10) unsigned NOT NULL,
  `nodes_ids` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auto_connect`
--

LOCK TABLES `auto_connect` WRITE;
/*!40000 ALTER TABLE `auto_connect` DISABLE KEYS */;
/*!40000 ALTER TABLE `auto_connect` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_transfers`
--

DROP TABLE IF EXISTS `bank_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_transfers` (
  `transfer_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `handle` varchar(32) NOT NULL,
  `package_id` int(10) unsigned DEFAULT NULL,
  `post_id` int(10) unsigned DEFAULT NULL,
  `plan_id` int(10) unsigned DEFAULT NULL,
  `movie_id` int(10) unsigned DEFAULT NULL,
  `orders_collection_id` varchar(256) DEFAULT NULL,
  `price` float DEFAULT NULL,
  `bank_receipt` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`transfer_id`),
  KEY `user_id` (`user_id`),
  KEY `package_id` (`package_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_transfers`
--

LOCK TABLES `bank_transfers` WRITE;
/*!40000 ALTER TABLE `bank_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blacklist`
--

DROP TABLE IF EXISTS `blacklist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blacklist` (
  `node_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_type` enum('ip','email','username') NOT NULL,
  `node_value` varchar(64) NOT NULL,
  `created_time` datetime NOT NULL,
  PRIMARY KEY (`node_id`),
  KEY `node_value` (`node_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blacklist`
--

LOCK TABLES `blacklist` WRITE;
/*!40000 ALTER TABLE `blacklist` DISABLE KEYS */;
/*!40000 ALTER TABLE `blacklist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blogs_categories`
--

DROP TABLE IF EXISTS `blogs_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blogs_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blogs_categories`
--

LOCK TABLES `blogs_categories` WRITE;
/*!40000 ALTER TABLE `blogs_categories` DISABLE KEYS */;
INSERT INTO `blogs_categories` VALUES (1,0,'Art','',1),(2,0,'Causes','',2),(3,0,'Crafts','',3),(4,0,'Dance','',4),(5,0,'Drinks','',5),(6,0,'Film','',6),(7,0,'Fitness','',7),(8,0,'Food','',8),(9,0,'Games','',9),(10,0,'Gardening','',10),(11,0,'Health','',11),(12,0,'Home','',12),(13,0,'Literature','',13),(14,0,'Music','',14),(15,0,'Networking','',15),(16,0,'Other','',16),(17,0,'Party','',17),(18,0,'Religion','',18),(19,0,'Shopping','',19),(20,0,'Sports','',20),(21,0,'Theater','',21),(22,0,'Wellness','',22);
/*!40000 ALTER TABLE `blogs_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coinpayments_transactions`
--

DROP TABLE IF EXISTS `coinpayments_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `coinpayments_transactions` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_txn_id` text DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `product` text NOT NULL,
  `created_at` datetime NOT NULL,
  `last_update` datetime NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  `status_message` text DEFAULT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coinpayments_transactions`
--

LOCK TABLES `coinpayments_transactions` WRITE;
/*!40000 ALTER TABLE `coinpayments_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `coinpayments_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations`
--

DROP TABLE IF EXISTS `conversations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations` (
  `conversation_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `last_message_id` int(10) unsigned NOT NULL,
  `color` varchar(32) DEFAULT NULL,
  `node_id` int(10) unsigned DEFAULT NULL,
  `node_type` varchar(128) DEFAULT NULL,
  `is_group` enum('1','0') NOT NULL DEFAULT '0',
  PRIMARY KEY (`conversation_id`),
  KEY `last_message_id` (`last_message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations`
--

LOCK TABLES `conversations` WRITE;
/*!40000 ALTER TABLE `conversations` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations_calls_audio`
--

DROP TABLE IF EXISTS `conversations_calls_audio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations_calls_audio` (
  `call_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) unsigned NOT NULL,
  `from_user_token` mediumtext NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `to_user_token` mediumtext NOT NULL,
  `room` varchar(64) NOT NULL,
  `answered` enum('0','1') NOT NULL DEFAULT '0',
  `declined` enum('0','1') NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `updated_time` datetime NOT NULL,
  PRIMARY KEY (`call_id`),
  KEY `from_user_id` (`from_user_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations_calls_audio`
--

LOCK TABLES `conversations_calls_audio` WRITE;
/*!40000 ALTER TABLE `conversations_calls_audio` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations_calls_audio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations_calls_video`
--

DROP TABLE IF EXISTS `conversations_calls_video`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations_calls_video` (
  `call_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) unsigned NOT NULL,
  `from_user_token` text NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `to_user_token` text NOT NULL,
  `room` varchar(64) NOT NULL,
  `answered` enum('0','1') NOT NULL DEFAULT '0',
  `declined` enum('0','1') NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `updated_time` datetime NOT NULL,
  PRIMARY KEY (`call_id`),
  KEY `from_user_id` (`from_user_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations_calls_video`
--

LOCK TABLES `conversations_calls_video` WRITE;
/*!40000 ALTER TABLE `conversations_calls_video` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations_calls_video` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations_messages`
--

DROP TABLE IF EXISTS `conversations_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations_messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `conversation_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `message` longtext NOT NULL,
  `image` varchar(256) NOT NULL,
  `voice_note` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `conversation_id` (`conversation_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations_messages`
--

LOCK TABLES `conversations_messages` WRITE;
/*!40000 ALTER TABLE `conversations_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `conversations_users`
--

DROP TABLE IF EXISTS `conversations_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `conversations_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `conversation_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `seen` enum('0','1') NOT NULL DEFAULT '0',
  `typing` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `conversation_id_user_id` (`conversation_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `conversations_users`
--

LOCK TABLES `conversations_users` WRITE;
/*!40000 ALTER TABLE `conversations_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversations_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `courses_categories`
--

DROP TABLE IF EXISTS `courses_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `courses_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`) USING BTREE,
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `courses_categories`
--

LOCK TABLES `courses_categories` WRITE;
/*!40000 ALTER TABLE `courses_categories` DISABLE KEYS */;
INSERT INTO `courses_categories` VALUES (1,0,'Admin &amp; Office','',1),(2,0,'Art &amp; Design','',2),(3,0,'Business Operations','',3),(4,0,'Cleaning &amp; Facilities','',4),(5,0,'Community &amp; Social Services','',5),(6,0,'Computer &amp; Data','',6),(7,0,'Construction &amp; Mining','',7),(8,0,'Education','',8),(9,0,'Farming &amp; Forestry','',9),(10,0,'Healthcare','',10),(11,0,'Installation, Maintenance &amp; Repair','',11),(12,0,'Legal','',12),(13,0,'Management','',13),(14,0,'Manufacturing','',14),(15,0,'Media &amp; Communication','',15),(16,0,'Personal Care','',16),(17,0,'Protective Services','',17),(18,0,'Restaurant &amp; Hospitality','',18),(19,0,'Retail &amp; Sales','',19),(20,0,'Science &amp; Engineering','',20),(21,0,'Sports &amp; Entertainment','',21),(22,0,'Transportation','',22),(23,0,'Other','',23);
/*!40000 ALTER TABLE `courses_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_fields` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `field_for` varchar(64) NOT NULL,
  `type` varchar(32) NOT NULL,
  `select_options` mediumtext NOT NULL,
  `label` varchar(256) NOT NULL,
  `description` mediumtext NOT NULL,
  `place` varchar(32) NOT NULL,
  `length` int(11) NOT NULL DEFAULT 32,
  `field_order` int(11) NOT NULL DEFAULT 1,
  `is_link` enum('0','1') NOT NULL DEFAULT '0',
  `mandatory` enum('0','1') NOT NULL DEFAULT '0',
  `in_registration` enum('0','1') NOT NULL DEFAULT '0',
  `in_profile` enum('0','1') NOT NULL DEFAULT '0',
  `in_search` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_fields`
--

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `custom_fields_values`
--

DROP TABLE IF EXISTS `custom_fields_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `custom_fields_values` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` mediumtext NOT NULL,
  `field_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(64) NOT NULL,
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `field_id_node_id_node_type` (`field_id`,`node_id`,`node_type`),
  KEY `value` (`value`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `custom_fields_values`
--

LOCK TABLES `custom_fields_values` WRITE;
/*!40000 ALTER TABLE `custom_fields_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `developers_apps`
--

DROP TABLE IF EXISTS `developers_apps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `developers_apps` (
  `app_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_user_id` int(10) unsigned NOT NULL,
  `app_category_id` int(10) unsigned NOT NULL,
  `app_auth_id` varchar(128) NOT NULL,
  `app_auth_secret` varchar(128) NOT NULL,
  `app_name` varchar(256) NOT NULL,
  `app_domain` varchar(256) NOT NULL,
  `app_redirect_url` varchar(256) NOT NULL,
  `app_description` mediumtext NOT NULL,
  `app_icon` varchar(256) NOT NULL,
  `app_date` datetime NOT NULL,
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `app_auth_id` (`app_auth_id`),
  UNIQUE KEY `app_auth_secret` (`app_auth_secret`),
  KEY `app_user_id` (`app_user_id`),
  KEY `app_category_id` (`app_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `developers_apps`
--

LOCK TABLES `developers_apps` WRITE;
/*!40000 ALTER TABLE `developers_apps` DISABLE KEYS */;
/*!40000 ALTER TABLE `developers_apps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `developers_apps_categories`
--

DROP TABLE IF EXISTS `developers_apps_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `developers_apps_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `developers_apps_categories`
--

LOCK TABLES `developers_apps_categories` WRITE;
/*!40000 ALTER TABLE `developers_apps_categories` DISABLE KEYS */;
INSERT INTO `developers_apps_categories` VALUES (1,0,'Business and Pages','',1),(2,0,'Community &amp; Government','',2),(3,0,'Education','',3),(4,0,'Entertainment','',4),(5,0,'Entertainment','',5),(6,0,'Games','',6),(7,0,'Lifestyle','',7),(8,0,'Messaging','',8),(9,0,'News','',9),(10,0,'Shopping','',10),(11,0,'Social Networks &amp; Dating','',11),(12,0,'Utility &amp; Productivity','',12);
/*!40000 ALTER TABLE `developers_apps_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `developers_apps_users`
--

DROP TABLE IF EXISTS `developers_apps_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `developers_apps_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `auth_key` varchar(128) NOT NULL,
  `access_token` varchar(128) DEFAULT NULL,
  `access_token_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id_user_id` (`app_id`,`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `developers_apps_users`
--

LOCK TABLES `developers_apps_users` WRITE;
/*!40000 ALTER TABLE `developers_apps_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `developers_apps_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `emojis`
--

DROP TABLE IF EXISTS `emojis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `emojis` (
  `emoji_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unicode_char` varchar(256) NOT NULL,
  `class` varchar(256) NOT NULL,
  PRIMARY KEY (`emoji_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1803 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `emojis`
--

LOCK TABLES `emojis` WRITE;
/*!40000 ALTER TABLE `emojis` DISABLE KEYS */;
INSERT INTO `emojis` VALUES (1,'😀','grinning-face'),(2,'😃','grinning-face-with-big-eyes'),(3,'😄','grinning-face-with-smiling-eyes'),(4,'😁','beaming-face-with-smiling-eyes'),(5,'😆','grinning-squinting-face'),(6,'😅','grinning-face-with-sweat'),(7,'🤣','rolling-on-the-floor-laughing'),(8,'😂','face-with-tears-of-joy'),(9,'🙂','slightly-smiling-face'),(10,'🙃','upside-down-face'),(11,'😉','winking-face'),(12,'😊','smiling-face-with-smiling-eyes'),(13,'😇','smiling-face-with-halo'),(14,'🥰','smiling-face-with-hearts'),(15,'😍','smiling-face-with-heart-eyes'),(16,'🤩','star-struck'),(17,'😘','face-blowing-a-kiss'),(18,'😗','kissing-face'),(19,'☺️','smiling-face'),(20,'😚','kissing-face-with-closed-eyes'),(21,'😙','kissing-face-with-smiling-eyes'),(22,'🥲','smiling-face-with-tear'),(23,'😋','face-savoring-food'),(24,'😛','face-with-tongue'),(25,'😜','winking-face-with-tongue'),(26,'🤪','zany-face'),(27,'😝','squinting-face-with-tongue'),(28,'🤑','money-mouth-face'),(29,'🤗','hugging-face'),(30,'🤭','face-with-hand-over-mouth'),(31,'🤫','shushing-face'),(32,'🤔','thinking-face'),(33,'🤐','zipper-mouth-face'),(34,'🤨','face-with-raised-eyebrow'),(35,'😐','neutral-face'),(36,'😑','expressionless-face'),(37,'😶','face-without-mouth'),(39,'😏','smirking-face'),(40,'😒','unamused-face'),(41,'🙄','face-with-rolling-eyes'),(42,'😬','grimacing-face'),(44,'🤥','lying-face'),(45,'😌','relieved-face'),(46,'😔','pensive-face'),(47,'😪','sleepy-face'),(48,'🤤','drooling-face'),(49,'😴','sleeping-face'),(50,'😷','face-with-medical-mask'),(51,'🤒','face-with-thermometer'),(52,'🤕','face-with-head-bandage'),(53,'🤢','nauseated-face'),(54,'🤮','face-vomiting'),(55,'🤧','sneezing-face'),(56,'🥵','hot-face'),(57,'🥶','cold-face'),(58,'🥴','woozy-face'),(59,'😵','knocked-out-face'),(61,'🤯','exploding-head'),(62,'🤠','cowboy-hat-face'),(63,'🥳','partying-face'),(64,'🥸','disguised-face'),(65,'😎','smiling-face-with-sunglasses'),(66,'🤓','nerd-face'),(67,'🧐','face-with-monocle'),(68,'😕','confused-face'),(69,'😟','worried-face'),(70,'🙁','slightly-frowning-face'),(71,'☹️','frowning-face'),(72,'😮','face-with-open-mouth'),(73,'😯','hushed-face'),(74,'😲','astonished-face'),(75,'😳','flushed-face'),(76,'🥺','pleading-face'),(77,'😦','frowning-face-with-open-mouth'),(78,'😧','anguished-face'),(79,'😨','fearful-face'),(80,'😰','anxious-face-with-sweat'),(81,'😥','sad-but-relieved-face'),(82,'😢','crying-face'),(83,'😭','loudly-crying-face'),(84,'😱','face-screaming-in-fear'),(85,'😖','confounded-face'),(86,'😣','persevering-face'),(87,'😞','disappointed-face'),(88,'😓','downcast-face-with-sweat'),(89,'😩','weary-face'),(90,'😫','tired-face'),(91,'🥱','yawning-face'),(92,'😤','face-with-steam-from-nose'),(93,'😡','pouting-face'),(94,'😠','angry-face'),(95,'🤬','face-with-symbols-on-mouth'),(96,'😈','smiling-face-with-horns'),(97,'👿','angry-face-with-horns'),(98,'💀','skull'),(99,'☠️','skull-and-crossbones'),(100,'💩','pile-of-poo'),(101,'🤡','clown-face'),(102,'👹','ogre'),(103,'👺','goblin'),(104,'👻','ghost'),(105,'👽','alien'),(106,'👾','alien-monster'),(107,'🤖','robot'),(108,'😺','grinning-cat'),(109,'😸','grinning-cat-with-smiling-eyes'),(110,'😹','cat-with-tears-of-joy'),(111,'😻','smiling-cat-with-heart-eyes'),(112,'😼','cat-with-wry-smile'),(113,'😽','kissing-cat'),(114,'🙀','weary-cat'),(115,'😿','crying-cat'),(116,'😾','pouting-cat'),(117,'🙈','see-no-evil-monkey'),(118,'🙉','hear-no-evil-monkey'),(119,'🙊','speak-no-evil-monkey'),(120,'💋','kiss-mark'),(121,'💌','love-letter'),(122,'💘','heart-with-arrow'),(123,'💝','heart-with-ribbon'),(124,'💖','sparkling-heart'),(125,'💗','growing-heart'),(126,'💓','beating-heart'),(127,'💞','revolving-hearts'),(128,'💕','two-hearts'),(129,'💟','heart-decoration'),(130,'❣️','heart-exclamation'),(131,'💔','broken-heart'),(132,'❤️‍🔥','heart-on-fire'),(133,'❤️‍🩹','mending-heart'),(134,'❤️','red-heart'),(135,'🧡','orange-heart'),(136,'💛','yellow-heart'),(137,'💚','green-heart'),(138,'💙','blue-heart'),(139,'💜','purple-heart'),(140,'🤎','brown-heart'),(141,'🖤','black-heart'),(142,'🤍','white-heart'),(143,'💯','hundred-points'),(144,'💢','anger-symbol'),(145,'💥','collision'),(146,'💫','dizzy'),(147,'💦','sweat-droplets'),(148,'💨','dashing-away'),(149,'🕳️','hole'),(150,'💣','bomb'),(151,'💬','speech-balloon'),(153,'🗨️','left-speech-bubble'),(154,'🗯️','right-anger-bubble'),(155,'💭','thought-balloon'),(156,'💤','zzz'),(157,'👋','waving-hand'),(158,'🤚','raised-back-of-hand'),(159,'🖐️','hand-with-fingers-splayed'),(160,'✋','raised-hand'),(161,'🖖','vulcan-salute'),(162,'👌','ok-hand'),(163,'🤌','pinched-fingers'),(164,'🤏','pinching-hand'),(165,'✌️','victory-hand'),(166,'🤞','crossed-fingers'),(167,'🤟','love-you-gesture'),(168,'🤘','sign-of-the-horns'),(169,'🤙','call-me-hand'),(170,'👈','backhand-index-pointing-left'),(171,'👉','backhand-index-pointing-right'),(172,'👆','backhand-index-pointing-up'),(173,'🖕','middle-finger'),(174,'👇','backhand-index-pointing-down'),(175,'☝️','index-pointing-up'),(176,'👍','thumbs-up'),(177,'👎','thumbs-down'),(178,'✊','raised-fist'),(179,'👊','oncoming-fist'),(180,'🤛','left-facing-fist'),(181,'🤜','right-facing-fist'),(182,'👏','clapping-hands'),(183,'🙌','raising-hands'),(184,'👐','open-hands'),(185,'🤲','palms-up-together'),(186,'🤝','handshake'),(187,'🙏','folded-hands'),(188,'✍️','writing-hand'),(189,'💅','nail-polish'),(190,'🤳','selfie'),(191,'💪','flexed-biceps'),(192,'🦾','mechanical-arm'),(193,'🦿','mechanical-leg'),(194,'🦵','leg'),(195,'🦶','foot'),(196,'👂','ear'),(197,'🦻','ear-with-hearing-aid'),(198,'👃','nose'),(199,'🧠','brain'),(200,'🫀','anatomical-heart'),(201,'🫁','lungs'),(202,'🦷','tooth'),(203,'🦴','bone'),(204,'👀','eyes'),(205,'👁️','eye'),(206,'👅','tongue'),(207,'👄','mouth'),(208,'👶','baby'),(209,'🧒','child'),(210,'👦','boy'),(211,'👧','girl'),(212,'🧑','person'),(213,'👱','person-blond-hair'),(214,'👨','man'),(215,'🧔','person-beard'),(216,'🧔‍♂️','man-beard'),(217,'🧔‍♀️','woman-beard'),(218,'👨‍🦰','man-red-hair'),(219,'👨‍🦱','man-curly-hair'),(220,'👨‍🦳','man-white-hair'),(221,'👨‍🦲','man-bald'),(222,'👩','woman'),(223,'👩‍🦰','woman-red-hair'),(224,'🧑‍🦰','person-red-hair'),(225,'👩‍🦱','woman-curly-hair'),(226,'🧑‍🦱','person-curly-hair'),(227,'👩‍🦳','woman-white-hair'),(228,'🧑‍🦳','person-white-hair'),(229,'👩‍🦲','woman-bald'),(230,'🧑‍🦲','person-bald'),(231,'👱‍♀️','woman-blond-hair'),(232,'👱‍♂️','man-blond-hair'),(233,'🧓','older-person'),(234,'👴','old-man'),(235,'👵','old-woman'),(236,'🙍','person-frowning'),(237,'🙍‍♂️','man-frowning'),(238,'🙍‍♀️','woman-frowning'),(239,'🙎','person-pouting'),(240,'🙎‍♂️','man-pouting'),(241,'🙎‍♀️','woman-pouting'),(242,'🙅','person-gesturing-no'),(243,'🙅‍♂️','man-gesturing-no'),(244,'🙅‍♀️','woman-gesturing-no'),(245,'🙆','person-gesturing-ok'),(246,'🙆‍♂️','man-gesturing-ok'),(247,'🙆‍♀️','woman-gesturing-ok'),(248,'💁','person-tipping-hand'),(249,'💁‍♂️','man-tipping-hand'),(250,'💁‍♀️','woman-tipping-hand'),(251,'🙋','person-raising-hand'),(252,'🙋‍♂️','man-raising-hand'),(253,'🙋‍♀️','woman-raising-hand'),(254,'🧏','deaf-person'),(255,'🧏‍♂️','deaf-man'),(256,'🧏‍♀️','deaf-woman'),(257,'🙇','person-bowing'),(258,'🙇‍♂️','man-bowing'),(259,'🙇‍♀️','woman-bowing'),(260,'🤦','person-facepalming'),(261,'🤦‍♂️','man-facepalming'),(262,'🤦‍♀️','woman-facepalming'),(263,'🤷','person-shrugging'),(264,'🤷‍♂️','man-shrugging'),(265,'🤷‍♀️','woman-shrugging'),(266,'🧑‍⚕️','health-worker'),(267,'👨‍⚕️','man-health-worker'),(268,'👩‍⚕️','woman-health-worker'),(269,'🧑‍🎓','student'),(270,'👨‍🎓','man-student'),(271,'👩‍🎓','woman-student'),(272,'🧑‍🏫','teacher'),(273,'👨‍🏫','man-teacher'),(274,'👩‍🏫','woman-teacher'),(275,'🧑‍⚖️','judge'),(276,'👨‍⚖️','man-judge'),(277,'👩‍⚖️','woman-judge'),(278,'🧑‍🌾','farmer'),(279,'👨‍🌾','man-farmer'),(280,'👩‍🌾','woman-farmer'),(281,'🧑‍🍳','cook'),(282,'👨‍🍳','man-cook'),(283,'👩‍🍳','woman-cook'),(284,'🧑‍🔧','mechanic'),(285,'👨‍🔧','man-mechanic'),(286,'👩‍🔧','woman-mechanic'),(287,'🧑‍🏭','factory-worker'),(288,'👨‍🏭','man-factory-worker'),(289,'👩‍🏭','woman-factory-worker'),(290,'🧑‍💼','office-worker'),(291,'👨‍💼','man-office-worker'),(292,'👩‍💼','woman-office-worker'),(293,'🧑‍🔬','scientist'),(294,'👨‍🔬','man-scientist'),(295,'👩‍🔬','woman-scientist'),(296,'🧑‍💻','technologist'),(297,'👨‍💻','man-technologist'),(298,'👩‍💻','woman-technologist'),(299,'🧑‍🎤','singer'),(300,'👨‍🎤','man-singer'),(301,'👩‍🎤','woman-singer'),(302,'🧑‍🎨','artist'),(303,'👨‍🎨','man-artist'),(304,'👩‍🎨','woman-artist'),(305,'🧑‍✈️','pilot'),(306,'👨‍✈️','man-pilot'),(307,'👩‍✈️','woman-pilot'),(308,'🧑‍🚀','astronaut'),(309,'👨‍🚀','man-astronaut'),(310,'👩‍🚀','woman-astronaut'),(311,'🧑‍🚒','firefighter'),(312,'👨‍🚒','man-firefighter'),(313,'👩‍🚒','woman-firefighter'),(314,'👮','police-officer'),(315,'👮‍♂️','man-police-officer'),(316,'👮‍♀️','woman-police-officer'),(317,'🕵️','detective'),(318,'🕵️‍♂️','man-detective'),(319,'🕵️‍♀️','woman-detective'),(320,'💂','guard'),(321,'💂‍♂️','man-guard'),(322,'💂‍♀️','woman-guard'),(323,'🥷','ninja'),(324,'👷','construction-worker'),(325,'👷‍♂️','man-construction-worker'),(326,'👷‍♀️','woman-construction-worker'),(327,'🤴','prince'),(328,'👸','princess'),(329,'👳','person-wearing-turban'),(330,'👳‍♂️','man-wearing-turban'),(331,'👳‍♀️','woman-wearing-turban'),(332,'👲','person-with-skullcap'),(333,'🧕','woman-with-headscarf'),(334,'🤵','person-in-tuxedo'),(335,'🤵‍♂️','man-in-tuxedo'),(336,'🤵‍♀️','woman-in-tuxedo'),(337,'👰','person-with-veil'),(338,'👰‍♂️','man-with-veil'),(339,'👰‍♀️','woman-with-veil'),(340,'🤰','pregnant-woman'),(341,'🤱','breast-feeding'),(342,'👩‍🍼','woman-feeding-baby'),(343,'👨‍🍼','man-feeding-baby'),(344,'🧑‍🍼','person-feeding-baby'),(345,'👼','baby-angel'),(346,'🎅','santa-claus'),(348,'🧑‍🎄','mx-claus'),(349,'🦸','superhero'),(350,'🦸‍♂️','man-superhero'),(351,'🦸‍♀️','woman-superhero'),(352,'🦹','supervillain'),(353,'🦹‍♂️','man-supervillain'),(354,'🦹‍♀️','woman-supervillain'),(355,'🧙','mage'),(356,'🧙‍♂️','man-mage'),(357,'🧙‍♀️','woman-mage'),(358,'🧚','fairy'),(359,'🧚‍♂️','man-fairy'),(360,'🧚‍♀️','woman-fairy'),(361,'🧛','vampire'),(362,'🧛‍♂️','man-vampire'),(363,'🧛‍♀️','woman-vampire'),(364,'🧜','merperson'),(365,'🧜‍♂️','merman'),(366,'🧜‍♀️','mermaid'),(367,'🧝','elf'),(368,'🧝‍♂️','man-elf'),(369,'🧝‍♀️','woman-elf'),(370,'🧞','genie'),(371,'🧞‍♂️','man-genie'),(372,'🧞‍♀️','woman-genie'),(373,'🧟','zombie'),(374,'🧟‍♂️','man-zombie'),(375,'🧟‍♀️','woman-zombie'),(376,'💆','person-getting-massage'),(377,'💆‍♂️','man-getting-massage'),(378,'💆‍♀️','woman-getting-massage'),(379,'💇','person-getting-haircut'),(380,'💇‍♂️','man-getting-haircut'),(381,'💇‍♀️','woman-getting-haircut'),(382,'🚶','person-walking'),(383,'🚶‍♂️','man-walking'),(384,'🚶‍♀️','woman-walking'),(385,'🧍','person-standing'),(386,'🧍‍♂️','man-standing'),(387,'🧍‍♀️','woman-standing'),(388,'🧎','person-kneeling'),(389,'🧎‍♂️','man-kneeling'),(390,'🧎‍♀️','woman-kneeling'),(391,'🧑‍🦯','person-with-white-cane'),(392,'👨‍🦯','man-with-white-cane'),(393,'👩‍🦯','woman-with-white-cane'),(394,'🧑‍🦼','person-in-motorized-wheelchair'),(395,'👨‍🦼','man-in-motorized-wheelchair'),(396,'👩‍🦼','woman-in-motorized-wheelchair'),(397,'🧑‍🦽','person-in-manual-wheelchair'),(398,'👨‍🦽','man-in-manual-wheelchair'),(399,'👩‍🦽','woman-in-manual-wheelchair'),(400,'🏃','person-running'),(401,'🏃‍♂️','man-running'),(402,'🏃‍♀️','woman-running'),(403,'💃','woman-dancing'),(404,'🕺','man-dancing'),(405,'🕴️','person-in-suit-levitating'),(406,'👯','people-with-bunny-ears'),(407,'👯‍♂️','men-with-bunny-ears'),(408,'👯‍♀️','women-with-bunny-ears'),(409,'🧖','person-in-steamy-room'),(410,'🧖‍♂️','man-in-steamy-room'),(411,'🧖‍♀️','woman-in-steamy-room'),(412,'🧗','person-climbing'),(413,'🧗‍♂️','man-climbing'),(414,'🧗‍♀️','woman-climbing'),(415,'🤺','person-fencing'),(416,'🏇','horse-racing'),(417,'⛷️','skier'),(418,'🏂','snowboarder'),(419,'🏌️','person-golfing'),(420,'🏌️‍♂️','man-golfing'),(421,'🏌️‍♀️','woman-golfing'),(422,'🏄','person-surfing'),(423,'🏄‍♂️','man-surfing'),(424,'🏄‍♀️','woman-surfing'),(425,'🚣','person-rowing-boat'),(426,'🚣‍♂️','man-rowing-boat'),(427,'🚣‍♀️','woman-rowing-boat'),(428,'🏊','person-swimming'),(429,'🏊‍♂️','man-swimming'),(430,'🏊‍♀️','woman-swimming'),(431,'⛹️','person-bouncing-ball'),(432,'⛹️‍♂️','man-bouncing-ball'),(433,'⛹️‍♀️','woman-bouncing-ball'),(434,'🏋️','person-lifting-weights'),(435,'🏋️‍♂️','man-lifting-weights'),(436,'🏋️‍♀️','woman-lifting-weights'),(437,'🚴','person-biking'),(438,'🚴‍♂️','man-biking'),(439,'🚴‍♀️','woman-biking'),(440,'🚵','person-mountain-biking'),(441,'🚵‍♂️','man-mountain-biking'),(442,'🚵‍♀️','woman-mountain-biking'),(443,'🤸','person-cartwheeling'),(444,'🤸‍♂️','man-cartwheeling'),(445,'🤸‍♀️','woman-cartwheeling'),(446,'🤼','people-wrestling'),(447,'🤼‍♂️','men-wrestling'),(448,'🤼‍♀️','women-wrestling'),(449,'🤽','person-playing-water-polo'),(450,'🤽‍♂️','man-playing-water-polo'),(451,'🤽‍♀️','woman-playing-water-polo'),(452,'🤾','person-playing-handball'),(453,'🤾‍♂️','man-playing-handball'),(454,'🤾‍♀️','woman-playing-handball'),(455,'🤹','person-juggling'),(456,'🤹‍♂️','man-juggling'),(457,'🤹‍♀️','woman-juggling'),(458,'🧘','person-in-lotus-position'),(459,'🧘‍♂️','man-in-lotus-position'),(460,'🧘‍♀️','woman-in-lotus-position'),(461,'🛀','person-taking-bath'),(462,'🛌','person-in-bed'),(463,'🧑‍🤝‍🧑','people-holding-hands'),(464,'👭','women-holding-hands'),(465,'👫','woman-and-man-holding-hands'),(466,'👬','men-holding-hands'),(467,'💏','kiss'),(468,'👩‍❤️‍💋‍👨','kiss-woman-man'),(469,'👨‍❤️‍💋‍👨','kiss-man-man'),(470,'👩‍❤️‍💋‍👩','kiss-woman-woman'),(471,'💑','couple-with-heart'),(472,'👩‍❤️‍👨','couple-with-heart-woman-man'),(473,'👨‍❤️‍👨','couple-with-heart-man-man'),(474,'👩‍❤️‍👩','couple-with-heart-woman-woman'),(475,'👪','family'),(476,'👨‍👩‍👦','family-man-woman-boy'),(477,'👨‍👩‍👧','family-man-woman-girl'),(478,'👨‍👩‍👧‍👦','family-man-woman-girl-boy'),(479,'👨‍👩‍👦‍👦','family-man-woman-boy-boy'),(480,'👨‍👩‍👧‍👧','family-man-woman-girl-girl'),(481,'👨‍👨‍👦','family-man-man-boy'),(482,'👨‍👨‍👧','family-man-man-girl'),(483,'👨‍👨‍👧‍👦','family-man-man-girl-boy'),(484,'👨‍👨‍👦‍👦','family-man-man-boy-boy'),(485,'👨‍👨‍👧‍👧','family-man-man-girl-girl'),(486,'👩‍👩‍👦','family-woman-woman-boy'),(487,'👩‍👩‍👧','family-woman-woman-girl'),(488,'👩‍👩‍👧‍👦','family-woman-woman-girl-boy'),(489,'👩‍👩‍👦‍👦','family-woman-woman-boy-boy'),(490,'👩‍👩‍👧‍👧','family-woman-woman-girl-girl'),(491,'👨‍👦','family-man-boy'),(492,'👨‍👦‍👦','family-man-boy-boy'),(493,'👨‍👧','family-man-girl'),(494,'👨‍👧‍👦','family-man-girl-boy'),(495,'👨‍👧‍👧','family-man-girl-girl'),(496,'👩‍👦','family-woman-boy'),(497,'👩‍👦‍👦','family-woman-boy-boy'),(498,'👩‍👧','family-woman-girl'),(499,'👩‍👧‍👦','family-woman-girl-boy'),(500,'👩‍👧‍👧','family-woman-girl-girl'),(501,'🗣️','speaking-head'),(502,'👤','bust-in-silhouette'),(503,'👥','busts-in-silhouette'),(504,'🫂','people-hugging'),(505,'👣','footprints'),(506,'🦰','red-hair'),(507,'🦱','curly-hair'),(508,'🦳','white-hair'),(509,'🦲','bald'),(510,'🐵','monkey-face'),(511,'🐒','monkey'),(512,'🦍','gorilla'),(513,'🦧','orangutan'),(514,'🐶','dog-face'),(515,'🐕','dog'),(516,'🦮','guide-dog'),(517,'🐕‍🦺','service-dog'),(518,'🐩','poodle'),(519,'🐺','wolf'),(520,'🦊','fox'),(521,'🦝','raccoon'),(522,'🐱','cat-face'),(523,'🐈','cat'),(524,'🐈‍⬛','black-cat'),(525,'🦁','lion'),(526,'🐯','tiger-face'),(527,'🐅','tiger'),(528,'🐆','leopard'),(529,'🐴','horse-face'),(530,'🐎','horse'),(531,'🦄','unicorn'),(532,'🦓','zebra'),(533,'🦌','deer'),(534,'🦬','bison'),(535,'🐮','cow-face'),(536,'🐂','ox'),(537,'🐃','water-buffalo'),(538,'🐄','cow'),(539,'🐷','pig-face'),(540,'🐖','pig'),(541,'🐗','boar'),(542,'🐽','pig-nose'),(543,'🐏','ram'),(544,'🐑','ewe'),(545,'🐐','goat'),(546,'🐪','camel'),(547,'🐫','two-hump-camel'),(548,'🦙','llama'),(549,'🦒','giraffe'),(550,'🐘','elephant'),(551,'🦣','mammoth'),(552,'🦏','rhinoceros'),(553,'🦛','hippopotamus'),(554,'🐭','mouse-face'),(555,'🐁','mouse'),(556,'🐀','rat'),(557,'🐹','hamster'),(558,'🐰','rabbit-face'),(559,'🐇','rabbit'),(560,'🐿️','chipmunk'),(561,'🦫','beaver'),(562,'🦔','hedgehog'),(563,'🦇','bat'),(564,'🐻','bear'),(565,'🐻‍❄️','polar-bear'),(566,'🐨','koala'),(567,'🐼','panda'),(568,'🦥','sloth'),(569,'🦦','otter'),(570,'🦨','skunk'),(571,'🦘','kangaroo'),(572,'🦡','badger'),(573,'🐾','paw-prints'),(574,'🦃','turkey'),(575,'🐔','chicken'),(576,'🐓','rooster'),(577,'🐣','hatching-chick'),(578,'🐤','baby-chick'),(579,'🐥','front-facing-baby-chick'),(580,'🐦','bird'),(581,'🐧','penguin'),(582,'🕊️','dove'),(583,'🦅','eagle'),(584,'🦆','duck'),(585,'🦢','swan'),(586,'🦉','owl'),(587,'🦤','dodo'),(588,'🪶','feather'),(589,'🦩','flamingo'),(590,'🦚','peacock'),(591,'🦜','parrot'),(592,'🐸','frog'),(593,'🐊','crocodile'),(594,'🐢','turtle'),(595,'🦎','lizard'),(596,'🐍','snake'),(597,'🐲','dragon-face'),(598,'🐉','dragon'),(599,'🦕','sauropod'),(600,'🦖','t-rex'),(601,'🐳','spouting-whale'),(602,'🐋','whale'),(603,'🐬','dolphin'),(604,'🦭','seal'),(605,'🐟','fish'),(606,'🐠','tropical-fish'),(607,'🐡','blowfish'),(608,'🦈','shark'),(609,'🐙','octopus'),(610,'🐚','spiral-shell'),(611,'🐌','snail'),(612,'🦋','butterfly'),(613,'🐛','bug'),(614,'🐜','ant'),(615,'🐝','honeybee'),(616,'🪲','beetle'),(617,'🐞','lady-beetle'),(618,'🦗','cricket'),(619,'🪳','cockroach'),(620,'🕷️','spider'),(621,'🕸️','spider-web'),(622,'🦂','scorpion'),(623,'🦟','mosquito'),(624,'🪰','fly'),(625,'🪱','worm'),(626,'🦠','microbe'),(627,'💐','bouquet'),(628,'🌸','cherry-blossom'),(629,'💮','white-flower'),(630,'🏵️','rosette'),(631,'🌹','rose'),(632,'🥀','wilted-flower'),(633,'🌺','hibiscus'),(634,'🌻','sunflower'),(635,'🌼','blossom'),(636,'🌷','tulip'),(637,'🌱','seedling'),(638,'🪴','potted-plant'),(639,'🌲','evergreen-tree'),(640,'🌳','deciduous-tree'),(641,'🌴','palm-tree'),(642,'🌵','cactus'),(643,'🌾','sheaf-of-rice'),(644,'🌿','herb'),(645,'☘️','shamrock'),(646,'🍀','four-leaf-clover'),(647,'🍁','maple-leaf'),(648,'🍂','fallen-leaf'),(649,'🍃','leaf-fluttering-in-wind'),(650,'🍇','grapes'),(651,'🍈','melon'),(652,'🍉','watermelon'),(653,'🍊','tangerine'),(654,'🍋','lemon'),(655,'🍌','banana'),(656,'🍍','pineapple'),(657,'🥭','mango'),(658,'🍎','red-apple'),(659,'🍏','green-apple'),(660,'🍐','pear'),(661,'🍑','peach'),(662,'🍒','cherries'),(663,'🍓','strawberry'),(664,'🫐','blueberries'),(665,'🥝','kiwi-fruit'),(666,'🍅','tomato'),(667,'🫒','olive'),(668,'🥥','coconut'),(669,'🥑','avocado'),(670,'🍆','eggplant'),(671,'🥔','potato'),(672,'🥕','carrot'),(673,'🌽','ear-of-corn'),(674,'🌶️','hot-pepper'),(675,'🫑','bell-pepper'),(676,'🥒','cucumber'),(677,'🥬','leafy-green'),(678,'🥦','broccoli'),(679,'🧄','garlic'),(680,'🧅','onion'),(681,'🍄','mushroom'),(682,'🥜','peanuts'),(683,'🌰','chestnut'),(684,'🍞','bread'),(685,'🥐','croissant'),(686,'🥖','baguette-bread'),(687,'🫓','flatbread'),(688,'🥨','pretzel'),(689,'🥯','bagel'),(690,'🥞','pancakes'),(691,'🧇','waffle'),(692,'🧀','cheese-wedge'),(693,'🍖','meat-on-bone'),(694,'🍗','poultry-leg'),(695,'🥩','cut-of-meat'),(696,'🥓','bacon'),(697,'🍔','hamburger'),(698,'🍟','french-fries'),(699,'🍕','pizza'),(700,'🌭','hot-dog'),(701,'🥪','sandwich'),(702,'🌮','taco'),(703,'🌯','burrito'),(704,'🫔','tamale'),(705,'🥙','stuffed-flatbread'),(706,'🧆','falafel'),(707,'🥚','egg'),(708,'🍳','cooking'),(709,'🥘','shallow-pan-of-food'),(710,'🍲','pot-of-food'),(711,'🫕','fondue'),(712,'🥣','bowl-with-spoon'),(713,'🥗','green-salad'),(714,'🍿','popcorn'),(715,'🧈','butter'),(716,'🧂','salt'),(717,'🥫','canned-food'),(718,'🍱','bento-box'),(719,'🍘','rice-cracker'),(720,'🍙','rice-ball'),(721,'🍚','cooked-rice'),(722,'🍛','curry-rice'),(723,'🍜','steaming-bowl'),(724,'🍝','spaghetti'),(725,'🍠','roasted-sweet-potato'),(726,'🍢','oden'),(727,'🍣','sushi'),(728,'🍤','fried-shrimp'),(729,'🍥','fish-cake-with-swirl'),(730,'🥮','moon-cake'),(731,'🍡','dango'),(732,'🥟','dumpling'),(733,'🥠','fortune-cookie'),(734,'🥡','takeout-box'),(735,'🦀','crab'),(736,'🦞','lobster'),(737,'🦐','shrimp'),(738,'🦑','squid'),(739,'🦪','oyster'),(740,'🍦','soft-ice-cream'),(741,'🍧','shaved-ice'),(742,'🍨','ice-cream'),(743,'🍩','doughnut'),(744,'🍪','cookie'),(745,'🎂','birthday-cake'),(746,'🍰','shortcake'),(747,'🧁','cupcake'),(748,'🥧','pie'),(749,'🍫','chocolate-bar'),(750,'🍬','candy'),(751,'🍭','lollipop'),(752,'🍮','custard'),(753,'🍯','honey-pot'),(754,'🍼','baby-bottle'),(755,'🥛','glass-of-milk'),(756,'☕','hot-beverage'),(757,'🫖','teapot'),(758,'🍵','teacup-without-handle'),(759,'🍶','sake'),(760,'🍾','bottle-with-popping-cork'),(761,'🍷','wine-glass'),(762,'🍸','cocktail-glass'),(763,'🍹','tropical-drink'),(764,'🍺','beer-mug'),(765,'🍻','clinking-beer-mugs'),(766,'🥂','clinking-glasses'),(767,'🥃','tumbler-glass'),(768,'🥤','cup-with-straw'),(769,'🧋','bubble-tea'),(770,'🧃','beverage-box'),(771,'🧉','mate'),(772,'🧊','ice'),(773,'🥢','chopsticks'),(774,'🍽️','fork-and-knife-with-plate'),(775,'🍴','fork-and-knife'),(776,'🥄','spoon'),(777,'🔪','kitchen-knife'),(778,'🏺','amphora'),(779,'🌍','globe-showing-europe-africa'),(780,'🌎','globe-showing-americas'),(781,'🌏','globe-showing-asia-australia'),(782,'🌐','globe-with-meridians'),(783,'🗺️','world-map'),(784,'🗾','map-of-japan'),(785,'🧭','compass'),(786,'🏔️','snow-capped-mountain'),(787,'⛰️','mountain'),(788,'🌋','volcano'),(789,'🗻','mount-fuji'),(790,'🏕️','camping'),(791,'🏖️','beach-with-umbrella'),(792,'🏜️','desert'),(793,'🏝️','desert-island'),(794,'🏞️','national-park'),(795,'🏟️','stadium'),(796,'🏛️','classical-building'),(797,'🏗️','building-construction'),(798,'🧱','brick'),(799,'🪨','rock'),(800,'🪵','wood'),(801,'🛖','hut'),(802,'🏘️','houses'),(803,'🏚️','derelict-house'),(804,'🏠','house'),(805,'🏡','house-with-garden'),(806,'🏢','office-building'),(807,'🏣','japanese-post-office'),(808,'🏤','post-office'),(809,'🏥','hospital'),(810,'🏦','bank'),(811,'🏨','hotel'),(812,'🏩','love-hotel'),(813,'🏪','convenience-store'),(814,'🏫','school'),(815,'🏬','department-store'),(816,'🏭','factory'),(817,'🏯','japanese-castle'),(818,'🏰','castle'),(819,'💒','wedding'),(820,'🗼','tokyo-tower'),(821,'🗽','statue-of-liberty'),(822,'⛪','church'),(823,'🕌','mosque'),(824,'🛕','hindu-temple'),(825,'🕍','synagogue'),(826,'⛩️','shinto-shrine'),(827,'🕋','kaaba'),(828,'⛲','fountain'),(829,'⛺','tent'),(830,'🌁','foggy'),(831,'🌃','night-with-stars'),(832,'🏙️','cityscape'),(833,'🌄','sunrise-over-mountains'),(834,'🌅','sunrise'),(835,'🌆','cityscape-at-dusk'),(836,'🌇','sunset'),(837,'🌉','bridge-at-night'),(838,'♨️','hot-springs'),(839,'🎠','carousel-horse'),(840,'🎡','ferris-wheel'),(841,'🎢','roller-coaster'),(842,'💈','barber-pole'),(843,'🎪','circus-tent'),(844,'🚂','locomotive'),(845,'🚃','railway-car'),(846,'🚄','high-speed-train'),(847,'🚅','bullet-train'),(848,'🚆','train'),(849,'🚇','metro'),(850,'🚈','light-rail'),(851,'🚉','station'),(852,'🚊','tram'),(853,'🚝','monorail'),(854,'🚞','mountain-railway'),(855,'🚋','tram-car'),(856,'🚌','bus'),(857,'🚍','oncoming-bus'),(858,'🚎','trolleybus'),(859,'🚐','minibus'),(860,'🚑','ambulance'),(861,'🚒','fire-engine'),(862,'🚓','police-car'),(863,'🚔','oncoming-police-car'),(864,'🚕','taxi'),(865,'🚖','oncoming-taxi'),(866,'🚗','automobile'),(867,'🚘','oncoming-automobile'),(868,'🚙','sport-utility-vehicle'),(869,'🛻','pickup-truck'),(870,'🚚','delivery-truck'),(871,'🚛','articulated-lorry'),(872,'🚜','tractor'),(873,'🏎️','racing-car'),(874,'🏍️','motorcycle'),(875,'🛵','motor-scooter'),(876,'🦽','manual-wheelchair'),(877,'🦼','motorized-wheelchair'),(878,'🛺','auto-rickshaw'),(879,'🚲','bicycle'),(880,'🛴','kick-scooter'),(881,'🛹','skateboard'),(882,'🛼','roller-skate'),(883,'🚏','bus-stop'),(884,'🛣️','motorway'),(885,'🛤️','railway-track'),(886,'🛢️','oil-drum'),(887,'⛽','fuel-pump'),(888,'🚨','police-car-light'),(889,'🚥','horizontal-traffic-light'),(890,'🚦','vertical-traffic-light'),(891,'🛑','stop-sign'),(892,'🚧','construction'),(893,'⚓','anchor'),(894,'⛵','sailboat'),(895,'🛶','canoe'),(896,'🚤','speedboat'),(897,'🛳️','passenger-ship'),(898,'⛴️','ferry'),(899,'🛥️','motor-boat'),(900,'🚢','ship'),(901,'✈️','airplane'),(902,'🛩️','small-airplane'),(903,'🛫','airplane-departure'),(904,'🛬','airplane-arrival'),(905,'🪂','parachute'),(906,'💺','seat'),(907,'🚁','helicopter'),(908,'🚟','suspension-railway'),(909,'🚠','mountain-cableway'),(910,'🚡','aerial-tramway'),(911,'🛰️','satellite'),(912,'🚀','rocket'),(913,'🛸','flying-saucer'),(914,'🛎️','bellhop-bell'),(915,'🧳','luggage'),(916,'⌛','hourglass-done'),(917,'⏳','hourglass-not-done'),(918,'⌚','watch'),(919,'⏰','alarm-clock'),(920,'⏱️','stopwatch'),(921,'⏲️','timer-clock'),(922,'🕰️','mantelpiece-clock'),(923,'🕛','twelve-o-clock'),(924,'🕧','twelve-thirty'),(925,'🕐','one-o-clock'),(926,'🕜','one-thirty'),(927,'🕑','two-o-clock'),(928,'🕝','two-thirty'),(929,'🕒','three-o-clock'),(930,'🕞','three-thirty'),(931,'🕓','four-o-clock'),(932,'🕟','four-thirty'),(933,'🕔','five-o-clock'),(934,'🕠','five-thirty'),(935,'🕕','six-o-clock'),(936,'🕡','six-thirty'),(937,'🕖','seven-o-clock'),(938,'🕢','seven-thirty'),(939,'🕗','eight-o-clock'),(940,'🕣','eight-thirty'),(941,'🕘','nine-o-clock'),(942,'🕤','nine-thirty'),(943,'🕙','ten-o-clock'),(944,'🕥','ten-thirty'),(945,'🕚','eleven-o-clock'),(946,'🕦','eleven-thirty'),(947,'🌑','new-moon'),(948,'🌒','waxing-crescent-moon'),(949,'🌓','first-quarter-moon'),(950,'🌔','waxing-gibbous-moon'),(951,'🌕','full-moon'),(952,'🌖','waning-gibbous-moon'),(953,'🌗','last-quarter-moon'),(954,'🌘','waning-crescent-moon'),(955,'🌙','crescent-moon'),(956,'🌚','new-moon-face'),(957,'🌛','first-quarter-moon-face'),(958,'🌜','last-quarter-moon-face'),(959,'🌡️','thermometer'),(960,'☀️','sun'),(961,'🌝','full-moon-face'),(962,'🌞','sun-with-face'),(963,'🪐','ringed-planet'),(964,'⭐','star'),(965,'🌟','glowing-star'),(966,'🌠','shooting-star'),(967,'🌌','milky-way'),(968,'☁️','cloud'),(969,'⛅','sun-behind-cloud'),(970,'⛈️','cloud-with-lightning-and-rain'),(971,'🌤️','sun-behind-small-cloud'),(972,'🌥️','sun-behind-large-cloud'),(973,'🌦️','sun-behind-rain-cloud'),(974,'🌧️','cloud-with-rain'),(975,'🌨️','cloud-with-snow'),(976,'🌩️','cloud-with-lightning'),(977,'🌪️','tornado'),(978,'🌫️','fog'),(979,'🌬️','wind-face'),(980,'🌀','cyclone'),(981,'🌈','rainbow'),(982,'🌂','closed-umbrella'),(983,'☂️','umbrella'),(984,'☔','umbrella-with-rain-drops'),(985,'⛱️','umbrella-on-ground'),(986,'⚡','high-voltage'),(987,'❄️','snowflake'),(988,'☃️','snowman'),(989,'⛄','snowman-without-snow'),(990,'☄️','comet'),(991,'🔥','fire'),(992,'💧','droplet'),(993,'🌊','water-wave'),(994,'🎃','jack-o-lantern'),(995,'🎄','christmas-tree'),(996,'🎆','fireworks'),(997,'🎇','sparkler'),(998,'🧨','firecracker'),(999,'✨','sparkles'),(1000,'🎈','balloon'),(1001,'🎉','party-popper'),(1002,'🎊','confetti-ball'),(1003,'🎋','tanabata-tree'),(1004,'🎍','pine-decoration'),(1005,'🎎','japanese-dolls'),(1006,'🎏','carp-streamer'),(1007,'🎐','wind-chime'),(1008,'🎑','moon-viewing-ceremony'),(1009,'🧧','red-envelope'),(1010,'🎀','ribbon'),(1011,'🎁','wrapped-gift'),(1012,'🎗️','reminder-ribbon'),(1013,'🎟️','admission-tickets'),(1014,'🎫','ticket'),(1015,'🎖️','military-medal'),(1016,'🏆','trophy'),(1017,'🏅','sports-medal'),(1018,'🥇','1st-place-medal'),(1019,'🥈','2nd-place-medal'),(1020,'🥉','3rd-place-medal'),(1021,'⚽','soccer-ball'),(1022,'⚾','baseball'),(1023,'🥎','softball'),(1024,'🏀','basketball'),(1025,'🏐','volleyball'),(1026,'🏈','american-football'),(1027,'🏉','rugby-football'),(1028,'🎾','tennis'),(1029,'🥏','flying-disc'),(1030,'🎳','bowling'),(1031,'🏏','cricket-game'),(1032,'🏑','field-hockey'),(1033,'🏒','ice-hockey'),(1034,'🥍','lacrosse'),(1035,'🏓','ping-pong'),(1036,'🏸','badminton'),(1037,'🥊','boxing-glove'),(1038,'🥋','martial-arts-uniform'),(1039,'🥅','goal-net'),(1040,'⛳','flag-in-hole'),(1041,'⛸️','ice-skate'),(1042,'🎣','fishing-pole'),(1043,'🤿','diving-mask'),(1044,'🎽','running-shirt'),(1045,'🎿','skis'),(1046,'🛷','sled'),(1047,'🥌','curling-stone'),(1048,'🎯','bullseye'),(1049,'🪀','yo-yo'),(1050,'🪁','kite'),(1051,'🎱','pool-8-ball'),(1052,'🔮','crystal-ball'),(1053,'🪄','magic-wand'),(1054,'🧿','nazar-amulet'),(1055,'🎮','video-game'),(1056,'🕹️','joystick'),(1057,'🎰','slot-machine'),(1058,'🎲','game-die'),(1059,'🧩','puzzle-piece'),(1060,'🧸','teddy-bear'),(1062,'🪆','nesting-dolls'),(1063,'♠️','spade-suit'),(1064,'♥️','heart-suit'),(1065,'♦️','diamond-suit'),(1066,'♣️','club-suit'),(1067,'♟️','chess-pawn'),(1068,'🃏','joker'),(1069,'🀄','mahjong-red-dragon'),(1070,'🎴','flower-playing-cards'),(1071,'🎭','performing-arts'),(1072,'🖼️','framed-picture'),(1073,'🎨','artist-palette'),(1074,'🧵','thread'),(1075,'🪡','sewing-needle'),(1076,'🧶','yarn'),(1077,'🪢','knot'),(1078,'👓','glasses'),(1079,'🕶️','sunglasses'),(1080,'🥽','goggles'),(1081,'🥼','lab-coat'),(1082,'🦺','safety-vest'),(1083,'👔','necktie'),(1084,'👕','t-shirt'),(1085,'👖','jeans'),(1086,'🧣','scarf'),(1087,'🧤','gloves'),(1088,'🧥','coat'),(1089,'🧦','socks'),(1090,'👗','dress'),(1091,'👘','kimono'),(1092,'🥻','sari'),(1093,'🩱','one-piece-swimsuit'),(1094,'🩲','briefs'),(1095,'🩳','shorts'),(1096,'👙','bikini'),(1097,'👚','woman-s-clothes'),(1098,'👛','purse'),(1099,'👜','handbag'),(1100,'👝','clutch-bag'),(1101,'🛍️','shopping-bags'),(1102,'🎒','backpack'),(1103,'🩴','thong-sandal'),(1104,'👞','man-s-shoe'),(1105,'👟','running-shoe'),(1106,'🥾','hiking-boot'),(1107,'🥿','flat-shoe'),(1108,'👠','high-heeled-shoe'),(1109,'👡','woman-s-sandal'),(1110,'🩰','ballet-shoes'),(1111,'👢','woman-s-boot'),(1112,'👑','crown'),(1113,'👒','woman-s-hat'),(1114,'🎩','top-hat'),(1115,'🎓','graduation-cap'),(1116,'🧢','billed-cap'),(1117,'🪖','military-helmet'),(1118,'⛑️','rescue-worker-s-helmet'),(1119,'📿','prayer-beads'),(1120,'💄','lipstick'),(1121,'💍','ring'),(1122,'💎','gem-stone'),(1123,'🔇','muted-speaker'),(1124,'🔈','speaker-low-volume'),(1125,'🔉','speaker-medium-volume'),(1126,'🔊','speaker-high-volume'),(1127,'📢','loudspeaker'),(1128,'📣','megaphone'),(1129,'📯','postal-horn'),(1130,'🔔','bell'),(1131,'🔕','bell-with-slash'),(1132,'🎼','musical-score'),(1133,'🎵','musical-note'),(1134,'🎶','musical-notes'),(1135,'🎙️','studio-microphone'),(1136,'🎚️','level-slider'),(1137,'🎛️','control-knobs'),(1138,'🎤','microphone'),(1139,'🎧','headphone'),(1140,'📻','radio'),(1141,'🎷','saxophone'),(1142,'🪗','accordion'),(1143,'🎸','guitar'),(1144,'🎹','musical-keyboard'),(1145,'🎺','trumpet'),(1146,'🎻','violin'),(1147,'🪕','banjo'),(1148,'🥁','drum'),(1149,'🪘','long-drum'),(1150,'📱','mobile-phone'),(1151,'📲','mobile-phone-with-arrow'),(1152,'☎️','telephone'),(1153,'📞','telephone-receiver'),(1154,'📟','pager'),(1155,'📠','fax-machine'),(1156,'🔋','battery'),(1157,'🔌','electric-plug'),(1158,'💻','laptop'),(1159,'🖥️','desktop-computer'),(1160,'🖨️','printer'),(1161,'⌨️','keyboard'),(1162,'🖱️','computer-mouse'),(1163,'🖲️','trackball'),(1164,'💽','computer-disk'),(1165,'💾','floppy-disk'),(1166,'💿','optical-disk'),(1167,'📀','dvd'),(1168,'🧮','abacus'),(1169,'🎥','movie-camera'),(1170,'🎞️','film-frames'),(1171,'📽️','film-projector'),(1172,'🎬','clapper-board'),(1173,'📺','television'),(1174,'📷','camera'),(1175,'📸','camera-with-flash'),(1176,'📹','video-camera'),(1177,'📼','videocassette'),(1178,'🔍','magnifying-glass-tilted-left'),(1179,'🔎','magnifying-glass-tilted-right'),(1180,'🕯️','candle'),(1181,'💡','light-bulb'),(1182,'🔦','flashlight'),(1183,'🏮','red-paper-lantern'),(1184,'🪔','diya-lamp'),(1185,'📔','notebook-with-decorative-cover'),(1186,'📕','closed-book'),(1187,'📖','open-book'),(1188,'📗','green-book'),(1189,'📘','blue-book'),(1190,'📙','orange-book'),(1191,'📚','books'),(1192,'📓','notebook'),(1193,'📒','ledger'),(1194,'📃','page-with-curl'),(1195,'📜','scroll'),(1196,'📄','page-facing-up'),(1197,'📰','newspaper'),(1198,'🗞️','rolled-up-newspaper'),(1199,'📑','bookmark-tabs'),(1200,'🔖','bookmark'),(1201,'🏷️','label'),(1202,'💰','money-bag'),(1203,'🪙','coin'),(1204,'💴','yen-banknote'),(1205,'💵','dollar-banknote'),(1206,'💶','euro-banknote'),(1207,'💷','pound-banknote'),(1208,'💸','money-with-wings'),(1209,'💳','credit-card'),(1210,'🧾','receipt'),(1211,'💹','chart-increasing-with-yen'),(1212,'✉️','envelope'),(1213,'📧','e-mail'),(1214,'📨','incoming-envelope'),(1215,'📩','envelope-with-arrow'),(1216,'📤','outbox-tray'),(1217,'📥','inbox-tray'),(1218,'📦','package'),(1219,'📫','closed-mailbox-with-raised-flag'),(1220,'📪','closed-mailbox-with-lowered-flag'),(1221,'📬','open-mailbox-with-raised-flag'),(1222,'📭','open-mailbox-with-lowered-flag'),(1223,'📮','postbox'),(1224,'🗳️','ballot-box-with-ballot'),(1225,'✏️','pencil'),(1226,'✒️','black-nib'),(1227,'🖋️','fountain-pen'),(1228,'🖊️','pen'),(1229,'🖌️','paintbrush'),(1230,'🖍️','crayon'),(1231,'📝','memo'),(1232,'💼','briefcase'),(1233,'📁','file-folder'),(1234,'📂','open-file-folder'),(1235,'🗂️','card-index-dividers'),(1236,'📅','calendar'),(1237,'📆','tear-off-calendar'),(1238,'🗒️','spiral-notepad'),(1239,'🗓️','spiral-calendar'),(1240,'📇','card-index'),(1241,'📈','chart-increasing'),(1242,'📉','chart-decreasing'),(1243,'📊','bar-chart'),(1244,'📋','clipboard'),(1245,'📌','pushpin'),(1246,'📍','round-pushpin'),(1247,'📎','paperclip'),(1248,'🖇️','linked-paperclips'),(1249,'📏','straight-ruler'),(1250,'📐','triangular-ruler'),(1251,'✂️','scissors'),(1252,'🗃️','card-file-box'),(1253,'🗄️','file-cabinet'),(1254,'🗑️','wastebasket'),(1255,'🔒','locked'),(1256,'🔓','unlocked'),(1257,'🔏','locked-with-pen'),(1258,'🔐','locked-with-key'),(1259,'🔑','key'),(1260,'🗝️','old-key'),(1261,'🔨','hammer'),(1262,'🪓','axe'),(1263,'⛏️','pick'),(1264,'⚒️','hammer-and-pick'),(1265,'🛠️','hammer-and-wrench'),(1266,'🗡️','dagger'),(1267,'⚔️','crossed-swords'),(1268,'🔫','water-pistol'),(1269,'🪃','boomerang'),(1270,'🏹','bow-and-arrow'),(1271,'🛡️','shield'),(1272,'🪚','carpentry-saw'),(1273,'🔧','wrench'),(1274,'🪛','screwdriver'),(1275,'🔩','nut-and-bolt'),(1276,'⚙️','gear'),(1277,'🗜️','clamp'),(1278,'⚖️','balance-scale'),(1279,'🦯','white-cane'),(1280,'🔗','link'),(1281,'⛓️','chains'),(1282,'🪝','hook'),(1283,'🧰','toolbox'),(1284,'🧲','magnet'),(1285,'🪜','ladder'),(1286,'⚗️','alembic'),(1287,'🧪','test-tube'),(1288,'🧫','petri-dish'),(1289,'🧬','dna'),(1290,'🔬','microscope'),(1291,'🔭','telescope'),(1292,'📡','satellite-antenna'),(1293,'💉','syringe'),(1294,'🩸','drop-of-blood'),(1295,'💊','pill'),(1296,'🩹','adhesive-bandage'),(1297,'🩺','stethoscope'),(1298,'🚪','door'),(1299,'🛗','elevator'),(1300,'🪞','mirror'),(1301,'🪟','window'),(1302,'🛏️','bed'),(1303,'🛋️','couch-and-lamp'),(1304,'🪑','chair'),(1305,'🚽','toilet'),(1306,'🪠','plunger'),(1307,'🚿','shower'),(1308,'🛁','bathtub'),(1309,'🪤','mouse-trap'),(1310,'🪒','razor'),(1311,'🧴','lotion-bottle'),(1312,'🧷','safety-pin'),(1313,'🧹','broom'),(1314,'🧺','basket'),(1315,'🧻','roll-of-paper'),(1316,'🪣','bucket'),(1317,'🧼','soap'),(1318,'🪥','toothbrush'),(1319,'🧽','sponge'),(1320,'🧯','fire-extinguisher'),(1321,'🛒','shopping-cart'),(1322,'🚬','cigarette'),(1323,'⚰️','coffin'),(1324,'🪦','headstone'),(1325,'⚱️','funeral-urn'),(1326,'🗿','moai'),(1327,'🪧','placard'),(1328,'🏧','atm-sign'),(1329,'🚮','litter-in-bin-sign'),(1330,'🚰','potable-water'),(1331,'♿','wheelchair-symbol'),(1332,'🚹','men-s-room'),(1333,'🚺','women-s-room'),(1334,'🚻','restroom'),(1335,'🚼','baby-symbol'),(1336,'🚾','water-closet'),(1337,'🛂','passport-control'),(1338,'🛃','customs'),(1339,'🛄','baggage-claim'),(1340,'🛅','left-luggage'),(1341,'⚠️','warning'),(1342,'🚸','children-crossing'),(1343,'⛔','no-entry'),(1344,'🚫','prohibited'),(1345,'🚳','no-bicycles'),(1346,'🚭','no-smoking'),(1347,'🚯','no-littering'),(1348,'🚱','non-potable-water'),(1349,'🚷','no-pedestrians'),(1350,'📵','no-mobile-phones'),(1351,'🔞','no-one-under-eighteen'),(1352,'☢️','radioactive'),(1353,'☣️','biohazard'),(1354,'⬆️','up-arrow'),(1355,'↗️','up-right-arrow'),(1356,'➡️','right-arrow'),(1357,'↘️','down-right-arrow'),(1358,'⬇️','down-arrow'),(1359,'↙️','down-left-arrow'),(1360,'⬅️','left-arrow'),(1361,'↖️','up-left-arrow'),(1362,'↕️','up-down-arrow'),(1363,'↔️','left-right-arrow'),(1364,'↩️','right-arrow-curving-left'),(1365,'↪️','left-arrow-curving-right'),(1366,'⤴️','right-arrow-curving-up'),(1367,'⤵️','right-arrow-curving-down'),(1368,'🔃','clockwise-vertical-arrows'),(1369,'🔄','counterclockwise-arrows-button'),(1370,'🔙','back-arrow'),(1371,'🔚','end-arrow'),(1372,'🔛','on-arrow'),(1373,'🔜','soon-arrow'),(1374,'🔝','top-arrow'),(1375,'🛐','place-of-worship'),(1376,'⚛️','atom-symbol'),(1377,'🕉️','om'),(1378,'✡️','star-of-david'),(1379,'☸️','wheel-of-dharma'),(1380,'☯️','yin-yang'),(1381,'✝️','latin-cross'),(1382,'☦️','orthodox-cross'),(1383,'☪️','star-and-crescent'),(1384,'☮️','peace-symbol'),(1385,'🕎','menorah'),(1386,'🔯','dotted-six-pointed-star'),(1387,'♈','aries'),(1388,'♉','taurus'),(1389,'♊','gemini'),(1390,'♋','cancer'),(1391,'♌','leo'),(1392,'♍','virgo'),(1393,'♎','libra'),(1394,'♏','scorpio'),(1395,'♐','sagittarius'),(1396,'♑','capricorn'),(1397,'♒','aquarius'),(1398,'♓','pisces'),(1399,'⛎','ophiuchus'),(1400,'🔀','shuffle-tracks-button'),(1401,'🔁','repeat-button'),(1402,'🔂','repeat-single-button'),(1403,'▶️','play-button'),(1404,'⏩','fast-forward-button'),(1405,'⏭️','next-track-button'),(1406,'⏯️','play-or-pause-button'),(1407,'◀️','reverse-button'),(1408,'⏪','fast-reverse-button'),(1409,'⏮️','last-track-button'),(1410,'🔼','upwards-button'),(1411,'⏫','fast-up-button'),(1412,'🔽','downwards-button'),(1413,'⏬','fast-down-button'),(1414,'⏸️','pause-button'),(1415,'⏹️','stop-button'),(1416,'⏺️','record-button'),(1417,'⏏️','eject-button'),(1418,'🎦','cinema'),(1419,'🔅','dim-button'),(1420,'🔆','bright-button'),(1421,'📶','antenna-bars'),(1422,'📳','vibration-mode'),(1423,'📴','mobile-phone-off'),(1424,'♀️','female-sign'),(1425,'♂️','male-sign'),(1426,'⚧️','transgender-symbol'),(1427,'✖️','multiply'),(1428,'➕','plus'),(1429,'➖','minus'),(1430,'➗','divide'),(1431,'♾️','infinity'),(1432,'‼️','double-exclamation-mark'),(1433,'⁉️','exclamation-question-mark'),(1434,'❓','red-question-mark'),(1435,'❔','white-question-mark'),(1436,'❕','white-exclamation-mark'),(1437,'❗','red-exclamation-mark'),(1438,'〰️','wavy-dash'),(1439,'💱','currency-exchange'),(1440,'💲','heavy-dollar-sign'),(1441,'⚕️','medical-symbol'),(1442,'♻️','recycling-symbol'),(1443,'⚜️','fleur-de-lis'),(1444,'🔱','trident-emblem'),(1445,'📛','name-badge'),(1446,'🔰','japanese-symbol-for-beginner'),(1447,'⭕','hollow-red-circle'),(1448,'✅','check-mark-button'),(1449,'☑️','check-box-with-check'),(1450,'✔️','check-mark'),(1451,'❌','cross-mark'),(1452,'❎','cross-mark-button'),(1453,'➰','curly-loop'),(1454,'➿','double-curly-loop'),(1455,'〽️','part-alternation-mark'),(1456,'✳️','eight-spoked-asterisk'),(1457,'✴️','eight-pointed-star'),(1458,'❇️','sparkle'),(1459,'©️','copyright'),(1460,'®️','registered'),(1461,'™️','trade-mark'),(1462,'0️⃣','keycap-0'),(1463,'1️⃣','keycap-1'),(1464,'2️⃣','keycap-2'),(1465,'3️⃣','keycap-3'),(1466,'4️⃣','keycap-4'),(1467,'5️⃣','keycap-5'),(1468,'6️⃣','keycap-6'),(1469,'7️⃣','keycap-7'),(1470,'8️⃣','keycap-8'),(1471,'9️⃣','keycap-9'),(1472,'🔟','keycap-10'),(1473,'🔠','input-latin-uppercase'),(1474,'🔡','input-latin-lowercase'),(1475,'🔢','input-numbers'),(1476,'🔣','input-symbols'),(1477,'🔤','input-latin-letters'),(1478,'🅰️','a-button-blood-type'),(1479,'🆎','ab-button-blood-type'),(1480,'🅱️','b-button-blood-type'),(1481,'🆑','cl-button'),(1482,'🆒','cool-button'),(1483,'🆓','free-button'),(1484,'ℹ️','information'),(1485,'🆔','id-button'),(1486,'Ⓜ️','circled-m'),(1487,'🆕','new-button'),(1488,'🆖','ng-button'),(1489,'🅾️','o-button-blood-type'),(1490,'🆗','ok-button'),(1491,'🅿️','p-button'),(1492,'🆘','sos-button'),(1493,'🆙','up-button'),(1494,'🆚','vs-button'),(1495,'🈁','japanese-here-button'),(1496,'🈂️','japanese-service-charge-button'),(1497,'🈷️','japanese-monthly-amount-button'),(1498,'🈶','japanese-not-free-of-charge-button'),(1499,'🈯','japanese-reserved-button'),(1500,'🉐','japanese-bargain-button'),(1501,'🈹','japanese-discount-button'),(1502,'🈚','japanese-free-of-charge-button'),(1503,'🈲','japanese-prohibited-button'),(1504,'🉑','japanese-acceptable-button'),(1505,'🈸','japanese-application-button'),(1506,'🈴','japanese-passing-grade-button'),(1507,'🈳','japanese-vacancy-button'),(1508,'㊗️','japanese-congratulations-button'),(1509,'㊙️','japanese-secret-button'),(1510,'🈺','japanese-open-for-business-button'),(1511,'🈵','japanese-no-vacancy-button'),(1512,'🔴','red-circle'),(1513,'🟠','orange-circle'),(1514,'🟡','yellow-circle'),(1515,'🟢','green-circle'),(1516,'🔵','blue-circle'),(1517,'🟣','purple-circle'),(1518,'🟤','brown-circle'),(1519,'⚫','black-circle'),(1520,'⚪','white-circle'),(1521,'🟥','red-square'),(1522,'🟧','orange-square'),(1523,'🟨','yellow-square'),(1524,'🟩','green-square'),(1525,'🟦','blue-square'),(1526,'🟪','purple-square'),(1527,'🟫','brown-square'),(1528,'⬛','black-large-square'),(1529,'⬜','white-large-square'),(1530,'◼️','black-medium-square'),(1531,'◻️','white-medium-square'),(1532,'◾','black-medium-small-square'),(1533,'◽','white-medium-small-square'),(1534,'▪️','black-small-square'),(1535,'▫️','white-small-square'),(1536,'🔶','large-orange-diamond'),(1537,'🔷','large-blue-diamond'),(1538,'🔸','small-orange-diamond'),(1539,'🔹','small-blue-diamond'),(1540,'🔺','red-triangle-pointed-up'),(1541,'🔻','red-triangle-pointed-down'),(1542,'💠','diamond-with-a-dot'),(1543,'🔘','radio-button'),(1544,'🔳','white-square-button'),(1545,'🔲','black-square-button'),(1546,'🏁','chequered-flag'),(1547,'🚩','triangular-flag'),(1548,'🎌','crossed-flags'),(1549,'🏴','black-flag'),(1550,'🏳️','white-flag'),(1551,'🏳️‍🌈','rainbow-flag'),(1552,'🏳️‍⚧️','transgender-flag'),(1553,'🏴‍☠️','pirate-flag'),(1554,'🇦🇨','flag-ascension-island'),(1555,'🇦🇩','flag-andorra'),(1556,'🇦🇪','flag-united-arab-emirates'),(1557,'🇦🇫','flag-afghanistan'),(1558,'🇦🇬','flag-antigua-barbuda'),(1559,'🇦🇮','flag-anguilla'),(1560,'🇦🇱','flag-albania'),(1561,'🇦🇲','flag-armenia'),(1562,'🇦🇴','flag-angola'),(1563,'🇦🇶','flag-antarctica'),(1564,'🇦🇷','flag-argentina'),(1565,'🇦🇸','flag-american-samoa'),(1566,'🇦🇹','flag-austria'),(1567,'🇦🇺','flag-australia'),(1568,'🇦🇼','flag-aruba'),(1569,'🇦🇿','flag-azerbaijan'),(1570,'🇧🇦','flag-bosnia-herzegovina'),(1571,'🇧🇧','flag-barbados'),(1572,'🇧🇩','flag-bangladesh'),(1573,'🇧🇪','flag-belgium'),(1574,'🇧🇫','flag-burkina-faso'),(1575,'🇧🇬','flag-bulgaria'),(1576,'🇧🇭','flag-bahrain'),(1577,'🇧🇮','flag-burundi'),(1578,'🇧🇯','flag-benin'),(1579,'🇧🇲','flag-bermuda'),(1580,'🇧🇳','flag-brunei'),(1581,'🇧🇴','flag-bolivia'),(1582,'🇧🇶','flag-caribbean-netherlands'),(1583,'🇧🇷','flag-brazil'),(1584,'🇧🇸','flag-bahamas'),(1585,'🇧🇹','flag-bhutan'),(1586,'🇧🇻','flag-bouvet-island'),(1587,'🇧🇼','flag-botswana'),(1588,'🇧🇾','flag-belarus'),(1589,'🇧🇿','flag-belize'),(1590,'🇨🇦','flag-canada'),(1591,'🇨🇨','flag-cocos-keeling-islands'),(1592,'🇨🇩','flag-congo-kinshasa'),(1593,'🇨🇫','flag-central-african-republic'),(1594,'🇨🇬','flag-congo-brazzaville'),(1595,'🇨🇭','flag-switzerland'),(1596,'🇨🇰','flag-cook-islands'),(1597,'🇨🇱','flag-chile'),(1598,'🇨🇲','flag-cameroon'),(1599,'🇨🇳','flag-china'),(1600,'🇨🇴','flag-colombia'),(1601,'🇨🇵','flag-clipperton-island'),(1602,'🇨🇷','flag-costa-rica'),(1603,'🇨🇺','flag-cuba'),(1604,'🇨🇻','flag-cape-verde'),(1605,'🇨🇽','flag-christmas-island'),(1606,'🇨🇾','flag-cyprus'),(1607,'🇨🇿','flag-czechia'),(1608,'🇩🇪','flag-germany'),(1609,'🇩🇬','flag-diego-garcia'),(1610,'🇩🇯','flag-djibouti'),(1611,'🇩🇰','flag-denmark'),(1612,'🇩🇲','flag-dominica'),(1613,'🇩🇴','flag-dominican-republic'),(1614,'🇩🇿','flag-algeria'),(1615,'🇪🇦','flag-ceuta-melilla'),(1616,'🇪🇨','flag-ecuador'),(1617,'🇪🇪','flag-estonia'),(1618,'🇪🇬','flag-egypt'),(1619,'🇪🇭','flag-western-sahara'),(1620,'🇪🇷','flag-eritrea'),(1621,'🇪🇸','flag-spain'),(1622,'🇪🇹','flag-ethiopia'),(1623,'🇪🇺','flag-european-union'),(1624,'🇫🇮','flag-finland'),(1625,'🇫🇯','flag-fiji'),(1626,'🇫🇰','flag-falkland-islands'),(1627,'🇫🇲','flag-micronesia'),(1628,'🇫🇴','flag-faroe-islands'),(1629,'🇫🇷','flag-france'),(1630,'🇬🇦','flag-gabon'),(1631,'🇬🇧','flag-united-kingdom'),(1632,'🇬🇩','flag-grenada'),(1633,'🇬🇪','flag-georgia'),(1634,'🇬🇫','flag-french-guiana'),(1635,'🇬🇬','flag-guernsey'),(1636,'🇬🇭','flag-ghana'),(1637,'🇬🇮','flag-gibraltar'),(1638,'🇬🇱','flag-greenland'),(1639,'🇬🇲','flag-gambia'),(1640,'🇬🇳','flag-guinea'),(1641,'🇬🇵','flag-guadeloupe'),(1642,'🇬🇶','flag-equatorial-guinea'),(1643,'🇬🇷','flag-greece'),(1644,'🇬🇸','flag-south-georgia-south-sandwich-islands'),(1645,'🇬🇹','flag-guatemala'),(1646,'🇬🇺','flag-guam'),(1647,'🇬🇼','flag-guinea-bissau'),(1648,'🇬🇾','flag-guyana'),(1649,'🇭🇰','flag-hong-kong-sar-china'),(1650,'🇭🇲','flag-heard-mcdonald-islands'),(1651,'🇭🇳','flag-honduras'),(1652,'🇭🇷','flag-croatia'),(1653,'🇭🇹','flag-haiti'),(1654,'🇭🇺','flag-hungary'),(1655,'🇮🇨','flag-canary-islands'),(1656,'🇮🇩','flag-indonesia'),(1657,'🇮🇪','flag-ireland'),(1658,'🇮🇱','flag-israel'),(1659,'🇮🇲','flag-isle-of-man'),(1660,'🇮🇳','flag-india'),(1661,'🇮🇴','flag-british-indian-ocean-territory'),(1662,'🇮🇶','flag-iraq'),(1663,'🇮🇷','flag-iran'),(1664,'🇮🇸','flag-iceland'),(1665,'🇮🇹','flag-italy'),(1666,'🇯🇪','flag-jersey'),(1667,'🇯🇲','flag-jamaica'),(1668,'🇯🇴','flag-jordan'),(1669,'🇯🇵','flag-japan'),(1670,'🇰🇪','flag-kenya'),(1671,'🇰🇬','flag-kyrgyzstan'),(1672,'🇰🇭','flag-cambodia'),(1673,'🇰🇮','flag-kiribati'),(1674,'🇰🇲','flag-comoros'),(1675,'🇰🇵','flag-north-korea'),(1676,'🇰🇷','flag-south-korea'),(1677,'🇰🇼','flag-kuwait'),(1678,'🇰🇾','flag-cayman-islands'),(1679,'🇰🇿','flag-kazakhstan'),(1680,'🇱🇦','flag-laos'),(1681,'🇱🇧','flag-lebanon'),(1682,'🇱🇮','flag-liechtenstein'),(1683,'🇱🇰','flag-sri-lanka'),(1684,'🇱🇷','flag-liberia'),(1685,'🇱🇸','flag-lesotho'),(1686,'🇱🇹','flag-lithuania'),(1687,'🇱🇺','flag-luxembourg'),(1688,'🇱🇻','flag-latvia'),(1689,'🇱🇾','flag-libya'),(1690,'🇲🇦','flag-morocco'),(1691,'🇲🇨','flag-monaco'),(1692,'🇲🇩','flag-moldova'),(1693,'🇲🇪','flag-montenegro'),(1694,'🇲🇬','flag-madagascar'),(1695,'🇲🇭','flag-marshall-islands'),(1696,'🇲🇰','flag-north-macedonia'),(1697,'🇲🇱','flag-mali'),(1698,'🇲🇲','flag-myanmar-burma'),(1699,'🇲🇳','flag-mongolia'),(1700,'🇲🇴','flag-macao-sar-china'),(1701,'🇲🇵','flag-northern-mariana-islands'),(1702,'🇲🇶','flag-martinique'),(1703,'🇲🇷','flag-mauritania'),(1704,'🇲🇸','flag-montserrat'),(1705,'🇲🇹','flag-malta'),(1706,'🇲🇺','flag-mauritius'),(1707,'🇲🇻','flag-maldives'),(1708,'🇲🇼','flag-malawi'),(1709,'🇲🇽','flag-mexico'),(1710,'🇲🇾','flag-malaysia'),(1711,'🇲🇿','flag-mozambique'),(1712,'🇳🇦','flag-namibia'),(1713,'🇳🇨','flag-new-caledonia'),(1714,'🇳🇪','flag-niger'),(1715,'🇳🇫','flag-norfolk-island'),(1716,'🇳🇬','flag-nigeria'),(1717,'🇳🇮','flag-nicaragua'),(1718,'🇳🇱','flag-netherlands'),(1719,'🇳🇴','flag-norway'),(1720,'🇳🇵','flag-nepal'),(1721,'🇳🇷','flag-nauru'),(1722,'🇳🇺','flag-niue'),(1723,'🇳🇿','flag-new-zealand'),(1724,'🇴🇲','flag-oman'),(1725,'🇵🇦','flag-panama'),(1726,'🇵🇪','flag-peru'),(1727,'🇵🇫','flag-french-polynesia'),(1728,'🇵🇬','flag-papua-new-guinea'),(1729,'🇵🇭','flag-philippines'),(1730,'🇵🇰','flag-pakistan'),(1731,'🇵🇱','flag-poland'),(1732,'🇵🇳','flag-pitcairn-islands'),(1733,'🇵🇷','flag-puerto-rico'),(1734,'🇵🇸','flag-palestinian-territories'),(1735,'🇵🇹','flag-portugal'),(1736,'🇵🇼','flag-palau'),(1737,'🇵🇾','flag-paraguay'),(1738,'🇶🇦','flag-qatar'),(1739,'🇷🇴','flag-romania'),(1740,'🇷🇸','flag-serbia'),(1741,'🇷🇺','flag-russia'),(1742,'🇷🇼','flag-rwanda'),(1743,'🇸🇦','flag-saudi-arabia'),(1744,'🇸🇧','flag-solomon-islands'),(1745,'🇸🇨','flag-seychelles'),(1746,'🇸🇩','flag-sudan'),(1747,'🇸🇪','flag-sweden'),(1748,'🇸🇬','flag-singapore'),(1749,'🇸🇮','flag-slovenia'),(1750,'🇸🇯','flag-svalbard-jan-mayen'),(1751,'🇸🇰','flag-slovakia'),(1752,'🇸🇱','flag-sierra-leone'),(1753,'🇸🇲','flag-san-marino'),(1754,'🇸🇳','flag-senegal'),(1755,'🇸🇴','flag-somalia'),(1756,'🇸🇷','flag-suriname'),(1757,'🇸🇸','flag-south-sudan'),(1758,'🇸🇻','flag-el-salvador'),(1759,'🇸🇽','flag-sint-maarten'),(1760,'🇸🇾','flag-syria'),(1761,'🇸🇿','flag-eswatini'),(1762,'🇹🇦','flag-tristan-da-cunha'),(1763,'🇹🇨','flag-turks-caicos-islands'),(1764,'🇹🇩','flag-chad'),(1765,'🇹🇫','flag-french-southern-territories'),(1766,'🇹🇬','flag-togo'),(1767,'🇹🇭','flag-thailand'),(1768,'🇹🇯','flag-tajikistan'),(1769,'🇹🇰','flag-tokelau'),(1770,'🇹🇱','flag-timor-leste'),(1771,'🇹🇲','flag-turkmenistan'),(1772,'🇹🇳','flag-tunisia'),(1773,'🇹🇴','flag-tonga'),(1774,'🇹🇷','flag-turkey'),(1775,'🇹🇹','flag-trinidad-tobago'),(1776,'🇹🇻','flag-tuvalu'),(1777,'🇹🇼','flag-taiwan'),(1778,'🇹🇿','flag-tanzania'),(1779,'🇺🇦','flag-ukraine'),(1780,'🇺🇬','flag-uganda'),(1782,'🇺🇳','flag-united-nations'),(1783,'🇺🇸','flag-united-states'),(1784,'🇺🇾','flag-uruguay'),(1785,'🇺🇿','flag-uzbekistan'),(1786,'🇻🇦','flag-vatican-city'),(1787,'🇻🇪','flag-venezuela'),(1788,'🇻🇬','flag-british-virgin-islands'),(1790,'🇻🇳','flag-vietnam'),(1791,'🇻🇺','flag-vanuatu'),(1792,'🇼🇫','flag-wallis-futuna'),(1793,'🇼🇸','flag-samoa'),(1794,'🇽🇰','flag-kosovo'),(1795,'🇾🇪','flag-yemen'),(1796,'🇾🇹','flag-mayotte'),(1797,'🇿🇦','flag-south-africa'),(1798,'🇿🇲','flag-zambia'),(1799,'🇿🇼','flag-zimbabwe'),(1800,'🏴󠁧󠁢󠁥󠁮󠁧󠁿','flag-england'),(1801,'🏴󠁧󠁢󠁳󠁣󠁴󠁿','flag-scotland'),(1802,'🏴󠁧󠁢󠁷󠁬󠁳󠁿','flag-wales');
/*!40000 ALTER TABLE `emojis` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events`
--

DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `events` (
  `event_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_privacy` enum('secret','closed','public') DEFAULT 'public',
  `event_admin` int(10) unsigned NOT NULL,
  `event_page_id` int(10) unsigned DEFAULT NULL,
  `event_category` int(10) unsigned NOT NULL,
  `event_title` varchar(256) NOT NULL,
  `event_location` varchar(256) DEFAULT NULL,
  `event_country` int(10) unsigned NOT NULL,
  `event_description` mediumtext NOT NULL,
  `event_start_date` datetime NOT NULL,
  `event_end_date` datetime NOT NULL,
  `event_publish_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `event_publish_approval_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `event_cover` varchar(256) DEFAULT NULL,
  `event_cover_id` int(10) unsigned DEFAULT NULL,
  `event_cover_position` varchar(256) DEFAULT NULL,
  `event_album_covers` int(11) DEFAULT NULL,
  `event_album_timeline` int(11) DEFAULT NULL,
  `event_pinned_post` int(11) DEFAULT NULL,
  `event_invited` int(10) unsigned NOT NULL DEFAULT 0,
  `event_interested` int(10) unsigned NOT NULL DEFAULT 0,
  `event_going` int(10) unsigned NOT NULL DEFAULT 0,
  `chatbox_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `chatbox_conversation_id` int(10) unsigned DEFAULT NULL,
  `event_tickets_link` varchar(256) DEFAULT NULL,
  `event_prices` text DEFAULT NULL,
  `event_rate` float NOT NULL DEFAULT 0,
  `event_is_sponsored` enum('0','1') NOT NULL DEFAULT '0',
  `event_sponsor_name` varchar(256) DEFAULT NULL,
  `event_sponsor_url` varchar(256) DEFAULT NULL,
  `event_date` datetime NOT NULL,
  PRIMARY KEY (`event_id`),
  KEY `event_admin` (`event_admin`),
  KEY `event_category` (`event_category`),
  KEY `event_cover_id` (`event_cover_id`),
  KEY `event_album_covers` (`event_album_covers`),
  KEY `event_album_timeline` (`event_album_timeline`),
  KEY `event_date` (`event_date`) USING BTREE,
  KEY `event_title_idx` (`event_title`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events`
--

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events_categories`
--

DROP TABLE IF EXISTS `events_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `events_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events_categories`
--

LOCK TABLES `events_categories` WRITE;
/*!40000 ALTER TABLE `events_categories` DISABLE KEYS */;
INSERT INTO `events_categories` VALUES (1,0,'Art','',1),(2,0,'Causes','',2),(3,0,'Crafts','',3),(4,0,'Dance','',4),(5,0,'Drinks','',5),(6,0,'Film','',6),(7,0,'Fitness','',7),(8,0,'Food','',8),(9,0,'Games','',9),(10,0,'Gardening','',10),(11,0,'Health','',11),(12,0,'Home','',12),(13,0,'Literature','',13),(14,0,'Music','',14),(15,0,'Networking','',15),(16,0,'Other','',16),(17,0,'Party','',17),(18,0,'Religion','',18),(19,0,'Shopping','',19),(20,0,'Sports','',20),(21,0,'Theater','',21),(22,0,'Wellness','',22);
/*!40000 ALTER TABLE `events_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `events_members`
--

DROP TABLE IF EXISTS `events_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `events_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `is_invited` enum('0','1') DEFAULT '0',
  `is_interested` enum('0','1') DEFAULT '0',
  `is_going` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `event_id_user_id` (`event_id`,`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `events_members`
--

LOCK TABLES `events_members` WRITE;
/*!40000 ALTER TABLE `events_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `events_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `followings`
--

DROP TABLE IF EXISTS `followings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `followings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `following_id` int(10) unsigned NOT NULL,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_following_id` (`user_id`,`following_id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `following_id` (`following_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `followings`
--

LOCK TABLES `followings` WRITE;
/*!40000 ALTER TABLE `followings` DISABLE KEYS */;
/*!40000 ALTER TABLE `followings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forums`
--

DROP TABLE IF EXISTS `forums`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forums` (
  `forum_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forum_section` int(10) unsigned NOT NULL,
  `forum_name` varchar(256) NOT NULL,
  `forum_description` mediumtext DEFAULT NULL,
  `forum_order` int(10) unsigned NOT NULL DEFAULT 1,
  `forum_threads` int(10) unsigned NOT NULL DEFAULT 0,
  `forum_replies` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`forum_id`),
  KEY `forum_section` (`forum_section`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forums`
--

LOCK TABLES `forums` WRITE;
/*!40000 ALTER TABLE `forums` DISABLE KEYS */;
/*!40000 ALTER TABLE `forums` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forums_replies`
--

DROP TABLE IF EXISTS `forums_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forums_replies` (
  `reply_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `text` longtext NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`reply_id`),
  KEY `thread_id` (`thread_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forums_replies`
--

LOCK TABLES `forums_replies` WRITE;
/*!40000 ALTER TABLE `forums_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `forums_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forums_threads`
--

DROP TABLE IF EXISTS `forums_threads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `forums_threads` (
  `thread_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forum_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(256) NOT NULL,
  `text` longtext NOT NULL,
  `replies` int(10) unsigned NOT NULL DEFAULT 0,
  `views` int(10) unsigned NOT NULL DEFAULT 0,
  `time` datetime NOT NULL,
  `last_reply` datetime DEFAULT NULL,
  PRIMARY KEY (`thread_id`),
  KEY `forum_id` (`forum_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forums_threads`
--

LOCK TABLES `forums_threads` WRITE;
/*!40000 ALTER TABLE `forums_threads` DISABLE KEYS */;
/*!40000 ALTER TABLE `forums_threads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `friends`
--

DROP TABLE IF EXISTS `friends`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `friends` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_one_id` int(10) unsigned NOT NULL,
  `user_two_id` int(10) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_one_id_user_two_id` (`user_one_id`,`user_two_id`),
  KEY `user_one_id` (`user_one_id`) USING BTREE,
  KEY `user_two_id` (`user_two_id`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `friends`
--

LOCK TABLES `friends` WRITE;
/*!40000 ALTER TABLE `friends` DISABLE KEYS */;
/*!40000 ALTER TABLE `friends` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `funding_payments`
--

DROP TABLE IF EXISTS `funding_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `funding_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `funding_payments`
--

LOCK TABLES `funding_payments` WRITE;
/*!40000 ALTER TABLE `funding_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `funding_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `games`
--

DROP TABLE IF EXISTS `games`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `games` (
  `game_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `description` mediumtext NOT NULL,
  `genres` mediumtext DEFAULT NULL,
  `source` mediumtext NOT NULL,
  `thumbnail` varchar(256) NOT NULL,
  PRIMARY KEY (`game_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `games`
--

LOCK TABLES `games` WRITE;
/*!40000 ALTER TABLE `games` DISABLE KEYS */;
/*!40000 ALTER TABLE `games` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `games_genres`
--

DROP TABLE IF EXISTS `games_genres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `games_genres` (
  `genre_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `genre_name` varchar(256) NOT NULL,
  `genre_description` text NOT NULL,
  `genre_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`genre_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `games_genres`
--

LOCK TABLES `games_genres` WRITE;
/*!40000 ALTER TABLE `games_genres` DISABLE KEYS */;
INSERT INTO `games_genres` VALUES (1,'Action','',1),(2,'Adventure','',2),(3,'Animation','',3),(4,'Comedy','',4),(5,'Crime','',5),(6,'Documentary','',6),(7,'Drama','',7),(8,'Family','',8),(9,'Fantasy','',9),(10,'History','',10),(11,'Horror','',11),(12,'Musical','',12),(13,'Mythological','',13),(14,'Romance','',14),(15,'Sport','',15),(16,'TV Show','',16),(17,'Thriller','',17),(18,'War','',18),(19,'Others','',19);
/*!40000 ALTER TABLE `games_genres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `games_players`
--

DROP TABLE IF EXISTS `games_players`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `games_players` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `game_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `last_played_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `game_id_user_id` (`game_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `games_players`
--

LOCK TABLES `games_players` WRITE;
/*!40000 ALTER TABLE `games_players` DISABLE KEYS */;
/*!40000 ALTER TABLE `games_players` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gifts`
--

DROP TABLE IF EXISTS `gifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gifts` (
  `gift_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(256) NOT NULL,
  PRIMARY KEY (`gift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gifts`
--

LOCK TABLES `gifts` WRITE;
/*!40000 ALTER TABLE `gifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `gifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_privacy` enum('secret','closed','public') DEFAULT 'public',
  `group_admin` int(10) unsigned NOT NULL,
  `group_category` int(10) unsigned NOT NULL,
  `group_name` varchar(64) NOT NULL,
  `group_title` varchar(256) NOT NULL,
  `group_country` int(10) unsigned NOT NULL,
  `group_description` mediumtext NOT NULL,
  `group_publish_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `group_publish_approval_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `group_picture` varchar(256) DEFAULT NULL,
  `group_picture_id` int(10) unsigned DEFAULT NULL,
  `group_cover` varchar(256) DEFAULT NULL,
  `group_cover_id` int(10) unsigned DEFAULT NULL,
  `group_cover_position` varchar(256) DEFAULT NULL,
  `group_album_pictures` int(11) DEFAULT NULL,
  `group_album_covers` int(11) DEFAULT NULL,
  `group_album_timeline` int(11) DEFAULT NULL,
  `group_pinned_post` int(11) DEFAULT NULL,
  `group_members` int(10) unsigned NOT NULL DEFAULT 0,
  `group_monetization_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `group_monetization_min_price` float NOT NULL DEFAULT 0,
  `group_monetization_plans` int(10) unsigned NOT NULL DEFAULT 0,
  `chatbox_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `chatbox_conversation_id` int(10) unsigned DEFAULT NULL,
  `group_rate` float NOT NULL DEFAULT 0,
  `group_date` datetime NOT NULL,
  `is_fake` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `group_name` (`group_name`) USING BTREE,
  KEY `group_admin` (`group_admin`),
  KEY `group_category` (`group_category`),
  KEY `group_picture_id` (`group_picture_id`),
  KEY `group_cover_id` (`group_cover_id`),
  KEY `group_album_pictures` (`group_album_pictures`),
  KEY `group_album_covers` (`group_album_covers`),
  KEY `group_album_timeline` (`group_album_timeline`),
  KEY `group_date` (`group_date`) USING BTREE,
  KEY `group_title_idx` (`group_title`) USING BTREE,
  KEY `group_name_idx` (`group_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups_admins`
--

DROP TABLE IF EXISTS `groups_admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups_admins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id_user_id` (`group_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups_admins`
--

LOCK TABLES `groups_admins` WRITE;
/*!40000 ALTER TABLE `groups_admins` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups_admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups_categories`
--

DROP TABLE IF EXISTS `groups_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups_categories`
--

LOCK TABLES `groups_categories` WRITE;
/*!40000 ALTER TABLE `groups_categories` DISABLE KEYS */;
INSERT INTO `groups_categories` VALUES (1,0,'Cars and Vehicles','',1),(2,0,'Comedy','',2),(3,0,'Economics and Trade','',3),(4,0,'Education','',4),(5,0,'Entertainment','',5),(6,0,'Movies and Animation','',6),(7,0,'Gaming','',7),(8,0,'History and Facts','',8),(9,0,'Live Style','',9),(10,0,'Natural','',10),(11,0,'News and Politics','',11),(12,0,'People and Nations','',12),(13,0,'Pets and Animals','',13),(14,0,'Places and Regions','',14),(15,0,'Science and Technology','',15),(16,0,'Sport','',16),(17,0,'Travel and Events','',17),(18,0,'Other','',18);
/*!40000 ALTER TABLE `groups_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups_invites`
--

DROP TABLE IF EXISTS `groups_invites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups_invites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `from_user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id_from_user_id` (`group_id`,`user_id`,`from_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups_invites`
--

LOCK TABLES `groups_invites` WRITE;
/*!40000 ALTER TABLE `groups_invites` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups_invites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `groups_members`
--

DROP TABLE IF EXISTS `groups_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `approved` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_id_user_id` (`group_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups_members`
--

LOCK TABLES `groups_members` WRITE;
/*!40000 ALTER TABLE `groups_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups_members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hashtags`
--

DROP TABLE IF EXISTS `hashtags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hashtags` (
  `hashtag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hashtag` varchar(256) NOT NULL,
  PRIMARY KEY (`hashtag_id`),
  KEY `hashtag` (`hashtag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hashtags`
--

LOCK TABLES `hashtags` WRITE;
/*!40000 ALTER TABLE `hashtags` DISABLE KEYS */;
/*!40000 ALTER TABLE `hashtags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hashtags_posts`
--

DROP TABLE IF EXISTS `hashtags_posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hashtags_posts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `hashtag_id` int(10) unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_hashtag_id` (`post_id`,`hashtag_id`),
  KEY `post_id` (`post_id`) USING BTREE,
  KEY `hashtag_id` (`hashtag_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hashtags_posts`
--

LOCK TABLES `hashtags_posts` WRITE;
/*!40000 ALTER TABLE `hashtags_posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `hashtags_posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invitation_codes`
--

DROP TABLE IF EXISTS `invitation_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invitation_codes` (
  `code_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_date` datetime NOT NULL,
  `used_by` int(10) unsigned DEFAULT NULL,
  `used_date` datetime DEFAULT NULL,
  `used` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`code_id`),
  KEY `created_by` (`created_by`),
  KEY `used_by` (`used_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invitation_codes`
--

LOCK TABLES `invitation_codes` WRITE;
/*!40000 ALTER TABLE `invitation_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `invitation_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs_categories`
--

DROP TABLE IF EXISTS `jobs_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `jobs_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`) USING BTREE,
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs_categories`
--

LOCK TABLES `jobs_categories` WRITE;
/*!40000 ALTER TABLE `jobs_categories` DISABLE KEYS */;
INSERT INTO `jobs_categories` VALUES (1,0,'Admin &amp; Office','',1),(2,0,'Art &amp; Design','',2),(3,0,'Business Operations','',3),(4,0,'Cleaning &amp; Facilities','',4),(5,0,'Community &amp; Social Services','',5),(6,0,'Computer &amp; Data','',6),(7,0,'Construction &amp; Mining','',7),(8,0,'Education','',8),(9,0,'Farming &amp; Forestry','',9),(10,0,'Healthcare','',10),(11,0,'Installation, Maintenance &amp; Repair','',11),(12,0,'Legal','',12),(13,0,'Management','',13),(14,0,'Manufacturing','',14),(15,0,'Media &amp; Communication','',15),(16,0,'Personal Care','',16),(17,0,'Protective Services','',17),(18,0,'Restaurant &amp; Hospitality','',18),(19,0,'Retail &amp; Sales','',19),(20,0,'Science &amp; Engineering','',20),(21,0,'Sports &amp; Entertainment','',21),(22,0,'Transportation','',22),(23,0,'Other','',23);
/*!40000 ALTER TABLE `jobs_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_commissions`
--

DROP TABLE IF EXISTS `log_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_commissions` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` float NOT NULL,
  `handle` varchar(128) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_commissions`
--

LOCK TABLES `log_commissions` WRITE;
/*!40000 ALTER TABLE `log_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_payments`
--

DROP TABLE IF EXISTS `log_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` float NOT NULL,
  `method` varchar(64) NOT NULL,
  `handle` varchar(128) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_payments`
--

LOCK TABLES `log_payments` WRITE;
/*!40000 ALTER TABLE `log_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_points`
--

DROP TABLE IF EXISTS `log_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_points` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(128) NOT NULL,
  `points` float NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`log_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_points`
--

LOCK TABLES `log_points` WRITE;
/*!40000 ALTER TABLE `log_points` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_points` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_sessions`
--

DROP TABLE IF EXISTS `log_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_sessions` (
  `session_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_date` datetime NOT NULL,
  `session_type` enum('W','A','I') NOT NULL DEFAULT 'W',
  `session_ip` varchar(64) NOT NULL,
  `session_user_agent` varchar(512) DEFAULT NULL,
  `user_browser` varchar(64) DEFAULT NULL,
  `user_os` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`session_id`),
  KEY `session_ip` (`session_ip`) USING BTREE,
  KEY `session_user_agent` (`session_user_agent`) USING BTREE,
  KEY `idx_session_ip_user_agent` (`session_ip`,`session_user_agent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_sessions`
--

LOCK TABLES `log_sessions` WRITE;
/*!40000 ALTER TABLE `log_sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `log_subscriptions`
--

DROP TABLE IF EXISTS `log_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_subscriptions` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_title` varchar(256) NOT NULL,
  `subscriber_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL DEFAULT '',
  `price` float NOT NULL,
  `commission` float NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `log_subscriptions`
--

LOCK TABLES `log_subscriptions` WRITE;
/*!40000 ALTER TABLE `log_subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `log_subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `market_categories`
--

DROP TABLE IF EXISTS `market_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `market_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `market_categories`
--

LOCK TABLES `market_categories` WRITE;
/*!40000 ALTER TABLE `market_categories` DISABLE KEYS */;
INSERT INTO `market_categories` VALUES (1,0,'Apparel &amp; Accessories','',1),(2,0,'Autos &amp; Vehicles','',2),(3,0,'Baby &amp; Children&#039;s Products','',3),(4,0,'Beauty Products &amp; Services','',4),(5,0,'Computers &amp; Peripherals','',5),(6,0,'Consumer Electronics','',6),(7,0,'Dating Services','',7),(8,0,'Financial Services','',8),(9,0,'Gifts &amp; Occasions','',9),(10,0,'Home &amp; Garden','',10),(11,0,'Other','',11);
/*!40000 ALTER TABLE `market_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `market_payments`
--

DROP TABLE IF EXISTS `market_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `market_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `market_payments`
--

LOCK TABLES `market_payments` WRITE;
/*!40000 ALTER TABLE `market_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `market_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `merits_categories`
--

DROP TABLE IF EXISTS `merits_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `merits_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_image` varchar(256) DEFAULT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `merits_categories`
--

LOCK TABLES `merits_categories` WRITE;
/*!40000 ALTER TABLE `merits_categories` DISABLE KEYS */;
INSERT INTO `merits_categories` VALUES (1,0,'Respect','Respect','merits/Respect.png',1),(2,0,'Integrity','Integrit','merits/Integrity.png',2),(3,0,'Collaboration','Collaboration','merits/Collaboration.png',3),(4,0,'Quality','Quality','merits/Quality.png',4);
/*!40000 ALTER TABLE `merits_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `monetization_payments`
--

DROP TABLE IF EXISTS `monetization_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `monetization_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `monetization_payments`
--

LOCK TABLES `monetization_payments` WRITE;
/*!40000 ALTER TABLE `monetization_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `monetization_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `monetization_plans`
--

DROP TABLE IF EXISTS `monetization_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `monetization_plans` (
  `plan_id` int(11) NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `title` varchar(256) NOT NULL,
  `price` float NOT NULL,
  `period_num` int(10) unsigned NOT NULL,
  `period` varchar(32) NOT NULL,
  `custom_description` text DEFAULT NULL,
  `plan_order` int(10) unsigned NOT NULL DEFAULT 1,
  `paypal_billing_plan` varchar(256) DEFAULT NULL,
  `stripe_billing_plan` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`plan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `monetization_plans`
--

LOCK TABLES `monetization_plans` WRITE;
/*!40000 ALTER TABLE `monetization_plans` DISABLE KEYS */;
/*!40000 ALTER TABLE `monetization_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movies`
--

DROP TABLE IF EXISTS `movies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `movies` (
  `movie_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source` text NOT NULL,
  `source_type` varchar(64) NOT NULL,
  `title` varchar(256) NOT NULL,
  `description` text DEFAULT NULL,
  `imdb_url` text DEFAULT NULL,
  `stars` text DEFAULT NULL,
  `release_year` int(11) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `genres` mediumtext DEFAULT NULL,
  `poster` varchar(256) DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT 0,
  `is_paid` enum('0','1') NOT NULL DEFAULT '0',
  `price` float NOT NULL DEFAULT 0,
  `available_for` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`movie_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movies`
--

LOCK TABLES `movies` WRITE;
/*!40000 ALTER TABLE `movies` DISABLE KEYS */;
/*!40000 ALTER TABLE `movies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movies_genres`
--

DROP TABLE IF EXISTS `movies_genres`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `movies_genres` (
  `genre_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `genre_name` varchar(256) NOT NULL,
  `genre_description` text NOT NULL,
  `genre_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`genre_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movies_genres`
--

LOCK TABLES `movies_genres` WRITE;
/*!40000 ALTER TABLE `movies_genres` DISABLE KEYS */;
INSERT INTO `movies_genres` VALUES (1,'Action','',1),(2,'Adventure','',2),(3,'Animation','',3),(4,'Comedy','',4),(5,'Crime','',5),(6,'Documentary','',6),(7,'Drama','',7),(8,'Family','',8),(9,'Fantasy','',9),(10,'History','',10),(11,'Horror','',11),(12,'Musical','',12),(13,'Mythological','',13),(14,'Romance','',14),(15,'Sport','',15),(16,'TV Show','',16),(17,'Thriller','',17),(18,'War','',18);
/*!40000 ALTER TABLE `movies_genres` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `movies_payments`
--

DROP TABLE IF EXISTS `movies_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `movies_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `movie_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `payment_time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `move_id_user_id` (`movie_id`,`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `movies_payments`
--

LOCK TABLES `movies_payments` WRITE;
/*!40000 ALTER TABLE `movies_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `movies_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `to_user_id` int(10) unsigned NOT NULL,
  `from_user_id` int(10) unsigned NOT NULL,
  `from_user_type` enum('user','page') NOT NULL DEFAULT 'user',
  `action` varchar(256) NOT NULL,
  `node_type` varchar(256) NOT NULL,
  `node_url` varchar(256) NOT NULL,
  `notify_id` varchar(256) DEFAULT NULL,
  `message` mediumtext DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `seen` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`notification_id`),
  KEY `to_user_id` (`to_user_id`),
  KEY `from_user_id` (`from_user_id`,`from_user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `offers_categories`
--

DROP TABLE IF EXISTS `offers_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `offers_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`) USING BTREE,
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `offers_categories`
--

LOCK TABLES `offers_categories` WRITE;
/*!40000 ALTER TABLE `offers_categories` DISABLE KEYS */;
INSERT INTO `offers_categories` VALUES (1,0,'Apparel &amp; Accessories','',1),(2,0,'Autos &amp; Vehicles','',2),(3,0,'Baby &amp; Children&#039;s Products','',3),(4,0,'Beauty Products &amp; Services','',4),(5,0,'Computers &amp; Peripherals','',5),(6,0,'Consumer Electronics','',6),(7,0,'Dating Services','',7),(8,0,'Financial Services','',8),(9,0,'Gifts &amp; Occasions','',9),(10,0,'Home &amp; Garden','',10),(11,0,'Other','',11);
/*!40000 ALTER TABLE `offers_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_hash` varchar(128) NOT NULL,
  `order_collection_id` varchar(128) DEFAULT NULL,
  `is_payment_done` enum('0','1') NOT NULL DEFAULT '0',
  `is_cash_on_delivery` enum('0','1') NOT NULL DEFAULT '0',
  `is_digital` enum('0','1') NOT NULL DEFAULT '0',
  `seller_id` int(10) unsigned NOT NULL,
  `seller_page_id` int(10) unsigned NOT NULL DEFAULT 0,
  `buyer_id` int(10) unsigned NOT NULL,
  `buyer_address_id` int(10) unsigned NOT NULL,
  `sub_total` float unsigned NOT NULL DEFAULT 0,
  `commission` float unsigned NOT NULL,
  `status` enum('placed','canceled','accepted','packed','shipped','delivered') NOT NULL DEFAULT 'placed',
  `tracking_link` mediumtext DEFAULT NULL,
  `tracking_number` mediumtext DEFAULT NULL,
  `insert_time` datetime NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `seller_id` (`seller_id`) USING BTREE,
  KEY `buyer_id` (`buyer_id`) USING BTREE,
  KEY `buyer_address_id` (`buyer_address_id`) USING BTREE,
  KEY `order_collection_id` (`order_collection_id`) USING BTREE,
  KEY `order_hash` (`order_hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders_items`
--

DROP TABLE IF EXISTS `orders_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `product_post_id` int(10) unsigned NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `price` float unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_post_id` (`product_post_id`) USING BTREE,
  KEY `order_id` (`order_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders_items`
--

LOCK TABLES `orders_items` WRITE;
/*!40000 ALTER TABLE `orders_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `packages`
--

DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `package_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `price` varchar(32) NOT NULL,
  `period_num` int(10) unsigned NOT NULL,
  `period` varchar(32) NOT NULL,
  `color` varchar(32) NOT NULL,
  `icon` varchar(256) NOT NULL,
  `package_permissions_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `allowed_blogs_categories` int(11) NOT NULL DEFAULT 0,
  `allowed_videos_categories` int(11) NOT NULL DEFAULT 0,
  `allowed_products` int(11) NOT NULL DEFAULT 0,
  `verification_badge_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_posts_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_posts` int(10) unsigned NOT NULL,
  `boost_pages_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `boost_pages` int(10) unsigned NOT NULL,
  `custom_description` text DEFAULT NULL,
  `package_order` int(10) unsigned NOT NULL DEFAULT 1,
  `paypal_billing_plan` varchar(256) DEFAULT NULL,
  `stripe_billing_plan` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`package_id`),
  KEY `package_permissions_group_id` (`package_permissions_group_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `packages`
--

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `packages_payments`
--

DROP TABLE IF EXISTS `packages_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_date` datetime NOT NULL,
  `package_name` varchar(256) NOT NULL,
  `package_price` float unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `packages_payments`
--

LOCK TABLES `packages_payments` WRITE;
/*!40000 ALTER TABLE `packages_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `packages_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_admin` int(10) unsigned NOT NULL,
  `page_category` int(10) unsigned NOT NULL,
  `page_name` varchar(64) NOT NULL,
  `page_title` varchar(256) NOT NULL,
  `page_picture` varchar(256) DEFAULT NULL,
  `page_picture_id` int(10) unsigned DEFAULT NULL,
  `page_cover` varchar(256) DEFAULT NULL,
  `page_cover_id` int(10) unsigned DEFAULT NULL,
  `page_cover_position` varchar(256) DEFAULT NULL,
  `page_album_pictures` int(10) unsigned DEFAULT NULL,
  `page_album_covers` int(10) unsigned DEFAULT NULL,
  `page_album_timeline` int(10) unsigned DEFAULT NULL,
  `page_pinned_post` int(10) unsigned DEFAULT NULL,
  `page_verified` enum('0','1') NOT NULL DEFAULT '0',
  `page_tips_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `page_boosted` enum('0','1') NOT NULL DEFAULT '0',
  `page_boosted_by` int(10) unsigned DEFAULT NULL,
  `page_company` varchar(256) DEFAULT NULL,
  `page_phone` varchar(256) DEFAULT NULL,
  `page_website` varchar(256) DEFAULT NULL,
  `page_location` varchar(256) DEFAULT NULL,
  `page_country` int(10) unsigned NOT NULL,
  `page_description` mediumtext NOT NULL,
  `page_action_text` varchar(32) DEFAULT NULL,
  `page_action_color` varchar(32) DEFAULT NULL,
  `page_action_url` varchar(256) DEFAULT NULL,
  `page_social_facebook` varchar(256) DEFAULT NULL,
  `page_social_twitter` varchar(256) DEFAULT NULL,
  `page_social_youtube` varchar(256) DEFAULT NULL,
  `page_social_instagram` varchar(256) DEFAULT NULL,
  `page_social_linkedin` varchar(256) DEFAULT NULL,
  `page_social_vkontakte` varchar(256) DEFAULT NULL,
  `page_likes` int(10) unsigned NOT NULL DEFAULT 0,
  `page_monetization_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `page_monetization_min_price` float NOT NULL DEFAULT 0,
  `page_monetization_plans` int(10) unsigned NOT NULL DEFAULT 0,
  `page_rate` float NOT NULL DEFAULT 0,
  `page_pbid` varchar(128) DEFAULT NULL,
  `page_date` datetime NOT NULL,
  `is_fake` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_name` (`page_name`) USING BTREE,
  KEY `page_admin` (`page_admin`),
  KEY `page_category` (`page_category`),
  KEY `page_cover_id` (`page_cover_id`),
  KEY `page_picture_id` (`page_picture_id`),
  KEY `page_country` (`page_country`),
  KEY `page_album_pictures` (`page_album_pictures`),
  KEY `page_album_covers` (`page_album_covers`),
  KEY `page_album_timeline` (`page_album_timeline`),
  KEY `page_boosted` (`page_boosted`) USING BTREE,
  KEY `page_date` (`page_date`) USING BTREE,
  KEY `page_name_idx` (`page_name`) USING BTREE,
  KEY `page_title_idx` (`page_title`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_admins`
--

DROP TABLE IF EXISTS `pages_admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages_admins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id` (`page_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_admins`
--

LOCK TABLES `pages_admins` WRITE;
/*!40000 ALTER TABLE `pages_admins` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_categories`
--

DROP TABLE IF EXISTS `pages_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_categories`
--

LOCK TABLES `pages_categories` WRITE;
/*!40000 ALTER TABLE `pages_categories` DISABLE KEYS */;
INSERT INTO `pages_categories` VALUES (1,0,'Cars and Vehicles','',1),(2,0,'Comedy','',2),(3,0,'Economics and Trade','',3),(4,0,'Education','',4),(5,0,'Entertainment','',5),(6,0,'Movies and Animation','',6),(7,0,'Gaming','',7),(8,0,'History and Facts','',8),(9,0,'Live Style','',9),(10,0,'Natural','',10),(11,0,'News and Politics','',11),(12,0,'People and Nations','',12),(13,0,'Pets and Animals','',13),(14,0,'Places and Regions','',14),(15,0,'Science and Technology','',15),(16,0,'Sport','',16),(17,0,'Travel and Events','',17),(18,0,'Other','',18);
/*!40000 ALTER TABLE `pages_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_invites`
--

DROP TABLE IF EXISTS `pages_invites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages_invites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `from_user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id_from_user_id` (`page_id`,`user_id`,`from_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_invites`
--

LOCK TABLES `pages_invites` WRITE;
/*!40000 ALTER TABLE `pages_invites` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_invites` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_likes`
--

DROP TABLE IF EXISTS `pages_likes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pages_likes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_id_user_id` (`page_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_likes`
--

LOCK TABLES `pages_likes` WRITE;
/*!40000 ALTER TABLE `pages_likes` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_likes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions_groups`
--

DROP TABLE IF EXISTS `permissions_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions_groups` (
  `permissions_group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `permissions_group_title` varchar(255) NOT NULL,
  `pages_permission` enum('0','1') NOT NULL DEFAULT '0',
  `groups_permission` enum('0','1') NOT NULL DEFAULT '0',
  `events_permission` enum('0','1') NOT NULL DEFAULT '0',
  `reels_permission` enum('0','1') NOT NULL DEFAULT '0',
  `watch_permission` enum('0','1') NOT NULL DEFAULT '0',
  `blogs_permission` enum('0','1') NOT NULL DEFAULT '0',
  `blogs_permission_read` enum('0','1') NOT NULL DEFAULT '0',
  `market_permission` enum('0','1') NOT NULL DEFAULT '0',
  `offers_permission` enum('0','1') NOT NULL DEFAULT '0',
  `offers_permission_read` enum('0','1') NOT NULL DEFAULT '0',
  `jobs_permission` enum('0','1') NOT NULL DEFAULT '0',
  `courses_permission` enum('0','1') NOT NULL DEFAULT '0',
  `forums_permission` enum('0','1') NOT NULL DEFAULT '0',
  `movies_permission` enum('0','1') NOT NULL DEFAULT '0',
  `games_permission` enum('0','1') NOT NULL DEFAULT '0',
  `gifts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `stories_permission` enum('0','1') NOT NULL DEFAULT '0',
  `posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `schedule_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `colored_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `activity_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `polls_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `geolocation_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `gif_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `anonymous_posts_permission` enum('0','1') NOT NULL DEFAULT '0',
  `invitation_permission` enum('0','1') NOT NULL DEFAULT '0',
  `audio_call_permission` enum('0','1') NOT NULL DEFAULT '0',
  `video_call_permission` enum('0','1') NOT NULL DEFAULT '0',
  `live_permission` enum('0','1') NOT NULL DEFAULT '0',
  `videos_upload_permission` enum('0','1') NOT NULL DEFAULT '0',
  `audios_upload_permission` enum('0','1') NOT NULL DEFAULT '0',
  `files_upload_permission` enum('0','1') NOT NULL DEFAULT '0',
  `ads_permission` enum('0','1') NOT NULL DEFAULT '0',
  `funding_permission` enum('0','1') NOT NULL DEFAULT '0',
  `monetization_permission` enum('0','1') NOT NULL DEFAULT '0',
  `tips_permission` enum('0','1') NOT NULL DEFAULT '0',
  `custom_affiliates_system` enum('0','1') NOT NULL DEFAULT '0',
  `affiliates_per_user` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_2` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_2` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_3` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_3` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_4` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_4` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_5` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_5` float unsigned NOT NULL DEFAULT 0,
  `custom_points_system` enum('0','1') NOT NULL DEFAULT '0',
  `points_per_currency` int(10) unsigned NOT NULL DEFAULT 100,
  PRIMARY KEY (`permissions_group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions_groups`
--

LOCK TABLES `permissions_groups` WRITE;
/*!40000 ALTER TABLE `permissions_groups` DISABLE KEYS */;
INSERT INTO `permissions_groups` VALUES (1,'Users Permissions','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',0,0,0,0,0,0,0,0,0,0,'0',100),(2,'Verified Permissions','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','1','0',0,0,0,0,0,0,0,0,0,0,'0',100);
/*!40000 ALTER TABLE `permissions_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `points_payments`
--

DROP TABLE IF EXISTS `points_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `points_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `points_payments`
--

LOCK TABLES `points_payments` WRITE;
/*!40000 ALTER TABLE `points_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `points_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts` (
  `post_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `in_group` enum('0','1') NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned DEFAULT NULL,
  `group_approved` enum('0','1') NOT NULL DEFAULT '1',
  `in_event` enum('0','1') NOT NULL DEFAULT '0',
  `event_id` int(10) unsigned DEFAULT NULL,
  `event_approved` enum('0','1') NOT NULL DEFAULT '1',
  `in_wall` enum('0','1') NOT NULL DEFAULT '0',
  `wall_id` int(10) unsigned DEFAULT NULL,
  `post_type` varchar(32) NOT NULL,
  `colored_pattern` int(10) unsigned DEFAULT NULL,
  `origin_id` int(10) unsigned DEFAULT NULL,
  `time` datetime NOT NULL,
  `location` varchar(256) DEFAULT NULL,
  `privacy` varchar(32) NOT NULL,
  `text` longtext DEFAULT NULL,
  `feeling_action` varchar(32) DEFAULT NULL,
  `feeling_value` varchar(256) DEFAULT NULL,
  `boosted` enum('0','1') NOT NULL DEFAULT '0',
  `boosted_by` int(10) unsigned DEFAULT NULL,
  `comments_disabled` enum('0','1') NOT NULL DEFAULT '0',
  `is_hidden` enum('0','1') NOT NULL DEFAULT '0',
  `is_schedule` enum('0','1') NOT NULL DEFAULT '0',
  `for_adult` enum('0','1') NOT NULL DEFAULT '0',
  `is_anonymous` enum('0','1') NOT NULL DEFAULT '0',
  `reaction_like_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_love_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_haha_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_yay_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_wow_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_sad_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_angry_count` int(10) unsigned NOT NULL DEFAULT 0,
  `comments` int(10) unsigned NOT NULL DEFAULT 0,
  `shares` int(10) unsigned NOT NULL DEFAULT 0,
  `views` int(10) unsigned NOT NULL DEFAULT 0,
  `post_rate` float NOT NULL DEFAULT 0,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  `tips_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `for_subscriptions` enum('0','1') NOT NULL DEFAULT '0',
  `subscriptions_image` varchar(256) DEFAULT NULL,
  `is_paid` enum('0','1') NOT NULL DEFAULT '0',
  `is_paid_locked` enum('0','1') NOT NULL DEFAULT '0',
  `post_price` float unsigned NOT NULL DEFAULT 0,
  `paid_text` text DEFAULT NULL,
  `paid_image` varchar(256) DEFAULT NULL,
  `processing` enum('0','1') NOT NULL DEFAULT '0',
  `pre_approved` enum('0','1') NOT NULL DEFAULT '1',
  `has_approved` enum('0','1') NOT NULL DEFAULT '0',
  `post_latitude` varchar(256) NOT NULL DEFAULT '0',
  `post_longitude` varchar(256) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `group_id` (`group_id`),
  KEY `event_id` (`event_id`),
  KEY `wall_id` (`wall_id`),
  KEY `colored_pattern` (`colored_pattern`),
  KEY `origin_id` (`origin_id`),
  KEY `boosted_by` (`boosted_by`),
  KEY `user_id` (`user_id`,`user_type`),
  KEY `boosted` (`boosted`) USING BTREE,
  KEY `time` (`time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_articles`
--

DROP TABLE IF EXISTS `posts_articles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_articles` (
  `article_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `cover` varchar(256) NOT NULL,
  `title` varchar(256) NOT NULL,
  `text` text NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `tags` text NOT NULL,
  PRIMARY KEY (`article_id`),
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`),
  KEY `title_idx` (`title`) USING BTREE,
  FULLTEXT KEY `ft_title` (`title`),
  FULLTEXT KEY `ft_tags` (`tags`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_articles`
--

LOCK TABLES `posts_articles` WRITE;
/*!40000 ALTER TABLE `posts_articles` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_articles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_audios`
--

DROP TABLE IF EXISTS `posts_audios`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_audios` (
  `audio_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`audio_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_audios`
--

LOCK TABLES `posts_audios` WRITE;
/*!40000 ALTER TABLE `posts_audios` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_audios` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_cache`
--

DROP TABLE IF EXISTS `posts_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_cache` (
  `cache_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cache_date` datetime NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`cache_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_cache`
--

LOCK TABLES `posts_cache` WRITE;
/*!40000 ALTER TABLE `posts_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_colored_patterns`
--

DROP TABLE IF EXISTS `posts_colored_patterns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_colored_patterns` (
  `pattern_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('color','image') NOT NULL DEFAULT 'color',
  `background_image` varchar(256) DEFAULT NULL,
  `background_color_1` varchar(32) DEFAULT NULL,
  `background_color_2` varchar(32) DEFAULT NULL,
  `text_color` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`pattern_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_colored_patterns`
--

LOCK TABLES `posts_colored_patterns` WRITE;
/*!40000 ALTER TABLE `posts_colored_patterns` DISABLE KEYS */;
INSERT INTO `posts_colored_patterns` VALUES (1,'image','patterns/1.jpg',NULL,NULL,'#FFFFFF'),(2,'image','patterns/2.jpg',NULL,NULL,'#FFFFFF'),(3,'image','patterns/3.jpg',NULL,NULL,'#FFFFFF'),(4,'image','patterns/4.jpg','','','#000000'),(5,'image','patterns/5.jpg',NULL,NULL,'#FFFFFF'),(6,'color',NULL,'#FF00FF','#030355','#FFF300'),(7,'color','','#FF003D','#D73A3A','#FFFFFF');
/*!40000 ALTER TABLE `posts_colored_patterns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_comments`
--

DROP TABLE IF EXISTS `posts_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_comments` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` enum('post','photo','comment') NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `text` longtext NOT NULL,
  `image` varchar(256) DEFAULT NULL,
  `voice_note` varchar(256) DEFAULT NULL,
  `time` datetime NOT NULL,
  `reaction_like_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_love_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_haha_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_yay_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_wow_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_sad_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_angry_count` int(10) unsigned NOT NULL DEFAULT 0,
  `replies` int(10) unsigned NOT NULL DEFAULT 0,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `node_id` (`node_id`,`node_type`),
  KEY `user_id` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_comments`
--

LOCK TABLES `posts_comments` WRITE;
/*!40000 ALTER TABLE `posts_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_comments_reactions`
--

DROP TABLE IF EXISTS `posts_comments_reactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_comments_reactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `reaction` varchar(32) DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `comment_id_user_id` (`comment_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_comments_reactions`
--

LOCK TABLES `posts_comments_reactions` WRITE;
/*!40000 ALTER TABLE `posts_comments_reactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_comments_reactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_courses`
--

DROP TABLE IF EXISTS `posts_courses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_courses` (
  `course_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `fees` float unsigned NOT NULL,
  `fees_currency` int(10) unsigned NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `cover_image` varchar(256) NOT NULL,
  `available` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`course_id`) USING BTREE,
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_courses`
--

LOCK TABLES `posts_courses` WRITE;
/*!40000 ALTER TABLE `posts_courses` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_courses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_courses_applications`
--

DROP TABLE IF EXISTS `posts_courses_applications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_courses_applications` (
  `application_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `applied_time` datetime NOT NULL,
  PRIMARY KEY (`application_id`) USING BTREE,
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_courses_applications`
--

LOCK TABLES `posts_courses_applications` WRITE;
/*!40000 ALTER TABLE `posts_courses_applications` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_courses_applications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_files`
--

DROP TABLE IF EXISTS `posts_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_files` (
  `file_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_files`
--

LOCK TABLES `posts_files` WRITE;
/*!40000 ALTER TABLE `posts_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_funding`
--

DROP TABLE IF EXISTS `posts_funding`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_funding` (
  `funding_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `title` varchar(256) NOT NULL,
  `amount` float NOT NULL DEFAULT 0,
  `raised_amount` float NOT NULL DEFAULT 0,
  `total_donations` int(11) NOT NULL DEFAULT 0,
  `cover_image` varchar(256) NOT NULL,
  PRIMARY KEY (`funding_id`) USING BTREE,
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_funding`
--

LOCK TABLES `posts_funding` WRITE;
/*!40000 ALTER TABLE `posts_funding` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_funding` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_funding_donors`
--

DROP TABLE IF EXISTS `posts_funding_donors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_funding_donors` (
  `donation_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `donation_amount` float unsigned NOT NULL DEFAULT 0,
  `donation_time` datetime NOT NULL,
  PRIMARY KEY (`donation_id`) USING BTREE,
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_funding_donors`
--

LOCK TABLES `posts_funding_donors` WRITE;
/*!40000 ALTER TABLE `posts_funding_donors` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_funding_donors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_hidden`
--

DROP TABLE IF EXISTS `posts_hidden`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_hidden` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_hidden`
--

LOCK TABLES `posts_hidden` WRITE;
/*!40000 ALTER TABLE `posts_hidden` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_hidden` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_jobs`
--

DROP TABLE IF EXISTS `posts_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_jobs` (
  `job_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `salary_minimum` float unsigned NOT NULL,
  `salary_minimum_currency` int(10) unsigned NOT NULL,
  `salary_maximum` float unsigned NOT NULL,
  `salary_maximum_currency` int(10) unsigned NOT NULL,
  `pay_salary_per` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `question_1_type` varchar(100) DEFAULT NULL,
  `question_1_title` varchar(256) DEFAULT NULL,
  `question_1_choices` text DEFAULT NULL,
  `question_2_type` varchar(100) DEFAULT NULL,
  `question_2_title` varchar(256) DEFAULT NULL,
  `question_2_choices` text DEFAULT NULL,
  `question_3_type` varchar(100) DEFAULT NULL,
  `question_3_title` varchar(256) DEFAULT NULL,
  `question_3_choices` text DEFAULT NULL,
  `cover_image` varchar(256) NOT NULL,
  `available` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`job_id`) USING BTREE,
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_jobs`
--

LOCK TABLES `posts_jobs` WRITE;
/*!40000 ALTER TABLE `posts_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_jobs_applications`
--

DROP TABLE IF EXISTS `posts_jobs_applications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_jobs_applications` (
  `application_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `location` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `work_place` varchar(100) DEFAULT NULL,
  `work_position` varchar(100) DEFAULT NULL,
  `work_description` text DEFAULT NULL,
  `work_from` varchar(100) DEFAULT NULL,
  `work_to` varchar(100) DEFAULT NULL,
  `work_now` enum('0','1') DEFAULT NULL,
  `question_1_answer` text DEFAULT NULL,
  `question_2_answer` text DEFAULT NULL,
  `question_3_answer` text DEFAULT NULL,
  `cv` varchar(256) DEFAULT NULL,
  `applied_time` datetime NOT NULL,
  PRIMARY KEY (`application_id`) USING BTREE,
  KEY `post_id` (`post_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_jobs_applications`
--

LOCK TABLES `posts_jobs_applications` WRITE;
/*!40000 ALTER TABLE `posts_jobs_applications` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_jobs_applications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_links`
--

DROP TABLE IF EXISTS `posts_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `source_url` text NOT NULL,
  `source_host` varchar(256) NOT NULL,
  `source_title` text NOT NULL,
  `source_text` mediumtext NOT NULL,
  `source_thumbnail` text NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_links`
--

LOCK TABLES `posts_links` WRITE;
/*!40000 ALTER TABLE `posts_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_live`
--

DROP TABLE IF EXISTS `posts_live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_live` (
  `live_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `video_thumbnail` varchar(256) NOT NULL,
  `agora_uid` int(11) NOT NULL,
  `agora_channel_name` varchar(256) NOT NULL,
  `agora_resource_id` text DEFAULT NULL,
  `agora_sid` varchar(256) DEFAULT NULL,
  `agora_file` text DEFAULT NULL,
  `live_ended` enum('0','1') NOT NULL DEFAULT '0',
  `live_recorded` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`live_id`) USING BTREE,
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_live`
--

LOCK TABLES `posts_live` WRITE;
/*!40000 ALTER TABLE `posts_live` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_live_users`
--

DROP TABLE IF EXISTS `posts_live_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_live_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `user_id_post_id` (`user_id`,`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_live_users`
--

LOCK TABLES `posts_live_users` WRITE;
/*!40000 ALTER TABLE `posts_live_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_live_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_media`
--

DROP TABLE IF EXISTS `posts_media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_media` (
  `media_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `source_url` mediumtext NOT NULL,
  `source_provider` varchar(256) NOT NULL,
  `source_type` varchar(256) NOT NULL,
  `source_title` text DEFAULT NULL,
  `source_text` mediumtext DEFAULT NULL,
  `source_html` mediumtext DEFAULT NULL,
  `source_thumbnail` text DEFAULT NULL,
  PRIMARY KEY (`media_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_media`
--

LOCK TABLES `posts_media` WRITE;
/*!40000 ALTER TABLE `posts_media` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_media` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_merits`
--

DROP TABLE IF EXISTS `posts_merits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_merits` (
  `merit_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `message` text NOT NULL,
  `image` varchar(256) NOT NULL,
  PRIMARY KEY (`merit_id`),
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_merits`
--

LOCK TABLES `posts_merits` WRITE;
/*!40000 ALTER TABLE `posts_merits` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_merits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_offers`
--

DROP TABLE IF EXISTS `posts_offers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_offers` (
  `offer_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `discount_type` varchar(32) NOT NULL,
  `discount_percent` int(10) unsigned NOT NULL,
  `discount_amount` varchar(100) NOT NULL,
  `buy_x` varchar(100) NOT NULL,
  `get_y` varchar(100) NOT NULL,
  `spend_x` varchar(100) NOT NULL,
  `amount_y` varchar(100) NOT NULL,
  `end_date` datetime DEFAULT NULL,
  `price` float unsigned NOT NULL DEFAULT 0,
  `thumbnail` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`offer_id`) USING BTREE,
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_offers`
--

LOCK TABLES `posts_offers` WRITE;
/*!40000 ALTER TABLE `posts_offers` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_offers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_paid`
--

DROP TABLE IF EXISTS `posts_paid`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_paid` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_paid`
--

LOCK TABLES `posts_paid` WRITE;
/*!40000 ALTER TABLE `posts_paid` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_paid` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_photos`
--

DROP TABLE IF EXISTS `posts_photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_photos` (
  `photo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `album_id` int(10) unsigned DEFAULT NULL,
  `source` varchar(256) NOT NULL,
  `blur` enum('0','1') NOT NULL DEFAULT '0',
  `pinned` enum('0','1') NOT NULL DEFAULT '0',
  `reaction_like_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_love_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_haha_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_yay_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_wow_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_sad_count` int(10) unsigned NOT NULL DEFAULT 0,
  `reaction_angry_count` int(10) unsigned NOT NULL DEFAULT 0,
  `comments` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`photo_id`),
  KEY `post_id` (`post_id`),
  KEY `album_id` (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_photos`
--

LOCK TABLES `posts_photos` WRITE;
/*!40000 ALTER TABLE `posts_photos` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_photos_albums`
--

DROP TABLE IF EXISTS `posts_photos_albums`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_photos_albums` (
  `album_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_type` enum('user','page') NOT NULL,
  `in_group` enum('0','1') NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned DEFAULT NULL,
  `in_event` enum('0','1') NOT NULL DEFAULT '0',
  `event_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(256) NOT NULL,
  `privacy` enum('me','friends','public','custom') NOT NULL DEFAULT 'public',
  PRIMARY KEY (`album_id`),
  KEY `user_id` (`user_id`,`user_type`),
  KEY `group_id` (`group_id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_photos_albums`
--

LOCK TABLES `posts_photos_albums` WRITE;
/*!40000 ALTER TABLE `posts_photos_albums` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_photos_albums` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_photos_reactions`
--

DROP TABLE IF EXISTS `posts_photos_reactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_photos_reactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `photo_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `reaction` varchar(32) NOT NULL DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_photo_id` (`user_id`,`photo_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_photos_reactions`
--

LOCK TABLES `posts_photos_reactions` WRITE;
/*!40000 ALTER TABLE `posts_photos_reactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_photos_reactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_polls`
--

DROP TABLE IF EXISTS `posts_polls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_polls` (
  `poll_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `votes` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`poll_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_polls`
--

LOCK TABLES `posts_polls` WRITE;
/*!40000 ALTER TABLE `posts_polls` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_polls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_polls_options`
--

DROP TABLE IF EXISTS `posts_polls_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_polls_options` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(10) unsigned NOT NULL,
  `text` varchar(256) NOT NULL,
  PRIMARY KEY (`option_id`),
  KEY `poll_id` (`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_polls_options`
--

LOCK TABLES `posts_polls_options` WRITE;
/*!40000 ALTER TABLE `posts_polls_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_polls_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_polls_options_users`
--

DROP TABLE IF EXISTS `posts_polls_options_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_polls_options_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `poll_id` int(10) unsigned NOT NULL,
  `option_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_poll_id` (`user_id`,`poll_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_polls_options_users`
--

LOCK TABLES `posts_polls_options_users` WRITE;
/*!40000 ALTER TABLE `posts_polls_options_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_polls_options_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_products`
--

DROP TABLE IF EXISTS `posts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_products` (
  `product_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `name` varchar(256) NOT NULL,
  `price` float unsigned NOT NULL DEFAULT 0,
  `quantity` int(10) unsigned NOT NULL DEFAULT 1,
  `category_id` int(10) unsigned NOT NULL,
  `status` enum('new','old') NOT NULL DEFAULT 'new',
  `location` varchar(255) NOT NULL,
  `available` enum('0','1') NOT NULL DEFAULT '1',
  `is_digital` enum('0','1') NOT NULL DEFAULT '0',
  `product_download_url` text DEFAULT NULL,
  `product_file_source` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`product_id`),
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_products`
--

LOCK TABLES `posts_products` WRITE;
/*!40000 ALTER TABLE `posts_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_reactions`
--

DROP TABLE IF EXISTS `posts_reactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_reactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `reaction` varchar(32) NOT NULL DEFAULT 'like',
  `reaction_time` datetime DEFAULT NULL,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_reactions`
--

LOCK TABLES `posts_reactions` WRITE;
/*!40000 ALTER TABLE `posts_reactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_reactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_reels`
--

DROP TABLE IF EXISTS `posts_reels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_reels` (
  `reel_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  `source_240p` varchar(256) DEFAULT NULL,
  `source_360p` varchar(256) DEFAULT NULL,
  `source_480p` varchar(256) DEFAULT NULL,
  `source_720p` varchar(256) DEFAULT NULL,
  `source_1080p` varchar(256) DEFAULT NULL,
  `source_1440p` varchar(256) DEFAULT NULL,
  `source_2160p` varchar(256) DEFAULT NULL,
  `thumbnail` varchar(256) DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`reel_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_reels`
--

LOCK TABLES `posts_reels` WRITE;
/*!40000 ALTER TABLE `posts_reels` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_reels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_saved`
--

DROP TABLE IF EXISTS `posts_saved`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_saved` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id_user_id` (`post_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_saved`
--

LOCK TABLES `posts_saved` WRITE;
/*!40000 ALTER TABLE `posts_saved` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_saved` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_videos`
--

DROP TABLE IF EXISTS `posts_videos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_videos` (
  `video_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  `source_240p` varchar(256) DEFAULT NULL,
  `source_360p` varchar(256) DEFAULT NULL,
  `source_480p` varchar(256) DEFAULT NULL,
  `source_720p` varchar(256) DEFAULT NULL,
  `source_1080p` varchar(256) DEFAULT NULL,
  `source_1440p` varchar(256) DEFAULT NULL,
  `source_2160p` varchar(256) DEFAULT NULL,
  `thumbnail` varchar(256) DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`video_id`),
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_videos`
--

LOCK TABLES `posts_videos` WRITE;
/*!40000 ALTER TABLE `posts_videos` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_videos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_videos_categories`
--

DROP TABLE IF EXISTS `posts_videos_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_videos_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_videos_categories`
--

LOCK TABLES `posts_videos_categories` WRITE;
/*!40000 ALTER TABLE `posts_videos_categories` DISABLE KEYS */;
INSERT INTO `posts_videos_categories` VALUES (1,0,'General','',1),(2,0,'Comedy','',2),(3,0,'Economics and Trade','',3),(4,0,'Education','',4),(5,0,'Entertainment','',5),(6,0,'Movies and Animation','',6),(7,0,'Gaming','',7),(8,0,'History and Facts','',8),(9,0,'Live Style','',9),(10,0,'Natural','',10),(11,0,'News and Politics','',11),(12,0,'People and Nations','',12),(13,0,'Pets and Animals','',13),(14,0,'Places and Regions','',14),(15,0,'Science and Technology','',15),(16,0,'Sport','',16),(17,0,'Travel and Events','',17),(18,0,'Other','',18);
/*!40000 ALTER TABLE `posts_videos_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_views`
--

DROP TABLE IF EXISTS `posts_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `posts_views` (
  `view_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `view_date` datetime NOT NULL,
  `post_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `guest_ip` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`view_id`),
  KEY `user_id` (`user_id`),
  KEY `post_id` (`post_id`) USING BTREE,
  KEY `guest_ip` (`guest_ip`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_views`
--

LOCK TABLES `posts_views` WRITE;
/*!40000 ALTER TABLE `posts_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reports` (
  `report_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `reason` text NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `user_id` (`user_id`),
  KEY `category_id` (`category_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_categories`
--

DROP TABLE IF EXISTS `reports_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reports_categories` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_parent_id` int(10) unsigned NOT NULL,
  `category_name` varchar(256) NOT NULL,
  `category_description` text NOT NULL,
  `category_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`category_id`),
  KEY `category_parent_id` (`category_parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_categories`
--

LOCK TABLES `reports_categories` WRITE;
/*!40000 ALTER TABLE `reports_categories` DISABLE KEYS */;
INSERT INTO `reports_categories` VALUES (1,0,'Nudity','',1),(2,0,'Violence','',2),(3,0,'Harassment','',3),(4,0,'Suicide or Self-Injury','',4),(5,0,'False Information','',5),(6,0,'Spam','',6),(7,0,'Unauthorized Sales','',7),(8,0,'Hate Speech','',8),(9,0,'Terrorism','',9),(10,0,'Something Else','',10);
/*!40000 ALTER TABLE `reports_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviews`
--

DROP TABLE IF EXISTS `reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews` (
  `review_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `rate` smallint(6) NOT NULL,
  `review` text NOT NULL,
  `reply` text DEFAULT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`review_id`),
  KEY `user_id` (`user_id`),
  KEY `page_id` (`node_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviews`
--

LOCK TABLES `reviews` WRITE;
/*!40000 ALTER TABLE `reviews` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reviews_photos`
--

DROP TABLE IF EXISTS `reviews_photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reviews_photos` (
  `photo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `review_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  PRIMARY KEY (`photo_id`),
  KEY `review_id` (`review_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reviews_photos`
--

LOCK TABLES `reviews_photos` WRITE;
/*!40000 ALTER TABLE `reviews_photos` DISABLE KEYS */;
/*!40000 ALTER TABLE `reviews_photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shopping_cart`
--

DROP TABLE IF EXISTS `shopping_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopping_cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `product_post_id` int(10) unsigned NOT NULL,
  `quantity` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `product_post_id` (`product_post_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shopping_cart`
--

LOCK TABLES `shopping_cart` WRITE;
/*!40000 ALTER TABLE `shopping_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `shopping_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sneak_peaks`
--

DROP TABLE IF EXISTS `sneak_peaks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sneak_peaks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_node_id_node_type` (`user_id`,`node_id`,`node_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sneak_peaks`
--

LOCK TABLES `sneak_peaks` WRITE;
/*!40000 ALTER TABLE `sneak_peaks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sneak_peaks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `static_pages`
--

DROP TABLE IF EXISTS `static_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `static_pages` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_title` varchar(256) NOT NULL,
  `page_is_redirect` enum('0','1') NOT NULL DEFAULT '0',
  `page_redirect_url` varchar(256) DEFAULT NULL,
  `page_url` varchar(64) DEFAULT NULL,
  `page_text` mediumtext NOT NULL,
  `page_in_footer` enum('0','1') NOT NULL DEFAULT '1',
  `page_in_sidebar` enum('0','1') NOT NULL DEFAULT '0',
  `page_icon` varchar(256) DEFAULT NULL,
  `page_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_url` (`page_url`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `static_pages`
--

LOCK TABLES `static_pages` WRITE;
/*!40000 ALTER TABLE `static_pages` DISABLE KEYS */;
INSERT INTO `static_pages` VALUES (1,'About','0','','about','&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Big Title&lt;/h3&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;\r\n&lt;h3 class=&quot;text-info&quot;&gt;Big Title&lt;/h3&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&lt;/p&gt;','1','0',NULL,1),(2,'Terms','0','','terms','&lt;p&gt;The Sngine website located at &lt;a href=&quot;https://demo.sngine.com/&quot;&gt;https://demo.sngine.com/&lt;/a&gt; is a copyrighted work belonging to Sngine. Certain features of the Site may be subject to additional guidelines, terms, or rules, which will be posted on the Site in connection with such features.&lt;/p&gt;\r\n&lt;p&gt;All such additional terms, guidelines, and rules are incorporated by reference into these Terms.&lt;/p&gt;\r\n&lt;p&gt;These Terms of Use described the legally binding terms and conditions that oversee your use of the Site.&amp;nbsp;BY LOGGING INTO THE SITE, YOU ARE BEING COMPLIANT THAT THESE TERMS and you represent that you have the authority and capacity to enter into these Terms.&amp;nbsp;YOU SHOULD BE AT LEAST 18 YEARS OF AGE TO ACCESS THE SITE. IF YOU DISAGREE WITH ALL OF THE PROVISION OF THESE TERMS, DO NOT LOG INTO AND/OR USE THE SITE.&lt;/p&gt;\r\n&lt;p&gt;These terms require the use of arbitration Section 10.2 on an individual basis to resolve disputes and also limit the remedies available to you in the event of a dispute.&lt;/p&gt;\r\n&lt;h2&gt;Access to the Site&lt;/h2&gt;\r\n&lt;p&gt;&lt;strong&gt;Subject to these Terms.&lt;/strong&gt; Company grants you a non-transferable, non-exclusive, revocable, limited license to access the Site solely for your own personal, noncommercial use.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Certain Restrictions.&lt;/strong&gt; The rights approved to you in these Terms are subject to the following restrictions: (a) you shall not sell, rent, lease, transfer, assign, distribute, host, or otherwise commercially exploit the Site; (b) you shall not change, make derivative works of, disassemble, reverse compile or reverse engineer any part of the Site; (c) you shall not access the Site in order to build a similar or competitive website; and (d) except as expressly stated herein, no part of the Site may be copied, reproduced, distributed, republished, downloaded, displayed, posted or transmitted in any form or by any means unless otherwise indicated, any future release, update, or other addition to functionality of the Site shall be subject to these Terms.&amp;nbsp; All copyright and other proprietary notices on the Site must be retained on all copies thereof.&lt;/p&gt;\r\n&lt;p&gt;Company reserves the right to change, suspend, or cease the Site with or without notice to you.&amp;nbsp; You approved that Company will not be held liable to you or any third-party for any change, interruption, or termination of the Site or any part.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;No Support or Maintenance.&lt;/strong&gt; You agree that Company will have no obligation to provide you with any support in connection with the Site.&lt;/p&gt;\r\n&lt;p&gt;Excluding any User Content that you may provide, you are aware that all the intellectual property rights, including copyrights, patents, trademarks, and trade secrets, in the Site and its content are owned by Company or Company&amp;rsquo;s suppliers. Note that these Terms and access to the Site do not give you any rights, title or interest in or to any intellectual property rights, except for the limited access rights expressed in Section 2.1. Company and its suppliers reserve all rights not granted in these Terms.&lt;/p&gt;\r\n&lt;h2&gt;User Content&lt;/h2&gt;\r\n&lt;p&gt;&lt;strong&gt;User Content.&lt;/strong&gt; &quot;User Content&quot; means any and all information and content that a user submits to the Site. You are exclusively responsible for your User Content. You bear all risks associated with use of your User Content.&amp;nbsp; You hereby certify that your User Content does not violate our Acceptable Use Policy.&amp;nbsp; You may not represent or imply to others that your User Content is in any way provided, sponsored or endorsed by Company. Because you alone are responsible for your User Content, you may expose yourself to liability. Company is not obliged to backup any User Content that you post; also, your User Content may be deleted at any time without prior notice to you. You are solely responsible for making your own backup copies of your User Content if you desire.&lt;/p&gt;\r\n&lt;p&gt;You hereby grant to Company an irreversible, nonexclusive, royalty-free and fully paid, worldwide license to reproduce, distribute, publicly display and perform, prepare derivative works of, incorporate into other works, and otherwise use and exploit your User Content, and to grant sublicenses of the foregoing rights, solely for the purposes of including your User Content in the Site.&amp;nbsp; You hereby irreversibly waive any claims and assertions of moral rights or attribution with respect to your User Content.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Acceptable Use Policy.&lt;/strong&gt; The following terms constitute our &quot;Acceptable Use Policy&quot;: You agree not to use the Site to collect, upload, transmit, display, or distribute any User Content (i) that violates any third-party right or any intellectual property or proprietary right; (ii) that is unlawful, harassing, abusive, tortious, threatening, harmful, invasive of another&amp;rsquo;s privacy, vulgar, defamatory, false, intentionally misleading, trade libelous, pornographic, obscene, patently offensive, promotes racism, bigotry, hatred, or physical harm of any kind against any group or individual; (iii) that is harmful to minors in any way; or (iv) that is in violation of any law, regulation, or obligations or restrictions imposed by any third party.&lt;/p&gt;\r\n&lt;p&gt;In addition, you agree not to: (i) upload, transmit, or distribute to or through the Site any software intended to damage or alter a computer system or data; (ii) send through the Site unsolicited or unauthorized advertising, promotional materials, junk mail, spam, chain letters, pyramid schemes, or any other form of duplicative or unsolicited messages; (iii) use the Site to harvest, collect, gather or assemble information or data regarding other users without their consent; (iv) interfere with, disrupt, or create an undue burden on servers or networks connected to the Site, or violate the regulations, policies or procedures of such networks; (v) attempt to gain unauthorized access to the Site, whether through password mining or any other means; (vi) harass or interfere with any other user&amp;rsquo;s use and enjoyment of the Site; or (vi) use software or automated agents or scripts to produce multiple accounts on the Site, or to generate automated searches, requests, or queries to the Site.&lt;/p&gt;\r\n&lt;p&gt;We reserve the right to review any User Content, and to investigate and/or take appropriate action against you in our sole discretion if you violate the Acceptable Use Policy or any other provision of these Terms or otherwise create liability for us or any other person. Such action may include removing or modifying your User Content, terminating your Account in accordance with Section 8, and/or reporting you to law enforcement authorities.&lt;/p&gt;\r\n&lt;p&gt;If you provide Company with any feedback or suggestions regarding the Site, you hereby assign to Company all rights in such Feedback and agree that Company shall have the right to use and fully exploit such Feedback and related information in any manner it believes appropriate.&amp;nbsp; Company will treat any Feedback you provide to Company as non-confidential and non-proprietary.&lt;/p&gt;\r\n&lt;p&gt;You agree to indemnify and hold Company and its officers, employees, and agents harmless, including costs and attorneys&amp;rsquo; fees, from any claim or demand made by any third-party due to or arising out of (a) your use of the Site, (b) your violation of these Terms, (c) your violation of applicable laws or regulations or (d) your User Content.&amp;nbsp; Company reserves the right to assume the exclusive defense and control of any matter for which you are required to indemnify us, and you agree to cooperate with our defense of these claims.&amp;nbsp; You agree not to settle any matter without the prior written consent of Company.&amp;nbsp; Company will use reasonable efforts to notify you of any such claim, action or proceeding upon becoming aware of it.&lt;/p&gt;\r\n&lt;h2&gt;Third-Party Links &amp;amp; Ads; Other Users&lt;/h2&gt;\r\n&lt;p&gt;&lt;strong&gt;Third-Party Links &amp;amp; Ads.&lt;/strong&gt; The Site may contain links to third-party websites and services, and/or display advertisements for third-parties.&amp;nbsp; Such Third-Party Links &amp;amp; Ads are not under the control of Company, and Company is not responsible for any Third-Party Links &amp;amp; Ads.&amp;nbsp; Company provides access to these Third-Party Links &amp;amp; Ads only as a convenience to you, and does not review, approve, monitor, endorse, warrant, or make any representations with respect to Third-Party Links &amp;amp; Ads.&amp;nbsp; You use all Third-Party Links &amp;amp; Ads at your own risk, and should apply a suitable level of caution and discretion in doing so. When you click on any of the Third-Party Links &amp;amp; Ads, the applicable third party&amp;rsquo;s terms and policies apply, including the third party&amp;rsquo;s privacy and data gathering practices.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Other Users.&lt;/strong&gt; Each Site user is solely responsible for any and all of its own User Content.&amp;nbsp; Because we do not control User Content, you acknowledge and agree that we are not responsible for any User Content, whether provided by you or by others.&amp;nbsp; You agree that Company will not be responsible for any loss or damage incurred as the result of any such interactions.&amp;nbsp; If there is a dispute between you and any Site user, we are under no obligation to become involved.&lt;/p&gt;\r\n&lt;p&gt;You hereby release and forever discharge the Company and our officers, employees, agents, successors, and assigns from, and hereby waive and relinquish, each and every past, present and future dispute, claim, controversy, demand, right, obligation, liability, action and cause of action of every kind and nature, that has arisen or arises directly or indirectly out of, or that relates directly or indirectly to, the Site. If you are a California resident, you hereby waive California civil code section 1542 in connection with the foregoing, which states: &quot;a general release does not extend to claims which the creditor does not know or suspect to exist in his or her favor at the time of executing the release, which if known by him or her must have materially affected his or her settlement with the debtor.&quot;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Cookies and Web Beacons.&lt;/strong&gt; Like any other website, Sngine uses &amp;lsquo;cookies&amp;rsquo;. These cookies are used to store information including visitors&amp;rsquo; preferences, and the pages on the website that the visitor accessed or visited. The information is used to optimize the users&amp;rsquo; experience by customizing our web page content based on visitors&amp;rsquo; browser type and/or other information.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Google DoubleClick DART Cookie.&lt;/strong&gt; Google is one of a third-party vendor on our site. It also uses cookies, known as DART cookies, to serve ads to our site visitors based upon their visit to www.website.com and other sites on the internet. However, visitors may choose to decline the use of DART cookies by visiting the Google ad and content network Privacy Policy at the following URL &amp;ndash; &lt;a href=&quot;https://policies.google.com/technologies/ads&quot;&gt;https://policies.google.com/technologies/ads&lt;/a&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Our Advertising Partners.&lt;/strong&gt; Some of advertisers on our site may use cookies and web beacons. Our advertising partners are listed below. Each of our advertising partners has their own Privacy Policy for their policies on user data. For easier access, we hyperlinked to their Privacy Policies below.&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;\r\n&lt;p&gt;Google&lt;/p&gt;\r\n&lt;p&gt;&lt;a href=&quot;https://policies.google.com/technologies/ads&quot;&gt;https://policies.google.com/technologies/ads&lt;/a&gt;&lt;/p&gt;\r\n&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;h2&gt;Disclaimers&lt;/h2&gt;\r\n&lt;p&gt;The site is provided on an &quot;as-is&quot; and &quot;as available&quot; basis, and company and our suppliers expressly disclaim any and all warranties and conditions of any kind, whether express, implied, or statutory, including all warranties or conditions of merchantability, fitness for a particular purpose, title, quiet enjoyment, accuracy, or non-infringement.&amp;nbsp; We and our suppliers make not guarantee that the site will meet your requirements, will be available on an uninterrupted, timely, secure, or error-free basis, or will be accurate, reliable, free of viruses or other harmful code, complete, legal, or safe.&amp;nbsp; If applicable law requires any warranties with respect to the site, all such warranties are limited in duration to ninety (90) days from the date of first use.&lt;/p&gt;\r\n&lt;p&gt;Some jurisdictions do not allow the exclusion of implied warranties, so the above exclusion may not apply to you.&amp;nbsp; Some jurisdictions do not allow limitations on how long an implied warranty lasts, so the above limitation may not apply to you.&lt;/p&gt;\r\n&lt;h2&gt;Limitation on Liability&lt;/h2&gt;\r\n&lt;p&gt;To the maximum extent permitted by law, in no event shall company or our suppliers be liable to you or any third-party for any lost profits, lost data, costs of procurement of substitute products, or any indirect, consequential, exemplary, incidental, special or punitive damages arising from or relating to these terms or your use of, or incapability to use the site even if company has been advised of the possibility of such damages.&amp;nbsp; Access to and use of the site is at your own discretion and risk, and you will be solely responsible for any damage to your device or computer system, or loss of data resulting therefrom.&lt;/p&gt;\r\n&lt;p&gt;To the maximum extent permitted by law, notwithstanding anything to the contrary contained herein, our liability to you for any damages arising from or related to this agreement, will at all times be limited to a maximum of fifty U.S. dollars (u.s. $50). The existence of more than one claim will not enlarge this limit.&amp;nbsp; You agree that our suppliers will have no liability of any kind arising from or relating to this agreement.&lt;/p&gt;\r\n&lt;p&gt;Some jurisdictions do not allow the limitation or exclusion of liability for incidental or consequential damages, so the above limitation or exclusion may not apply to you.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Term and Termination.&lt;/strong&gt; Subject to this Section, these Terms will remain in full force and effect while you use the Site.&amp;nbsp; We may suspend or terminate your rights to use the Site at any time for any reason at our sole discretion, including for any use of the Site in violation of these Terms.&amp;nbsp; Upon termination of your rights under these Terms, your Account and right to access and use the Site will terminate immediately.&amp;nbsp; You understand that any termination of your Account may involve deletion of your User Content associated with your Account from our live databases.&amp;nbsp; Company will not have any liability whatsoever to you for any termination of your rights under these Terms.&amp;nbsp; Even after your rights under these Terms are terminated, the following provisions of these Terms will remain in effect: Sections 2 through 2.5, Section 3 and Sections 4 through 10.&lt;/p&gt;\r\n&lt;h2&gt;Copyright Policy.&lt;/h2&gt;\r\n&lt;p&gt;Company respects the intellectual property of others and asks that users of our Site do the same.&amp;nbsp; In connection with our Site, we have adopted and implemented a policy respecting copyright law that provides for the removal of any infringing materials and for the termination of users of our online Site who are repeated infringers of intellectual property rights, including copyrights.&amp;nbsp; If you believe that one of our users is, through the use of our Site, unlawfully infringing the copyright(s) in a work, and wish to have the allegedly infringing material removed, the following information in the form of a written notification (pursuant to 17 U.S.C. &amp;sect; 512(c)) must be provided to our designated Copyright Agent:&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;your physical or electronic signature;&lt;/li&gt;\r\n&lt;li&gt;identification of the copyrighted work(s) that you claim to have been infringed;&lt;/li&gt;\r\n&lt;li&gt;identification of the material on our services that you claim is infringing and that you request us to remove;&lt;/li&gt;\r\n&lt;li&gt;sufficient information to permit us to locate such material;&lt;/li&gt;\r\n&lt;li&gt;your address, telephone number, and e-mail address;&lt;/li&gt;\r\n&lt;li&gt;a statement that you have a good faith belief that use of the objectionable material is not authorized by the copyright owner, its agent, or under the law; and&lt;/li&gt;\r\n&lt;li&gt;a statement that the information in the notification is accurate, and under penalty of perjury, that you are either the owner of the copyright that has allegedly been infringed or that you are authorized to act on behalf of the copyright owner.&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;Please note that, pursuant to 17 U.S.C. &amp;sect; 512(f), any misrepresentation of material fact in a written notification automatically subjects the complaining party to liability for any damages, costs and attorney&amp;rsquo;s fees incurred by us in connection with the written notification and allegation of copyright infringement.&lt;/p&gt;\r\n&lt;h2&gt;General&lt;/h2&gt;\r\n&lt;p&gt;These Terms are subject to occasional revision, and if we make any substantial changes, we may notify you by sending you an e-mail to the last e-mail address you provided to us and/or by prominently posting notice of the changes on our Site.&amp;nbsp; You are responsible for providing us with your most current e-mail address.&amp;nbsp; In the event that the last e-mail address that you have provided us is not valid our dispatch of the e-mail containing such notice will nonetheless constitute effective notice of the changes described in the notice.&amp;nbsp; Any changes to these Terms will be effective upon the earliest of thirty (30) calendar days following our dispatch of an e-mail notice to you or thirty (30) calendar days following our posting of notice of the changes on our Site.&amp;nbsp; These changes will be effective immediately for new users of our Site.&amp;nbsp; Continued use of our Site following notice of such changes shall indicate your acknowledgement of such changes and agreement to be bound by the terms and conditions of such changes. Dispute Resolution. Please read this Arbitration Agreement carefully. It is part of your contract with Company and affects your rights.&amp;nbsp; It contains procedures for MANDATORY BINDING ARBITRATION AND A CLASS ACTION WAIVER.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Applicability of Arbitration Agreement.&lt;/strong&gt; All claims and disputes in connection with the Terms or the use of any product or service provided by the Company that cannot be resolved informally or in small claims court shall be resolved by binding arbitration on an individual basis under the terms of this Arbitration Agreement.&amp;nbsp; Unless otherwise agreed to, all arbitration proceedings shall be held in English.&amp;nbsp; This Arbitration Agreement applies to you and the Company, and to any subsidiaries, affiliates, agents, employees, predecessors in interest, successors, and assigns, as well as all authorized or unauthorized users or beneficiaries of services or goods provided under the Terms.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Notice Requirement and Informal Dispute Resolution.&lt;/strong&gt; Before either party may seek arbitration, the party must first send to the other party a written Notice of Dispute describing the nature and basis of the claim or dispute, and the requested relief.&amp;nbsp; A Notice to the Company should be sent to: Sngine. After the Notice is received, you and the Company may attempt to resolve the claim or dispute informally.&amp;nbsp; If you and the Company do not resolve the claim or dispute within thirty (30) days after the Notice is received, either party may begin an arbitration proceeding.&amp;nbsp; The amount of any settlement offer made by any party may not be disclosed to the arbitrator until after the arbitrator has determined the amount of the award to which either party is entitled.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Arbitration Rules.&lt;/strong&gt; Arbitration shall be initiated through the American Arbitration Association, an established alternative dispute resolution provider that offers arbitration as set forth in this section.&amp;nbsp; If AAA is not available to arbitrate, the parties shall agree to select an alternative ADR Provider.&amp;nbsp; The rules of the ADR Provider shall govern all aspects of the arbitration except to the extent such rules are in conflict with the Terms.&amp;nbsp; The AAA Consumer Arbitration Rules governing the arbitration are available online at adr.org or by calling the AAA at 1-800-778-7879.&amp;nbsp; The arbitration shall be conducted by a single, neutral arbitrator.&amp;nbsp; Any claims or disputes where the total amount of the award sought is less than Ten Thousand U.S. Dollars (US $10,000.00) may be resolved through binding non-appearance-based arbitration, at the option of the party seeking relief.&amp;nbsp; For claims or disputes where the total amount of the award sought is Ten Thousand U.S. Dollars (US $10,000.00) or more, the right to a hearing will be determined by the Arbitration Rules.&amp;nbsp; Any hearing will be held in a location within 100 miles of your residence, unless you reside outside of the United States, and unless the parties agree otherwise.&amp;nbsp; If you reside outside of the U.S., the arbitrator shall give the parties reasonable notice of the date, time and place of any oral hearings. Any judgment on the award rendered by the arbitrator may be entered in any court of competent jurisdiction.&amp;nbsp; If the arbitrator grants you an award that is greater than the last settlement offer that the Company made to you prior to the initiation of arbitration, the Company will pay you the greater of the award or $2,500.00.&amp;nbsp; Each party shall bear its own costs and disbursements arising out of the arbitration and shall pay an equal share of the fees and costs of the ADR Provider.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Additional Rules for Non-Appearance Based Arbitration.&lt;/strong&gt; If non-appearance based arbitration is elected, the arbitration shall be conducted by telephone, online and/or based solely on written submissions; the specific manner shall be chosen by the party initiating the arbitration.&amp;nbsp; The arbitration shall not involve any personal appearance by the parties or witnesses unless otherwise agreed by the parties.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Time Limits.&lt;/strong&gt; If you or the Company pursues arbitration, the arbitration action must be initiated and/or demanded within the statute of limitations and within any deadline imposed under the AAA Rules for the pertinent claim.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Authority of Arbitrator.&lt;/strong&gt; If arbitration is initiated, the arbitrator will decide the rights and liabilities of you and the Company, and the dispute will not be consolidated with any other matters or joined with any other cases or parties.&amp;nbsp; The arbitrator shall have the authority to grant motions dispositive of all or part of any claim.&amp;nbsp; The arbitrator shall have the authority to award monetary damages, and to grant any non-monetary remedy or relief available to an individual under applicable law, the AAA Rules, and the Terms.&amp;nbsp; The arbitrator shall issue a written award and statement of decision describing the essential findings and conclusions on which the award is based.&amp;nbsp; The arbitrator has the same authority to award relief on an individual basis that a judge in a court of law would have.&amp;nbsp; The award of the arbitrator is final and binding upon you and the Company.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Waiver of Jury Trial.&lt;/strong&gt; THE PARTIES HEREBY WAIVE THEIR CONSTITUTIONAL AND STATUTORY RIGHTS TO GO TO COURT AND HAVE A TRIAL IN FRONT OF A JUDGE OR A JURY, instead electing that all claims and disputes shall be resolved by arbitration under this Arbitration Agreement.&amp;nbsp; Arbitration procedures are typically more limited, more efficient and less expensive than rules applicable in a court and are subject to very limited review by a court.&amp;nbsp; In the event any litigation should arise between you and the Company in any state or federal court in a suit to vacate or enforce an arbitration award or otherwise, YOU AND THE COMPANY WAIVE ALL RIGHTS TO A JURY TRIAL, instead electing that the dispute be resolved by a judge.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Waiver of Class or Consolidated Actions.&lt;/strong&gt; All claims and disputes within the scope of this arbitration agreement must be arbitrated or litigated on an individual basis and not on a class basis, and claims of more than one customer or user cannot be arbitrated or litigated jointly or consolidated with those of any other customer or user.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Confidentiality.&lt;/strong&gt; All aspects of the arbitration proceeding shall be strictly confidential.&amp;nbsp; The parties agree to maintain confidentiality unless otherwise required by law.&amp;nbsp; This paragraph shall not prevent a party from submitting to a court of law any information necessary to enforce this Agreement, to enforce an arbitration award, or to seek injunctive or equitable relief.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Severability.&lt;/strong&gt; If any part or parts of this Arbitration Agreement are found under the law to be invalid or unenforceable by a court of competent jurisdiction, then such specific part or parts shall be of no force and effect and shall be severed and the remainder of the Agreement shall continue in full force and effect.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Right to Waive.&lt;/strong&gt; Any or all of the rights and limitations set forth in this Arbitration Agreement may be waived by the party against whom the claim is asserted.&amp;nbsp; Such waiver shall not waive or affect any other portion of this Arbitration Agreement.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Survival of Agreement.&lt;/strong&gt; This Arbitration Agreement will survive the termination of your relationship with Company.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Small Claims Court.&lt;/strong&gt; Nonetheless the foregoing, either you or the Company may bring an individual action in small claims court.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Emergency Equitable Relief.&lt;/strong&gt; Anyhow the foregoing, either party may seek emergency equitable relief before a state or federal court in order to maintain the status quo pending arbitration.&amp;nbsp; A request for interim measures shall not be deemed a waiver of any other rights or obligations under this Arbitration Agreement.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Claims Not Subject to Arbitration.&lt;/strong&gt; Notwithstanding the foregoing, claims of defamation, violation of the Computer Fraud and Abuse Act, and infringement or misappropriation of the other party&amp;rsquo;s patent, copyright, trademark or trade secrets shall not be subject to this Arbitration Agreement.&lt;/p&gt;\r\n&lt;p&gt;In any circumstances where the foregoing Arbitration Agreement permits the parties to litigate in court, the parties hereby agree to submit to the personal jurisdiction of the courts located within Netherlands County, California, for such purposes.&lt;/p&gt;\r\n&lt;p&gt;The Site may be subject to U.S. export control laws and may be subject to export or import regulations in other countries. You agree not to export, re-export, or transfer, directly or indirectly, any U.S. technical data acquired from Company, or any products utilizing such data, in violation of the United States export laws or regulations.&lt;/p&gt;\r\n&lt;p&gt;Company is located at the address in Section 10.8. If you are a California resident, you may report complaints to the Complaint Assistance Unit of the Division of Consumer Product of the California Department of Consumer Affairs by contacting them in writing at 400 R Street, Sacramento, CA 95814, or by telephone at (800) 952-5210.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Electronic Communications.&lt;/strong&gt; The communications between you and Company use electronic means, whether you use the Site or send us emails, or whether Company posts notices on the Site or communicates with you via email. For contractual purposes, you (a) consent to receive communications from Company in an electronic form; and (b) agree that all terms and conditions, agreements, notices, disclosures, and other communications that Company provides to you electronically satisfy any legal obligation that such communications would satisfy if it were be in a hard copy writing.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Entire Terms.&lt;/strong&gt; These Terms constitute the entire agreement between you and us regarding the use of the Site. Our failure to exercise or enforce any right or provision of these Terms shall not operate as a waiver of such right or provision. The section titles in these Terms are for convenience only and have no legal or contractual effect. The word &quot;including&quot; means &quot;including without limitation&quot;. If any provision of these Terms is held to be invalid or unenforceable, the other provisions of these Terms will be unimpaired and the invalid or unenforceable provision will be deemed modified so that it is valid and enforceable to the maximum extent permitted by law.&amp;nbsp; Your relationship to Company is that of an independent contractor, and neither party is an agent or partner of the other.&amp;nbsp; These Terms, and your rights and obligations herein, may not be assigned, subcontracted, delegated, or otherwise transferred by you without Company&amp;rsquo;s prior written consent, and any attempted assignment, subcontract, delegation, or transfer in violation of the foregoing will be null and void.&amp;nbsp; Company may freely assign these Terms.&amp;nbsp; The terms and conditions set forth in these Terms shall be binding upon assignees.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Your Privacy.&lt;/strong&gt; Please read our Privacy Policy.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Copyright/Trademark Information.&lt;/strong&gt; Copyright &amp;copy;. All rights reserved.&amp;nbsp; All trademarks, logos and service marks displayed on the Site are our property or the property of other third-parties. You are not permitted to use these Marks without our prior written consent or the consent of such third party which may own the Marks.&lt;/p&gt;','1','0',NULL,2),(3,'Privacy','0','','privacy','&lt;p&gt;At Sngine, accessible from &lt;a href=&quot;https://demo.sngine.com/&quot;&gt;https://demo.sngine.com/&lt;/a&gt;, one of our main priorities is the privacy of our visitors. This Privacy Policy document contains types of information that is collected and recorded by Sngine and how we use it.&lt;/p&gt;\r\n&lt;p&gt;If you have additional questions or require more information about our Privacy Policy, do not hesitate to contact us.&lt;/p&gt;\r\n&lt;p&gt;This Privacy Policy applies only to our online activities and is valid for visitors to our website with regards to the information that they shared and/or collect in Sngine. This policy is not applicable to any information collected offline or via channels other than this website.&lt;/p&gt;\r\n&lt;h2&gt;Consent&lt;/h2&gt;\r\n&lt;p&gt;By using our website, you hereby consent to our Privacy Policy and agree to its terms.&lt;/p&gt;\r\n&lt;h2&gt;Information we collect&lt;/h2&gt;\r\n&lt;p&gt;The personal information that you are asked to provide, and the reasons why you are asked to provide it, will be made clear to you at the point we ask you to provide your personal information.&lt;/p&gt;\r\n&lt;p&gt;If you contact us directly, we may receive additional information about you such as your name, email address, phone number, the contents of the message and/or attachments you may send us, and any other information you may choose to provide.&lt;/p&gt;\r\n&lt;p&gt;When you register for an Account, we may ask for your contact information, including items such as name, company name, address, email address, and telephone number.&lt;/p&gt;\r\n&lt;h2&gt;How we use your information&lt;/h2&gt;\r\n&lt;p&gt;We use the information we collect in various ways, including to:&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;Provide, operate, and maintain our website&lt;/li&gt;\r\n&lt;li&gt;Improve, personalize, and expand our website&lt;/li&gt;\r\n&lt;li&gt;Understand and analyze how you use our website&lt;/li&gt;\r\n&lt;li&gt;Develop new products, services, features, and functionality&lt;/li&gt;\r\n&lt;li&gt;Communicate with you, either directly or through one of our partners, including for customer service, to provide you with updates and other information relating to the website, and for marketing and promotional purposes&lt;/li&gt;\r\n&lt;li&gt;Send you emails&lt;/li&gt;\r\n&lt;li&gt;Find and prevent fraud&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;h2&gt;Log Files&lt;/h2&gt;\r\n&lt;p&gt;Sngine follows a standard procedure of using log files. These files log visitors when they visit websites. All hosting companies do this and a part of hosting services&#039; analytics. The information collected by log files include internet protocol (IP) addresses, browser type, Internet Service Provider (ISP), date and time stamp, referring/exit pages, and possibly the number of clicks. These are not linked to any information that is personally identifiable. The purpose of the information is for analyzing trends, administering the site, tracking users&#039; movement on the website, and gathering demographic information.&lt;/p&gt;\r\n&lt;h2&gt;Cookies and Web Beacons&lt;/h2&gt;\r\n&lt;p&gt;Like any other website, Sngine uses &#039;cookies&#039;. These cookies are used to store information including visitors&#039; preferences, and the pages on the website that the visitor accessed or visited. The information is used to optimize the users&#039; experience by customizing our web page content based on visitors&#039; browser type and/or other information.&lt;/p&gt;\r\n&lt;h2&gt;Google DoubleClick DART Cookie&lt;/h2&gt;\r\n&lt;p&gt;Google is one of a third-party vendor on our site. It also uses cookies, known as DART cookies, to serve ads to our site visitors based upon their visit to www.website.com and other sites on the internet. However, visitors may choose to decline the use of DART cookies by visiting the Google ad and content network Privacy Policy at the following URL &amp;ndash;&amp;nbsp;&lt;a href=&quot;https://policies.google.com/technologies/ads&quot;&gt;https://policies.google.com/technologies/ads&lt;/a&gt;&lt;/p&gt;\r\n&lt;h2&gt;Our Advertising Partners&lt;/h2&gt;\r\n&lt;p&gt;Some of advertisers on our site may use cookies and web beacons. Our advertising partners are listed below. Each of our advertising partners has their own Privacy Policy for their policies on user data. For easier access, we hyperlinked to their Privacy Policies below.&lt;/p&gt;\r\n&lt;ul&gt;\r\n&lt;li&gt;\r\n&lt;p&gt;Google&lt;/p&gt;\r\n&lt;p&gt;&lt;a href=&quot;https://policies.google.com/technologies/ads&quot;&gt;https://policies.google.com/technologies/ads&lt;/a&gt;&lt;/p&gt;\r\n&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;h2&gt;Advertising Partners Privacy Policies&lt;/h2&gt;\r\n&lt;p&gt;You may consult this list to find the Privacy Policy for each of the advertising partners of Sngine.&lt;/p&gt;\r\n&lt;p&gt;Third-party ad servers or ad networks uses technologies like cookies, JavaScript, or Web Beacons that are used in their respective advertisements and links that appear on Sngine, which are sent directly to users&#039; browser. They automatically receive your IP address when this occurs. These technologies are used to measure the effectiveness of their advertising campaigns and/or to personalize the advertising content that you see on websites that you visit.&lt;/p&gt;\r\n&lt;p&gt;Note that Sngine has no access to or control over these cookies that are used by third-party advertisers.&lt;/p&gt;\r\n&lt;h2&gt;Third Party Privacy Policies&lt;/h2&gt;\r\n&lt;p&gt;Sngine&#039;s Privacy Policy does not apply to other advertisers or websites. Thus, we are advising you to consult the respective Privacy Policies of these third-party ad servers for more detailed information. It may include their practices and instructions about how to opt-out of certain options.&lt;/p&gt;\r\n&lt;p&gt;You can choose to disable cookies through your individual browser options. To know more detailed information about cookie management with specific web browsers, it can be found at the browsers&#039; respective websites.&lt;/p&gt;\r\n&lt;h2&gt;CCPA Privacy Rights (Do Not Sell My Personal Information)&lt;/h2&gt;\r\n&lt;p&gt;Under the CCPA, among other rights, California consumers have the right to:&lt;/p&gt;\r\n&lt;p&gt;Request that a business that collects a consumer&#039;s personal data disclose the categories and specific pieces of personal data that a business has collected about consumers.&lt;/p&gt;\r\n&lt;p&gt;Request that a business delete any personal data about the consumer that a business has collected.&lt;/p&gt;\r\n&lt;p&gt;Request that a business that sells a consumer&#039;s personal data, not sell the consumer&#039;s personal data.&lt;/p&gt;\r\n&lt;p&gt;If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.&lt;/p&gt;\r\n&lt;h2&gt;GDPR Data Protection Rights&lt;/h2&gt;\r\n&lt;p&gt;We would like to make sure you are fully aware of all of your data protection rights. Every user is entitled to the following:&lt;/p&gt;\r\n&lt;p&gt;The right to access &amp;ndash; You have the right to request copies of your personal data. We may charge you a small fee for this service.&lt;/p&gt;\r\n&lt;p&gt;The right to rectification &amp;ndash; You have the right to request that we correct any information you believe is inaccurate. You also have the right to request that we complete the information you believe is incomplete.&lt;/p&gt;\r\n&lt;p&gt;The right to erasure &amp;ndash; You have the right to request that we erase your personal data, under certain conditions.&lt;/p&gt;\r\n&lt;p&gt;The right to restrict processing &amp;ndash; You have the right to request that we restrict the processing of your personal data, under certain conditions.&lt;/p&gt;\r\n&lt;p&gt;The right to object to processing &amp;ndash; You have the right to object to our processing of your personal data, under certain conditions.&lt;/p&gt;\r\n&lt;p&gt;The right to data portability &amp;ndash; You have the right to request that we transfer the data that we have collected to another organization, or directly to you, under certain conditions.&lt;/p&gt;\r\n&lt;p&gt;If you make a request, we have one month to respond to you. If you would like to exercise any of these rights, please contact us.&lt;/p&gt;\r\n&lt;h2&gt;Children&#039;s Information&lt;/h2&gt;\r\n&lt;p&gt;Another part of our priority is adding protection for children while using the internet. We encourage parents and guardians to observe, participate in, and/or monitor and guide their online activity.&lt;/p&gt;\r\n&lt;p&gt;Sngine does not knowingly collect any Personal Identifiable Information from children under the age of 13. If you think that your child provided this kind of information on our website, we strongly encourage you to contact us immediately and we will do our best efforts to promptly remove such information from our records.&lt;/p&gt;','1','0',NULL,3);
/*!40000 ALTER TABLE `static_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stickers`
--

DROP TABLE IF EXISTS `stickers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stickers` (
  `sticker_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(256) NOT NULL,
  PRIMARY KEY (`sticker_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stickers`
--

LOCK TABLES `stickers` WRITE;
/*!40000 ALTER TABLE `stickers` DISABLE KEYS */;
INSERT INTO `stickers` VALUES (1,'stickers/1.png'),(2,'stickers/2.png'),(3,'stickers/3.png'),(4,'stickers/4.png'),(5,'stickers/5.png'),(6,'stickers/6.png'),(7,'stickers/7.png'),(8,'stickers/8.png'),(9,'stickers/9.png'),(10,'stickers/10.png'),(11,'stickers/11.png'),(12,'stickers/12.png'),(13,'stickers/13.png'),(14,'stickers/14.png'),(15,'stickers/15.png'),(16,'stickers/16.png'),(17,'stickers/17.png'),(18,'stickers/18.png'),(19,'stickers/19.png'),(20,'stickers/20.png');
/*!40000 ALTER TABLE `stickers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stories`
--

DROP TABLE IF EXISTS `stories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stories` (
  `story_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `is_ads` enum('0','1') NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`story_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stories`
--

LOCK TABLES `stories` WRITE;
/*!40000 ALTER TABLE `stories` DISABLE KEYS */;
/*!40000 ALTER TABLE `stories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `stories_media`
--

DROP TABLE IF EXISTS `stories_media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stories_media` (
  `media_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `story_id` int(10) unsigned NOT NULL,
  `source` varchar(256) NOT NULL,
  `is_photo` enum('0','1') NOT NULL DEFAULT '1',
  `text` text NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`media_id`),
  KEY `story_id` (`story_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `stories_media`
--

LOCK TABLES `stories_media` WRITE;
/*!40000 ALTER TABLE `stories_media` DISABLE KEYS */;
/*!40000 ALTER TABLE `stories_media` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscribers`
--

DROP TABLE IF EXISTS `subscribers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscribers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `plan_id` int(10) unsigned NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_node_id_node_type` (`user_id`,`node_id`,`node_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscribers`
--

LOCK TABLES `subscribers` WRITE;
/*!40000 ALTER TABLE `subscribers` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscribers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_countries`
--

DROP TABLE IF EXISTS `system_countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_countries` (
  `country_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_code` varchar(2) NOT NULL,
  `country_name` varchar(64) NOT NULL,
  `phone_code` varchar(8) DEFAULT NULL,
  `country_vat` float unsigned DEFAULT NULL,
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `country_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB AUTO_INCREMENT=246 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_countries`
--

LOCK TABLES `system_countries` WRITE;
/*!40000 ALTER TABLE `system_countries` DISABLE KEYS */;
INSERT INTO `system_countries` VALUES (1,'AF','Afghanistan','+93',NULL,'0','1',1),(2,'AL','Albania','+355',NULL,'0','1',2),(3,'DZ','Algeria','+213',NULL,'0','1',3),(4,'DS','American Samoa','+1684',NULL,'0','1',4),(5,'AD','Andorra','+376',NULL,'0','1',5),(6,'AO','Angola','+244',NULL,'0','1',6),(7,'AI','Anguilla','+1264',NULL,'0','1',7),(8,'AQ','Antarctica','+672',NULL,'0','1',8),(9,'AG','Antigua and Barbuda','+1268',NULL,'0','1',9),(10,'AR','Argentina','+54',NULL,'0','1',10),(11,'AM','Armenia','+374',NULL,'0','1',11),(12,'AW','Aruba','+297',NULL,'0','1',12),(13,'AU','Australia','+61',NULL,'0','1',13),(14,'AT','Austria','+43',NULL,'0','1',14),(15,'AZ','Azerbaijan','+994',NULL,'0','1',15),(16,'BS','Bahamas','+1242',NULL,'0','1',16),(17,'BH','Bahrain','+973',NULL,'0','1',17),(18,'BD','Bangladesh','+880',NULL,'0','1',18),(19,'BB','Barbados','+1246',NULL,'0','1',19),(20,'BY','Belarus','+375',NULL,'0','1',20),(21,'BE','Belgium','+32',NULL,'0','1',21),(22,'BZ','Belize','+501',NULL,'0','1',22),(23,'BJ','Benin','+229',NULL,'0','1',23),(24,'BM','Bermuda','+1441',NULL,'0','1',24),(25,'BT','Bhutan','+975',NULL,'0','1',25),(26,'BO','Bolivia','+591',NULL,'0','1',26),(27,'BA','Bosnia and Herzegovina','+387',NULL,'0','1',27),(28,'BW','Botswana','+267',NULL,'0','1',28),(29,'BV','Bouvet Island','+55',NULL,'0','1',29),(30,'BR','Brazil','+55',NULL,'0','1',30),(31,'IO','British Indian Ocean Territory','+246',NULL,'0','1',31),(32,'BN','Brunei Darussalam','+673',NULL,'0','1',32),(33,'BG','Bulgaria','+359',NULL,'0','1',33),(34,'BF','Burkina Faso','+226',NULL,'0','1',34),(35,'BI','Burundi','+257',NULL,'0','1',35),(36,'KH','Cambodia','+855',NULL,'0','1',36),(37,'CM','Cameroon','+237',NULL,'0','1',37),(38,'CA','Canada','+1',NULL,'0','1',38),(39,'CV','Cape Verde','+238',NULL,'0','1',39),(40,'KY','Cayman Islands','+ 345',NULL,'0','1',40),(41,'CF','Central African Republic','+236',NULL,'0','1',41),(42,'TD','Chad','+235',NULL,'0','1',42),(43,'CL','Chile','+56',NULL,'0','1',43),(44,'CN','China','+86',NULL,'0','1',44),(45,'CX','Christmas Island','+61',NULL,'0','1',45),(46,'CC','Cocos (Keeling) Islands','+61',NULL,'0','1',46),(47,'CO','Colombia','+57',NULL,'0','1',47),(48,'KM','Comoros','+269',NULL,'0','1',48),(49,'CG','Congo','+242',NULL,'0','1',49),(50,'CK','Cook Islands','+682',NULL,'0','1',50),(51,'CR','Costa Rica','+506',NULL,'0','1',51),(52,'HR','Croatia (Hrvatska)','+385',NULL,'0','1',52),(53,'CU','Cuba','+53',NULL,'0','1',53),(54,'CY','Cyprus','+357',NULL,'0','1',54),(55,'CZ','Czech Republic','+420',NULL,'0','1',55),(56,'DK','Denmark','+45',NULL,'0','1',56),(57,'DJ','Djibouti','+253',NULL,'0','1',57),(58,'DM','Dominica','+1767',NULL,'0','1',58),(59,'DO','Dominican Republic','+1849',NULL,'0','1',59),(60,'TP','East Timor',NULL,NULL,'0','1',60),(61,'EC','Ecuador','+593',NULL,'0','1',61),(62,'EG','Egypt','+20',NULL,'0','1',62),(63,'SV','El Salvador','+503',NULL,'0','1',63),(64,'GQ','Equatorial Guinea','+240',NULL,'0','1',64),(65,'ER','Eritrea','+291',NULL,'0','1',65),(66,'EE','Estonia','+372',NULL,'0','1',66),(67,'ET','Ethiopia','+251',NULL,'0','1',67),(68,'FK','Falkland Islands (Malvinas)','+500',NULL,'0','1',68),(69,'FO','Faroe Islands','+298',NULL,'0','1',69),(70,'FJ','Fiji','+679',NULL,'0','1',70),(71,'FI','Finland','+358',NULL,'0','1',71),(72,'FR','France','+33',NULL,'0','1',72),(73,'FX','France, Metropolitan',NULL,NULL,'0','1',73),(74,'GF','French Guiana','+594',NULL,'0','1',74),(75,'PF','French Polynesia','+689',NULL,'0','1',75),(76,'TF','French Southern Territories','+262',NULL,'0','1',76),(77,'GA','Gabon','+241',NULL,'0','1',77),(78,'GM','Gambia','+220',NULL,'0','1',78),(79,'GE','Georgia','+995',NULL,'0','1',79),(80,'DE','Germany','+49',NULL,'0','1',80),(81,'GH','Ghana','+233',NULL,'0','1',81),(82,'GI','Gibraltar','+350',NULL,'0','1',82),(83,'GK','Guernsey','+44',NULL,'0','1',83),(84,'GR','Greece','+30',NULL,'0','1',84),(85,'GL','Greenland','+299',NULL,'0','1',85),(86,'GD','Grenada','+1473',NULL,'0','1',86),(87,'GP','Guadeloupe','+590',NULL,'0','1',87),(88,'GU','Guam','+1671',NULL,'0','1',88),(89,'GT','Guatemala','+502',NULL,'0','1',89),(90,'GN','Guinea','+224',NULL,'0','1',90),(91,'GW','Guinea-Bissau','+245',NULL,'0','1',91),(92,'GY','Guyana','+595',NULL,'0','1',92),(93,'HT','Haiti','+509',NULL,'0','1',93),(94,'HM','Heard and Mc Donald Islands',NULL,NULL,'0','1',94),(95,'HN','Honduras','+504',NULL,'0','1',95),(96,'HK','Hong Kong','+852',NULL,'0','1',96),(97,'HU','Hungary','+36',NULL,'0','1',97),(98,'IS','Iceland','+354',NULL,'0','1',98),(99,'IN','India','+91',NULL,'0','1',99),(100,'IM','Isle of Man','+44',NULL,'0','1',100),(101,'ID','Indonesia','+62',NULL,'0','1',101),(102,'IR','Iran (Islamic Republic of)','+98',NULL,'0','1',102),(103,'IQ','Iraq','+964',NULL,'0','1',103),(104,'IE','Ireland','+353',NULL,'0','1',104),(105,'IL','Israel','+972',NULL,'0','1',105),(106,'IT','Italy','+39',NULL,'0','1',106),(107,'CI','Ivory Coast',NULL,NULL,'0','1',107),(108,'JE','Jersey','+44',NULL,'0','1',108),(109,'JM','Jamaica','+1876',NULL,'0','1',109),(110,'JP','Japan','+81',NULL,'0','1',110),(111,'JO','Jordan','+962',NULL,'0','1',111),(112,'KZ','Kazakhstan','+77',NULL,'0','1',112),(113,'KE','Kenya','+254',NULL,'0','1',113),(114,'KI','Kiribati','+686',NULL,'0','1',114),(115,'KP','Korea, Democratic People\'s Republic of','+850',NULL,'0','1',115),(116,'KR','Korea, Republic of','+82',NULL,'0','1',116),(117,'XK','Kosovo','+381',NULL,'0','1',117),(118,'KW','Kuwait','+965',NULL,'0','1',118),(119,'KG','Kyrgyzstan','+996',NULL,'0','1',119),(120,'LA','Lao People\'s Democratic Republic','+856',NULL,'0','1',120),(121,'LV','Latvia','+371',NULL,'0','1',121),(122,'LB','Lebanon','+961',NULL,'0','1',122),(123,'LS','Lesotho','+266',NULL,'0','1',123),(124,'LR','Liberia','+231',NULL,'0','1',124),(125,'LY','Libyan Arab Jamahiriya','+218',NULL,'0','1',125),(126,'LI','Liechtenstein','+423',NULL,'0','1',126),(127,'LT','Lithuania','+370',NULL,'0','1',127),(128,'LU','Luxembourg','+352',NULL,'0','1',128),(129,'MO','Macau','+853',NULL,'0','1',129),(130,'MK','Macedonia','+389',NULL,'0','1',130),(131,'MG','Madagascar','+261',NULL,'0','1',131),(132,'MW','Malawi','+265',NULL,'0','1',132),(133,'MY','Malaysia','+60',NULL,'0','1',133),(134,'MV','Maldives','+960',NULL,'0','1',134),(135,'ML','Mali','+223',NULL,'0','1',135),(136,'MT','Malta','+356',NULL,'0','1',136),(137,'MH','Marshall Islands','+692',NULL,'0','1',137),(138,'MQ','Martinique','+596',NULL,'0','1',138),(139,'MR','Mauritania','+222',NULL,'0','1',139),(140,'MU','Mauritius','+230',NULL,'0','1',140),(141,'TY','Mayotte','+269',NULL,'0','1',141),(142,'MX','Mexico','+52',NULL,'0','1',142),(143,'FM','Micronesia, Federated States of','+691',NULL,'0','1',143),(144,'MD','Moldova, Republic of','+373',NULL,'0','1',144),(145,'MC','Monaco','+377',NULL,'0','1',145),(146,'MN','Mongolia','+976',NULL,'0','1',146),(147,'ME','Montenegro','+382',NULL,'0','1',147),(148,'MS','Montserrat','+1664',NULL,'0','1',148),(149,'MA','Morocco','+212',NULL,'0','1',149),(150,'MZ','Mozambique','+258',NULL,'0','1',150),(151,'MM','Myanmar','+95',NULL,'0','1',151),(152,'NA','Namibia','+264',NULL,'0','1',152),(153,'NR','Nauru','+674',NULL,'0','1',153),(154,'NP','Nepal','+977',NULL,'0','1',154),(155,'NL','Netherlands','+31',NULL,'0','1',155),(156,'AN','Netherlands Antilles','+599',NULL,'0','1',156),(157,'NC','New Caledonia','+687',NULL,'0','1',157),(158,'NZ','New Zealand','+64',NULL,'0','1',158),(159,'NI','Nicaragua','+505',NULL,'0','1',159),(160,'NE','Niger','+227',NULL,'0','1',160),(161,'NG','Nigeria','+234',NULL,'0','1',161),(162,'NU','Niue','+683',NULL,'0','1',162),(163,'NF','Norfolk Island','+672',NULL,'0','1',163),(164,'MP','Northern Mariana Islands','+1670',NULL,'0','1',164),(165,'NO','Norway','+47',NULL,'0','1',165),(166,'OM','Oman','+968',NULL,'0','1',166),(167,'PK','Pakistan','+92',NULL,'0','1',167),(168,'PW','Palau','+680',NULL,'0','1',168),(169,'PS','Palestine','+970',NULL,'0','1',169),(170,'PA','Panama','+507',NULL,'0','1',170),(171,'PG','Papua New Guinea','+675',NULL,'0','1',171),(172,'PY','Paraguay','+595',NULL,'0','1',172),(173,'PE','Peru','+51',NULL,'0','1',173),(174,'PH','Philippines','+63',NULL,'0','1',174),(175,'PN','Pitcairn','+872',NULL,'0','1',175),(176,'PL','Poland','+48',NULL,'0','1',176),(177,'PT','Portugal','+351',NULL,'0','1',177),(178,'PR','Puerto Rico','+1939',NULL,'0','1',178),(179,'QA','Qatar','+974',NULL,'0','1',179),(180,'RE','Reunion','+262',NULL,'0','1',180),(181,'RO','Romania','+40',NULL,'0','1',181),(182,'RU','Russian Federation','+7',NULL,'0','1',182),(183,'RW','Rwanda','+250',NULL,'0','1',183),(184,'KN','Saint Kitts and Nevis','+1869',NULL,'0','1',184),(185,'LC','Saint Lucia','+1758',NULL,'0','1',185),(186,'VC','Saint Vincent and the Grenadines','+1784',NULL,'0','1',186),(187,'WS','Samoa','+685',NULL,'0','1',187),(188,'SM','San Marino','+378',NULL,'0','1',188),(189,'ST','Sao Tome and Principe','+239',NULL,'0','1',189),(190,'SA','Saudi Arabia','+966',NULL,'0','1',190),(191,'SN','Senegal','+221',NULL,'0','1',191),(192,'RS','Serbia','+381',NULL,'0','1',192),(193,'SC','Seychelles','+248',NULL,'0','1',193),(194,'SL','Sierra Leone','+232',NULL,'0','1',194),(195,'SG','Singapore','+65',NULL,'0','1',195),(196,'SK','Slovakia','+421',NULL,'0','1',196),(197,'SI','Slovenia','+386',NULL,'0','1',197),(198,'SB','Solomon Islands','+677',NULL,'0','1',198),(199,'SO','Somalia','+252',NULL,'0','1',199),(200,'ZA','South Africa','+27',NULL,'0','1',200),(201,'GS','South Georgia South Sandwich Islands','+500',NULL,'0','1',201),(202,'ES','Spain','+34',NULL,'0','1',202),(203,'LK','Sri Lanka','+94',NULL,'0','1',203),(204,'SH','St. Helena','+290',NULL,'0','1',204),(205,'PM','St. Pierre and Miquelon','+508',NULL,'0','1',205),(206,'SD','Sudan','+249',NULL,'0','1',206),(207,'SR','Suriname','+597',NULL,'0','1',207),(208,'SJ','Svalbard and Jan Mayen Islands','+47',NULL,'0','1',208),(209,'SZ','Swaziland','+268',NULL,'0','1',209),(210,'SE','Sweden','+46',NULL,'0','1',210),(211,'CH','Switzerland','+41',NULL,'0','1',211),(212,'SY','Syrian Arab Republic','+963',NULL,'0','1',212),(213,'TW','Taiwan','+886',NULL,'0','1',213),(214,'TJ','Tajikistan','+992',NULL,'0','1',214),(215,'TZ','Tanzania, United Republic of','+255',NULL,'0','1',215),(216,'TH','Thailand','+66',NULL,'0','1',216),(217,'TG','Togo','+228',NULL,'0','1',217),(218,'TK','Tokelau','+690',NULL,'0','1',218),(219,'TO','Tonga','+676',NULL,'0','1',219),(220,'TT','Trinidad and Tobago','+1868',NULL,'0','1',220),(221,'TN','Tunisia','+216',NULL,'0','1',221),(222,'TR','Turkey','+90',NULL,'0','1',222),(223,'TM','Turkmenistan','+993',NULL,'0','1',223),(224,'TC','Turks and Caicos Islands','+1649',NULL,'0','1',224),(225,'TV','Tuvalu','+688',NULL,'0','1',225),(226,'UG','Uganda','+256',NULL,'0','1',226),(227,'UA','Ukraine','+380',NULL,'0','1',227),(228,'AE','United Arab Emirates','+971',NULL,'0','1',228),(229,'GB','United Kingdom','+44',NULL,'0','1',229),(230,'US','United States','+1',NULL,'1','1',230),(231,'UM','United States minor outlying islands','+1',NULL,'0','1',231),(232,'UY','Uruguay','+598',NULL,'0','1',232),(233,'UZ','Uzbekistan','+998',NULL,'0','1',233),(234,'VU','Vanuatu','+678',NULL,'0','1',234),(235,'VA','Vatican City State','+379',NULL,'0','1',235),(236,'VE','Venezuela','+58',NULL,'0','1',236),(237,'VN','Vietnam','+84',NULL,'0','1',237),(238,'VG','Virgin Islands (British)','+1284',NULL,'0','1',238),(239,'VI','Virgin Islands (U.S.)','+1340',NULL,'0','1',239),(240,'WF','Wallis and Futuna Islands','+681',NULL,'0','1',240),(241,'EH','Western Sahara','+212',NULL,'0','1',241),(242,'YE','Yemen','+967',NULL,'0','1',242),(243,'ZR','Zaire',NULL,NULL,'0','1',243),(244,'ZM','Zambia','+260',NULL,'0','1',244),(245,'ZW','Zimbabwe','+263',NULL,'0','1',245);
/*!40000 ALTER TABLE `system_countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_currencies`
--

DROP TABLE IF EXISTS `system_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_currencies` (
  `currency_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `code` varchar(32) NOT NULL,
  `symbol` varchar(32) NOT NULL,
  `dir` enum('left','right') NOT NULL DEFAULT 'left',
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`currency_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_currencies`
--

LOCK TABLES `system_currencies` WRITE;
/*!40000 ALTER TABLE `system_currencies` DISABLE KEYS */;
INSERT INTO `system_currencies` VALUES (1,'Australia Dollar','AUD','$','left','0','1'),(2,'Brazil Real','BRL','R$','left','0','1'),(3,'Canada Dollar','CAD','$','left','0','1'),(4,'Czech Republic Koruna','CZK','Kč','left','0','1'),(5,'Denmark Krone','DKK','kr','left','0','1'),(6,'Euro','EUR','&euro;','left','0','1'),(7,'Hong Kong Dollar','HKD','$','left','0','1'),(8,'Hungary Forint','HUF','Ft','left','0','1'),(9,'Israel Shekel','ILS','₪','left','0','1'),(10,'Japan Yen','JPY','&yen;','left','0','1'),(11,'Malaysia Ringgit','MYR','RM','left','0','1'),(12,'Mexico Peso','MXN','$','left','0','1'),(13,'Norway Krone','NOK','kr','left','0','1'),(14,'New Zealand Dollar','NZD','$','left','0','1'),(15,'Philippines Peso','PHP','₱','left','0','1'),(16,'Poland Zloty','PLN','zł','left','0','1'),(17,'United Kingdom Pound','GBP','&pound;','left','0','1'),(18,'Russia Ruble','RUB','₽','left','0','1'),(19,'Singapore Dollar','SGD','$','left','0','1'),(20,'Sweden Krona','SEK','kr','left','0','1'),(21,'Switzerland Franc','CHF','CHF','left','0','1'),(22,'Thailand Baht','THB','฿','left','0','1'),(23,'Turkey Lira','TRY','TRY','left','0','1'),(24,'United States Dollar','USD','$','left','1','1'),(25,'India Rupee','INR','₹','right','0','1');
/*!40000 ALTER TABLE `system_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_genders`
--

DROP TABLE IF EXISTS `system_genders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_genders` (
  `gender_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gender_name` varchar(64) NOT NULL,
  `gender_order` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`gender_id`) USING BTREE,
  UNIQUE KEY `name` (`gender_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_genders`
--

LOCK TABLES `system_genders` WRITE;
/*!40000 ALTER TABLE `system_genders` DISABLE KEYS */;
INSERT INTO `system_genders` VALUES (1,'Male',1),(2,'Female',2),(3,'Other',3);
/*!40000 ALTER TABLE `system_genders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_languages`
--

DROP TABLE IF EXISTS `system_languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_languages` (
  `language_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `title` varchar(256) NOT NULL,
  `flag` varchar(256) NOT NULL,
  `dir` enum('LTR','RTL') NOT NULL,
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL,
  `language_order` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`language_id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_languages`
--

LOCK TABLES `system_languages` WRITE;
/*!40000 ALTER TABLE `system_languages` DISABLE KEYS */;
INSERT INTO `system_languages` VALUES (1,'en_us','English','flags/en_us.png','LTR','1','1',1),(2,'ar_sa','Arabic','flags/ar_sa.png','RTL','0','1',2),(3,'fr_fr','French','flags/fr_fr.png','LTR','0','1',3),(4,'es_es','Spanish','flags/es_es.png','LTR','0','1',4),(5,'pt_pt','Portuguese','flags/pt_pt.png','LTR','0','1',5),(6,'de_de','Deutsch','flags/de_de.png','LTR','0','1',6),(7,'tr_tr','Turkish','flags/tr_tr.png','LTR','0','1',7),(8,'nl_nl','Dutch','flags/nl_nl.png','LTR','0','1',8),(9,'it_it','Italiano','flags/it_it.png','LTR','0','1',9),(10,'ru_ru','Russian','flags/ru_ru.png','LTR','0','1',10),(11,'ro_ro','Romaian','flags/ro_ro.png','LTR','0','1',11),(12,'pt_br','Portuguese (Brazil)','flags/pt_br.png','LTR','0','1',12),(13,'el_gr','Greek','flags/el_gr.png','LTR','0','1',13);
/*!40000 ALTER TABLE `system_languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_options`
--

DROP TABLE IF EXISTS `system_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_options` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(128) NOT NULL,
  `option_value` text NOT NULL,
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=12764 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_options`
--

LOCK TABLES `system_options` WRITE;
/*!40000 ALTER TABLE `system_options` DISABLE KEYS */;
INSERT INTO `system_options` VALUES (1,'system_public','1'),(2,'system_live','1'),(3,'system_message','We will Back Soon'),(4,'system_title','Sngine'),(5,'system_description','Share your memories, connect with others, make new friends'),(6,'system_keywords',''),(7,'system_email','drew@drews-consulting.com'),(8,'system_datetime_format','d/m/Y H:i'),(9,'contact_enabled','1'),(10,'directory_enabled','1'),(11,'pages_enabled','1'),(12,'groups_enabled','1'),(13,'events_enabled','1'),(14,'blogs_enabled','1'),(15,'users_blogs_enabled','1'),(16,'market_enabled','0'),(17,'movies_enabled','0'),(18,'games_enabled','0'),(19,'daytime_msg_enabled','1'),(20,'pokes_enabled','1'),(21,'gifts_enabled','0'),(22,'profile_notification_enabled','0'),(23,'browser_notifications_enabled','1'),(24,'noty_notifications_enabled','1'),(25,'cookie_consent_enabled','1'),(26,'adblock_detector_enabled','0'),(27,'stories_enabled','1'),(28,'popular_posts_enabled','1'),(29,'discover_posts_enabled','1'),(30,'memories_enabled','1'),(31,'wall_posts_enabled','1'),(32,'activity_posts_enabled','1'),(33,'colored_posts_enabled','1'),(34,'polls_enabled','1'),(35,'geolocation_enabled','0'),(36,'geolocation_key',''),(37,'gif_enabled','0'),(38,'giphy_key',''),(39,'post_translation_enabled','0'),(40,'yandex_key',''),(41,'smart_yt_player','1'),(42,'social_share_enabled','1'),(43,'max_post_length','5000'),(44,'max_comment_length','5000'),(45,'max_posts_hour','0'),(46,'max_comments_hour','0'),(47,'default_privacy','public'),(48,'trending_hashtags_enabled','1'),(49,'trending_hashtags_interval','week'),(50,'trending_hashtags_limit','5'),(51,'registration_enabled','1'),(52,'registration_type','free'),(53,'invitation_enabled','0'),(56,'packages_enabled','0'),(57,'packages_wallet_payment_enabled','1'),(58,'activation_enabled','1'),(59,'activation_type','email'),(60,'verification_requests','1'),(61,'age_restriction','0'),(62,'minimum_age','13'),(63,'getting_started','1'),(64,'delete_accounts_enabled','1'),(65,'download_info_enabled','1'),(66,'newsletter_consent','1'),(67,'max_accounts','0'),(68,'max_friends','5000'),(69,'social_login_enabled','0'),(70,'facebook_login_enabled','0'),(71,'facebook_appid',''),(72,'facebook_secret',''),(73,'google_login_enabled','0'),(74,'google_appid',''),(75,'google_secret',''),(76,'twitter_login_enabled','0'),(77,'twitter_appid',''),(78,'twitter_secret',''),(82,'linkedin_login_enabled','0'),(83,'linkedin_appid',''),(84,'linkedin_secret',''),(85,'vkontakte_login_enabled','0'),(86,'vkontakte_appid',''),(87,'vkontakte_secret',''),(88,'email_smtp_enabled','0'),(89,'email_smtp_authentication',''),(90,'email_smtp_ssl',''),(91,'email_smtp_server',''),(92,'email_smtp_port',''),(93,'email_smtp_username',''),(94,'email_smtp_password',''),(95,'email_smtp_setfrom',''),(96,'email_notifications','0'),(97,'email_post_likes','0'),(98,'email_post_comments','0'),(99,'email_post_shares','0'),(100,'email_wall_posts','0'),(101,'email_mentions','0'),(102,'email_profile_visits','0'),(103,'email_friend_requests','0'),(104,'twilio_sid',''),(105,'twilio_token',''),(106,'twilio_phone',''),(107,'twilio_apisid',''),(108,'twilio_apisecret',''),(109,'system_phone',''),(110,'chat_enabled','1'),(111,'chat_status_enabled','1'),(112,'chat_typing_enabled','1'),(113,'chat_seen_enabled','1'),(114,'video_call_enabled','0'),(115,'audio_call_enabled','0'),(116,'uploads_directory','content/uploads'),(117,'uploads_prefix','sngine'),(118,'max_avatar_size','10240'),(119,'max_cover_size','10240'),(120,'photos_enabled','1'),(121,'max_photo_size','10240'),(122,'uploads_quality','medium'),(123,'videos_enabled','1'),(124,'max_video_size','10240'),(125,'video_extensions','mp4, webm, ogg, mov, m4a, 3gp, 3g2, mj2, asf, avi, flv, webm, m4v, mpeg, ogv, mkv'),(126,'audio_enabled','1'),(127,'max_audio_size','10240'),(128,'audio_extensions','mp3, wav, ogg, m4a'),(129,'file_enabled','1'),(130,'max_file_size','10240'),(131,'file_extensions','txt, zip, json, docx'),(132,'s3_enabled','0'),(133,'s3_bucket',''),(134,'s3_region',''),(135,'s3_key',''),(136,'s3_secret',''),(137,'digitalocean_enabled','0'),(138,'digitalocean_space_name',''),(139,'digitalocean_space_region',''),(140,'digitalocean_key',''),(141,'digitalocean_secret',''),(142,'ftp_enabled','0'),(143,'ftp_hostname',''),(144,'ftp_port',''),(145,'ftp_username',''),(146,'ftp_password',''),(147,'ftp_path',''),(148,'ftp_endpoint',''),(149,'session_hash','2VZopTdHm-32Emz-3dkBv-4Rral-3mZKd-8d1c15054d28'),(150,'unusual_login_enabled','0'),(151,'brute_force_detection_enabled','&#039;1&#039;'),(152,'brute_force_bad_login_limit','&#039;5&#039;'),(153,'brute_force_lockout_time','&#039;10&#039;'),(154,'two_factor_enabled','&#039;1&#039;'),(155,'two_factor_type','&#039;google&#039;'),(156,'censored_words_enabled','1'),(157,'censored_words','pussy, fuck, shit, asshole, dick, tits, boobs'),(158,'reCAPTCHA_enabled','0'),(159,'reCAPTCHA_site_key',''),(160,'reCAPTCHA_secret_key',''),(161,'paypal_enabled','0'),(162,'paypal_mode',''),(163,'paypal_id',''),(164,'paypal_secret',''),(165,'creditcard_enabled','0'),(166,'alipay_enabled','0'),(167,'stripe_mode',''),(168,'stripe_test_secret',''),(169,'stripe_test_publishable',''),(170,'stripe_live_secret',''),(171,'stripe_live_publishable',''),(172,'coinpayments_enabled','0'),(173,'coinpayments_merchant_id',''),(174,'coinpayments_ipn_secret',''),(175,'2checkout_enabled','0'),(176,'2checkout_mode',''),(177,'2checkout_merchant_code',''),(178,'2checkout_publishable_key',''),(179,'2checkout_private_key',''),(180,'bank_transfers_enabled','0'),(181,'bank_name',''),(182,'bank_account_number',''),(183,'bank_account_name',''),(184,'bank_account_routing',''),(185,'bank_account_country',''),(186,'bank_transfer_note','In order to confirm the bank transfer, you will need to upload a receipt or take a screenshot of your transfer within 1 day from your payment date. If a bank transfer is made but no receipt is uploaded within this period, your order will be cancelled. We will verify and confirm your receipt within 3 working days from the date you upload it.'),(187,'data_heartbeat','5'),(188,'chat_heartbeat','10'),(189,'offline_time','10'),(190,'min_results','5'),(191,'max_results','10'),(192,'min_results_even','6'),(193,'max_results_even','12'),(194,'analytics_code',''),(195,'system_theme_night_on','0'),(196,'system_theme_mode_select','1'),(197,'system_profile_background_enabled','1'),(198,'system_logo',''),(199,'system_wallpaper_default','1'),(200,'system_wallpaper',''),(201,'system_favicon_default','1'),(202,'system_favicon',''),(203,'system_ogimage_default','1'),(204,'system_ogimage',''),(205,'css_customized','0'),(206,'css_background',''),(207,'css_link_color',''),(208,'css_header',''),(209,'css_header_search',''),(210,'css_header_search_color',''),(211,'css_btn_primary',''),(212,'css_custome_css','/* \r\n\r\nAdd here your custom css styles \r\nExample:\r\np { text-align: center; color: red; }\r\n\r\n*/'),(213,'custome_js_header','/* \r\nYou can add your JavaScript code here\r\n\r\nExample:\r\n\r\nvar x, y, z;\r\nx = 1;\r\ny = 2;\r\nz = x + y;\r\n*/'),(214,'custome_js_footer','/* \r\nYou can add your JavaScript code here\r\n\r\nExample:\r\n\r\nvar x, y, z;\r\nx = 1;\r\ny = 2;\r\nz = x + y;\r\n*/'),(215,'forums_enabled','0'),(216,'forums_online_enabled','1'),(217,'forums_statistics_enabled','1'),(218,'affiliates_enabled','0'),(219,'affiliate_type','packages'),(220,'affiliate_payment_method','paypal,skrill'),(221,'affiliate_payment_method_custom',''),(222,'affiliates_min_withdrawal','50'),(223,'affiliate_payment_type','percentage'),(224,'affiliates_per_user','0.15'),(225,'affiliates_percentage','15'),(226,'points_enabled','0'),(227,'points_money_withdraw_enabled','1'),(228,'points_payment_method','paypal,skrill'),(229,'points_payment_method_custom',''),(230,'points_min_withdrawal','50'),(231,'points_money_transfer_enabled','1'),(232,'points_per_currency','100'),(233,'points_per_post','5'),(234,'points_per_comment','5'),(235,'points_per_reaction','5'),(236,'points_limit_user','1000'),(237,'points_limit_pro','2000'),(238,'ads_enabled','0'),(239,'ads_cost_click','0.05'),(240,'ads_cost_view','0.01'),(241,'developers_apps_enabled','0'),(242,'developers_share_enabled','0'),(243,'auto_friend','0'),(244,'auto_friend_users',''),(245,'auto_follow','0'),(246,'auto_follow_users',''),(247,'auto_like','0'),(248,'auto_like_pages',''),(249,'auto_join','0'),(250,'auto_join_groups',''),(251,'last_backup_time',''),(252,'sms_provider','twilio'),(253,'bulksms_username',''),(254,'bulksms_password',''),(255,'infobip_username',''),(256,'infobip_password',''),(257,'watermark_enabled','0'),(258,'watermark_icon',''),(259,'watermark_position','bottom right'),(260,'watermark_xoffset','-30'),(261,'watermark_yoffset','-30'),(262,'watermark_opacity','0.5'),(263,'adult_images_enabled','0'),(264,'adult_images_action','blur'),(265,'adult_images_api_key',''),(266,'mobile_infinite_scroll','0'),(267,'limit_cover_photo','1'),(268,'comments_photos_enabled','1'),(269,'chat_photos_enabled','1'),(270,'onesignal_notification_enabled','0'),(271,'onesignal_app_id',''),(272,'onesignal_api_key',''),(273,'system_distance','kilometer'),(274,'wallet_enabled','0'),(275,'wallet_transfer_enabled','1'),(276,'affiliates_money_withdraw_enabled','1'),(277,'affiliates_money_transfer_enabled','1'),(286,'jobs_enabled','1'),(287,'posts_online_status','1'),(288,'anonymous_mode','1'),(289,'tinymce_photos_enabled','1'),(290,'voice_notes_posts_enabled','1'),(291,'voice_notes_comments_enabled','1'),(292,'voice_notes_chat_enabled','1'),(293,'offers_enabled','1'),(294,'live_enabled','0'),(295,'save_live_enabled','0'),(297,'agora_app_id',''),(298,'agora_app_certificate',''),(299,'agora_customer_id',''),(300,'agora_customer_certificate',''),(301,'agora_s3_bucket',''),(302,'agora_s3_region',''),(303,'agora_s3_key',''),(304,'agora_s3_secret',''),(305,'chat_permanently_delete_enabled','1'),(306,'system_description_directory','Discover new people, create new connections and make new friends'),(307,'system_description_offers','Discover new offers'),(308,'system_description_jobs','Discover new jobs offers'),(309,'system_description_blogs','Explore the latest articles'),(310,'system_description_marketplace','Discover new products'),(311,'system_description_forums','The great place to discuss topics with other users'),(312,'system_description_movies','Discover new movies'),(313,'stories_duration','3'),(314,'desktop_infinite_scroll','1'),(315,'disable_declined_friendrequest','0'),(316,'wallet_withdrawal_enabled','1'),(317,'wallet_payment_method','paypal,skrill'),(318,'wallet_payment_method_custom',''),(319,'wallet_min_withdrawal','50'),(320,'location_finder_enabled','0'),(321,'relationship_info_enabled','1'),(322,'website_info_enabled','1'),(323,'biography_info_enabled','1'),(324,'work_info_enabled','1'),(325,'education_info_enabled','1'),(326,'social_info_enabled','1'),(327,'location_info_enabled','1'),(328,'show_usernames_enabled','0'),(329,'msg91_authkey',''),(330,'name_min_length','3'),(331,'newsfeed_source','default'),(334,'funding_enabled','0'),(336,'system_description_funding','Discover new funding requests'),(339,'paystack_enabled','0'),(340,'paystack_secret',''),(341,'funding_money_withdraw_enabled','1'),(342,'funding_payment_method','paypal,skrill'),(343,'funding_payment_method_custom',''),(344,'funding_min_withdrawal','50'),(345,'funding_money_transfer_enabled','1'),(346,'funding_commission','10'),(347,'play_store_badge_enabled','0'),(348,'play_store_link',''),(349,'app_store_badge_enabled','0'),(350,'app_store_link',''),(352,'invitation_user_limit','5'),(353,'invitation_expire_period','month'),(354,'invitation_send_method','email'),(355,'appgallery_badge_enabled','0'),(356,'appgallery_store_link',''),(357,'points_per_follow','5'),(358,'points_per_referred','5'),(359,'newsfeed_results','12'),(365,'ads_approval_enabled','1'),(407,'uploads_cdn_url',''),(592,'affiliates_levels','3'),(692,'voice_notes_durtaion','120'),(693,'voice_notes_encoding','wav'),(702,'pages_results','12'),(729,'groups_results','12'),(730,'events_results','12'),(921,'system_currency_dir','left'),(968,'games_results','12'),(1004,'newsfeed_public','0'),(1005,'search_results','12'),(1006,'auto_play_videos','0'),(1010,'wasabi_enabled','0'),(1011,'wasabi_bucket',''),(1012,'wasabi_region',''),(1013,'wasabi_key',''),(1014,'wasabi_secret',''),(1028,'marketplace_results','12'),(1029,'offers_results','12'),(1030,'jobs_results','12'),(1068,'activation_required','1'),(1191,'s3','0'),(1195,'google_cloud_enabled','0'),(1196,'google_cloud_bucket',''),(1197,'google_cloud_file',''),(1198,'html_richtext_enabled','0'),(1199,'razorpay_enabled','0'),(1200,'razorpay_key_id',''),(1201,'razorpay_key_secret',''),(1214,'cashfree_enabled','0'),(1215,'cashfree_mode',''),(1216,'cashfree_client_id',''),(1217,'cashfree_client_secret',''),(1228,'coinbase_enabled','0'),(1229,'coinbase_api_key',''),(1238,'securionpay_enabled','0'),(1239,'securionpay_api_key',''),(1240,'securionpay_api_secret',''),(1247,'special_characters_enabled','1'),(1286,'backblaze_enabled','0'),(1287,'backblaze_bucket',''),(1288,'backblaze_region',''),(1289,'backblaze_key',''),(1290,'backblaze_secret',''),(1291,'ffmpeg_enabled','0'),(1292,'ffmpeg_path',''),(1293,'ffmpeg_speed','medium'),(1294,'reserved_usernames_enabled','1'),(1295,'reserved_usernames','[{&quot;value&quot;:&quot;install&quot;},{&quot;value&quot;:&quot;static&quot;},{&quot;value&quot;:&quot;contact&quot;},{&quot;value&quot;:&quot;contacts&quot;},{&quot;value&quot;:&quot;sign&quot;},{&quot;value&quot;:&quot;signin&quot;},{&quot;value&quot;:&quot;login&quot;},{&quot;value&quot;:&quot;signup&quot;},{&quot;value&quot;:&quot;register&quot;},{&quot;value&quot;:&quot;signout&quot;},{&quot;value&quot;:&quot;logout&quot;},{&quot;value&quot;:&quot;reset&quot;},{&quot;value&quot;:&quot;activation&quot;},{&quot;value&quot;:&quot;connect&quot;},{&quot;value&quot;:&quot;revoke&quot;},{&quot;value&quot;:&quot;packages&quot;},{&quot;value&quot;:&quot;started&quot;},{&quot;value&quot;:&quot;search&quot;},{&quot;value&quot;:&quot;friends&quot;},{&quot;value&quot;:&quot;messages&quot;},{&quot;value&quot;:&quot;message&quot;},{&quot;value&quot;:&quot;notifications&quot;},{&quot;value&quot;:&quot;notification&quot;},{&quot;value&quot;:&quot;settings&quot;},{&quot;value&quot;:&quot;setting&quot;},{&quot;value&quot;:&quot;posts&quot;},{&quot;value&quot;:&quot;post&quot;},{&quot;value&quot;:&quot;photos&quot;},{&quot;value&quot;:&quot;photo&quot;},{&quot;value&quot;:&quot;create&quot;},{&quot;value&quot;:&quot;pages&quot;},{&quot;value&quot;:&quot;page&quot;},{&quot;value&quot;:&quot;groups&quot;},{&quot;value&quot;:&quot;group&quot;},{&quot;value&quot;:&quot;events&quot;},{&quot;value&quot;:&quot;event&quot;},{&quot;value&quot;:&quot;games&quot;},{&quot;value&quot;:&quot;game&quot;},{&quot;value&quot;:&quot;saved&quot;},{&quot;value&quot;:&quot;forums&quot;},{&quot;value&quot;:&quot;forum&quot;},{&quot;value&quot;:&quot;blogs&quot;},{&quot;value&quot;:&quot;blog&quot;},{&quot;value&quot;:&quot;articles&quot;},{&quot;value&quot;:&quot;article&quot;},{&quot;value&quot;:&quot;directory&quot;},{&quot;value&quot;:&quot;products&quot;},{&quot;value&quot;:&quot;product&quot;},{&quot;value&quot;:&quot;market&quot;},{&quot;value&quot;:&quot;admincp&quot;},{&quot;value&quot;:&quot;admin&quot;},{&quot;value&quot;:&quot;admins&quot;},{&quot;value&quot;:&quot;modcp&quot;},{&quot;value&quot;:&quot;moderator&quot;},{&quot;value&quot;:&quot;moderators&quot;},{&quot;value&quot;:&quot;moderatorcp&quot;},{&quot;value&quot;:&quot;chat&quot;},{&quot;value&quot;:&quot;ads&quot;},{&quot;value&quot;:&quot;wallet&quot;},{&quot;value&quot;:&quot;boosted&quot;},{&quot;value&quot;:&quot;people&quot;},{&quot;value&quot;:&quot;popular&quot;},{&quot;value&quot;:&quot;movies&quot;},{&quot;value&quot;:&quot;movie&quot;},{&quot;value&quot;:&quot;api&quot;},{&quot;value&quot;:&quot;apis&quot;},{&quot;value&quot;:&quot;oauth&quot;},{&quot;value&quot;:&quot;authorize&quot;},{&quot;value&quot;:&quot;anonymous&quot;},{&quot;value&quot;:&quot;jobs&quot;},{&quot;value&quot;:&quot;job&quot;}]'),(1310,'getting_started_profile_image_required','1'),(1311,'getting_started_location_required','0'),(1312,'getting_started_education_required','0'),(1313,'getting_started_work_required','0'),(1314,'posts_views_enabled','1'),(1425,'points_per_post_view','0.001'),(1548,'newsfeed_location_filter_enabled','1'),(1833,'monetization_wallet_payment_enabled','1'),(1834,'content_monetization_commission','10'),(1836,'system_logo_dark',''),(1837,'monetization_enabled','0'),(1839,'monetization_money_withdraw_enabled','1'),(1840,'monetization_payment_method_custom',''),(1841,'monetization_min_withdrawal','50'),(1842,'monetization_money_transfer_enabled','1'),(1843,'monetization_commission','10'),(1844,'monetization_payment_method','paypal,skrill'),(1855,'watch_enabled','1'),(1929,'tips_enabled','0'),(1931,'tips_min_amount','10'),(1932,'tips_max_amount','100'),(2047,'allow_animated_images','1'),(2059,'system_description_pages','Discover pages'),(2060,'system_description_groups','Discover groups'),(2061,'system_description_events','Discover events'),(2062,'system_description_games','Discover new games'),(2063,'system_morning_message','Write it on your heart that every day is the best day in the year'),(2064,'system_afternoon_message','May Your Good Afternoon Be Light, Blessed, Productive And Happy'),(2065,'system_evening_message','We hope you are enjoying your evening'),(2129,'moneypoolscash_enabled','0'),(2130,'moneypoolscash_api_key',''),(2131,'moneypoolscash_merchant_email',''),(2148,'wordpress_login_enabled','0'),(2149,'wordpress_appid',''),(2150,'wordpress_secret',''),(2244,'moneypoolscash_merchant_password',''),(2266,'default_custom_user_group','0'),(2285,'verification_docs_required','1'),(2286,'fluid_design','0'),(2446,'css_header_icons',''),(2447,'css_header_icons_night',''),(2448,'css_main_icons',''),(2449,'css_main_icons_night',''),(2450,'css_action_icons',''),(2451,'css_action_icons_night',''),(2454,'sngine_login_enabled','0'),(2455,'sngine_appid',''),(2456,'sngine_secret',''),(2499,'sngine_app_domain',''),(2522,'sngine_app_name',''),(2570,'sngine_app_icon',''),(2571,'market_money_withdraw_enabled','1'),(2572,'market_payment_method','paypal,skrill'),(2573,'market_payment_method_custom',''),(2574,'market_min_withdrawal','50'),(2575,'market_money_transfer_enabled','1'),(2576,'market_commission','10'),(2577,'sms_limit','3'),(2596,'switch_accounts_enabled','1'),(2597,'wallet_max_transfer','5'),(2753,'packages_ads_free_enabled','1'),(2823,'paypal_webhook',''),(2856,'reviews_enabled','1'),(2857,'reviews_replacement_enabled','1'),(2858,'genders_disabled','0'),(2859,'stripe_webhook',''),(2860,'ffmpeg_240p_enabled','on'),(2861,'ffmpeg_360p_enabled','on'),(2862,'ffmpeg_480p_enabled','on'),(2863,'ffmpeg_720p_enabled','on'),(2864,'ffmpeg_1080p_enabled',''),(2865,'ffmpeg_1440p_enabled',''),(2866,'ffmpeg_2160p_enabled',''),(2990,'fluid_videos_enabled','0'),(2991,'pages_events_enabled','1'),(2992,'verification_for_monetization','0'),(2993,'verification_for_adult_content','0'),(3004,'adult_mode','1'),(3119,'payment_vat_enabled','0'),(3120,'payment_country_vat_enabled','0'),(3121,'payment_vat_percentage','20'),(3122,'payment_fees_enabled','1'),(3123,'payment_fees_percentage','1'),(3125,'watermark_videos_enabled','0'),(3126,'watermark_videos_icon',''),(3127,'watermark_videos_position','center'),(3128,'watermark_videos_opacity','0.5'),(3129,'watermark_videos_xoffset','10'),(3130,'watermark_videos_yoffset','10'),(3131,'posts_approval_enabled','0'),(3132,'posts_approval_limit','5'),(3133,'verification_for_posts','0'),(3134,'email_admin_verifications','0'),(3135,'email_admin_post_approval','0'),(3136,'email_user_verification','0'),(3137,'email_user_post_approval','0'),(3162,'posts_views_type','unique'),(3163,'market_shopping_cart_enabled','1'),(3164,'pages_reviews_enabled','1'),(3165,'pages_reviews_replacement_enabled','1'),(3166,'groups_reviews_enabled','1'),(3167,'groups_reviews_replacement_enabled','1'),(3168,'events_reviews_enabled','1'),(3169,'events_reviews_replacement_enabled','1'),(3310,'posts_reviews_enabled','1'),(3311,'posts_reviews_replacement_enabled','1'),(3312,'landing_page_template','elengine'),(3313,'authorize_net_enabled','0'),(3314,'authorize_net_api_login_id',''),(3315,'authorize_net_transaction_key',''),(3400,'authorize_net_mode','sandbox'),(3401,'users_approval_enabled','0'),(3476,'email_admin_user_approval','0'),(3498,'courses_enabled','0'),(3518,'courses_results','12'),(3569,'system_description_courses','Discover new courses'),(3570,'disable_username_changes','0'),(3571,'user_privacy_chat','public'),(3572,'user_privacy_poke','public'),(3573,'user_privacy_gifts','public'),(3574,'user_privacy_wall','public'),(3575,'user_privacy_gender','public'),(3576,'user_privacy_relationship','public'),(3577,'user_privacy_birthdate','public'),(3578,'user_privacy_basic','public'),(3579,'user_privacy_work','public'),(3580,'user_privacy_location','public'),(3581,'user_privacy_education','public'),(3582,'user_privacy_other','public'),(3583,'user_privacy_friends','public'),(3584,'user_privacy_followers','public'),(3585,'user_privacy_subscriptions','public'),(3586,'user_privacy_photos','public'),(3587,'user_privacy_pages','public'),(3588,'user_privacy_groups','public'),(3589,'user_privacy_events','public'),(3714,'yandex_cloud_enabled','0'),(3715,'yandex_cloud_bucket',''),(3716,'yandex_cloud_region',''),(3717,'yandex_cloud_key',''),(3718,'yandex_cloud_secret',''),(3719,'points_per_post_comment','5'),(3720,'points_per_post_reaction','5'),(3754,'profile_posts_updates_disabled','0'),(3844,'monetization_max_paid_post_price','0'),(3845,'monetization_max_plan_price','0'),(3864,'watermark_type','username'),(3865,'download_images_disabled','0'),(3866,'right_click_disabled','0'),(3867,'myfatoorah_enabled','0'),(3868,'myfatoorah_mode',''),(3869,'myfatoorah_test_token',''),(3870,'myfatoorah_live_token',''),(3871,'myfatoorah_live_api_url',''),(3872,'select_user_group_enabled','0'),(3948,'show_user_group_enabled','0'),(3949,'funding_wallet_payment_enabled','1'),(3950,'epayco_enabled','0'),(3951,'epayco_mode',''),(3952,'epayco_public_key',''),(3953,'epayco_private_key',''),(3954,'friends_enabled','1'),(4050,'flutterwave_enabled','0'),(4051,'flutterwave_mode',''),(4052,'flutterwave_public_key',''),(4053,'flutterwave_secret_key',''),(4054,'flutterwave_encryption_key',''),(4055,'max_daily_upload_size','0'),(4372,'pages_pbid_enabled','1'),(4374,'activities_edit_limit','15'),(4375,'stripe_payment_element_enabled','1'),(4606,'blogs_results','12'),(4624,'funding_results','12'),(4719,'verotel_enabled','0'),(4721,'verotel_shop_id',''),(4722,'verotel_signature_key',''),(4723,'auto_language_detection','1'),(4724,'paypal_payouts_enabled','0'),(4725,'moneypoolscash_payouts_enabled','0'),(4726,'reels_enabled','1'),(4727,'google_translation_key',''),(4775,'chat_translation_enabled','0'),(4776,'market_wallet_payment_enabled','1'),(4784,'censored_domains_enabled','0'),(4785,'censored_domains',''),(4786,'mods_users_permission','1'),(4793,'mods_posts_permission','1'),(4794,'mods_pages_permission','1'),(4795,'mods_groups_permission','1'),(4796,'mods_events_permission','1'),(4797,'mods_blogs_permission','1'),(4798,'mods_offers_permission','1'),(4799,'mods_jobs_permission','1'),(4800,'mods_courses_permission','1'),(4801,'mods_forums_permission','1'),(4802,'mods_movies_permission','1'),(4803,'mods_games_permission','1'),(4804,'mods_reports_permission','1'),(4805,'mods_verifications_permission','1'),(5083,'mods_ads_permission','0'),(5084,'mods_wallet_permission','0'),(5085,'mods_affiliates_permission','0'),(5086,'mods_points_permission','0'),(5087,'mods_marketplace_permission','0'),(5088,'mods_funding_permission','0'),(5089,'mods_monetization_permission','0'),(5090,'mods_tips_permission','0'),(5091,'mods_payments_permission','0'),(5092,'mods_developers_permission','1'),(5093,'mods_blacklist_permission','1'),(5094,'mods_customization_permission','1'),(5095,'mods_reach_permission','1'),(5137,'mods_pro_permission','0'),(5138,'ads_author_view_enabled','1'),(5156,'audio_video_provider','twilio'),(5157,'livekit_api_key',''),(5158,'livekit_api_secret',''),(5159,'livekit_ws_url',''),(5160,'cover_crop_enabled','1'),(5210,'market_cod_payment_enabled','0'),(5211,'chunk_upload_size','100'),(5719,'smooth_infinite_scroll','0'),(5771,'newsfeed_merge_enabled','1'),(5772,'merge_recent_results','12'),(5773,'merge_popular_results','3'),(5774,'merge_discover_results','3'),(5775,'newsfeed_caching_enabled','0'),(5796,'popular_posts_interval','month'),(6017,'pwa_enabled','0'),(6018,'pwa_192_icon',''),(6019,'pwa_512_icon',''),(6020,'pwa_banner_enabled','1'),(6249,'mask_file_path_enabled','1'),(6252,'disable_yt_player','1'),(6614,'mercadopago_enabled','0'),(6615,'mercadopago_public_key',''),(6616,'mercadopago_access_token',''),(6797,'merits_enabled','0'),(6798,'merits_peroid_max','10'),(6799,'merits_send_peroid_max','5'),(6800,'merits_peroid','1'),(6805,'merits_notifications_recharge','1'),(6806,'merits_notifications_reminder','1'),(6807,'merits_notifications_recipient','1'),(6820,'merits_widgets_newsfeed','1'),(6821,'merits_widgets_winners','1'),(6822,'merits_widgets_balance','1'),(6823,'merits_widgets_statistics','1'),(6868,'merits_peroid_reset','1'),(6944,'cronjob_hash','7d6c10684ae17ff98317c4b62e8b90d8'),(6948,'cronjob_enabled','0'),(6949,'cronjob_reset_pro_packages','1'),(6950,'cronjob_merits_reminder','1'),(6955,'merits_notifications_sender','1'),(6994,'system_back_swipe','1'),(7097,'posts_schedule_enabled','1'),(7100,'whitelist_enabled','0'),(7101,'whitelist_providers',''),(7394,'allow_heif_images','0'),(7501,'affiliate_payment_to','buyer'),(7502,'affiliates_per_user_2','0.10'),(7503,'affiliates_percentage_2','10'),(7504,'affiliates_per_user_3','0.05'),(7505,'affiliates_percentage_3','5'),(7506,'affiliates_per_user_4',''),(7507,'affiliates_percentage_4',''),(7508,'affiliates_per_user_5',''),(7509,'affiliates_percentage_5',''),(7522,'turnstile_enabled','0'),(7523,'turnstile_site_key',''),(7524,'turnstile_secret_key',''),(7561,'password_complexity_enabled','0'),(7612,'market_delivery_days','30'),(7640,'cronjob_undelivered_orders','1'),(8259,'system_api_key',''),(8260,'system_api_secret',''),(8272,'system_jwt_key','');
/*!40000 ALTER TABLE `system_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_reactions`
--

DROP TABLE IF EXISTS `system_reactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_reactions` (
  `reaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reaction` varchar(32) NOT NULL,
  `title` varchar(32) NOT NULL,
  `color` varchar(128) DEFAULT NULL,
  `image` varchar(256) NOT NULL,
  `reaction_order` int(10) unsigned NOT NULL DEFAULT 1,
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`reaction_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_reactions`
--

LOCK TABLES `system_reactions` WRITE;
/*!40000 ALTER TABLE `system_reactions` DISABLE KEYS */;
INSERT INTO `system_reactions` VALUES (1,'like','Like','#1e8bd2','reactions/like.png',1,'1'),(2,'love','Love','#f25268','reactions/love.png',2,'1'),(3,'haha','Haha','#f3b715','reactions/haha.png',3,'1'),(4,'yay','Yay','#F3B715','reactions/yay.png',4,'1'),(5,'wow','Wow','#f3b715','reactions/wow.png',5,'1'),(6,'sad','Sad','#f3b715','reactions/sad.png',6,'1'),(7,'angry','Angry','#f7806c','reactions/angry.png',7,'1');
/*!40000 ALTER TABLE `system_reactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_themes`
--

DROP TABLE IF EXISTS `system_themes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system_themes` (
  `theme_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `default` enum('0','1') NOT NULL,
  `enabled` enum('0','1') NOT NULL,
  PRIMARY KEY (`theme_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_themes`
--

LOCK TABLES `system_themes` WRITE;
/*!40000 ALTER TABLE `system_themes` DISABLE KEYS */;
INSERT INTO `system_themes` VALUES (1,'default','1','1');
/*!40000 ALTER TABLE `system_themes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_master_account` int(11) NOT NULL DEFAULT 0,
  `user_group` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `user_group_custom` int(11) NOT NULL DEFAULT 0,
  `user_demo` enum('0','1') NOT NULL DEFAULT '0',
  `user_name` varchar(64) NOT NULL,
  `user_email` varchar(64) NOT NULL,
  `user_email_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_email_verification_code` varchar(64) DEFAULT NULL,
  `user_phone` varchar(64) DEFAULT NULL,
  `user_phone_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_phone_verification_code` varchar(64) DEFAULT NULL,
  `user_password` varchar(64) NOT NULL,
  `user_two_factor_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `user_two_factor_type` enum('email','sms','google') DEFAULT NULL,
  `user_two_factor_key` varchar(64) DEFAULT NULL,
  `user_two_factor_gsecret` varchar(64) DEFAULT NULL,
  `user_activated` enum('0','1') NOT NULL DEFAULT '0',
  `user_approved` enum('0','1') NOT NULL DEFAULT '0',
  `user_reseted` enum('0','1') NOT NULL DEFAULT '0',
  `user_reset_key` varchar(64) DEFAULT NULL,
  `user_subscribed` enum('0','1') NOT NULL DEFAULT '0',
  `user_package` int(10) unsigned DEFAULT NULL,
  `user_package_videos_categories` text DEFAULT NULL,
  `user_package_blogs_categories` text DEFAULT NULL,
  `user_subscription_date` datetime DEFAULT NULL,
  `user_boosted_posts` int(10) unsigned NOT NULL DEFAULT 0,
  `user_boosted_pages` int(10) unsigned NOT NULL DEFAULT 0,
  `user_started` enum('0','1') NOT NULL DEFAULT '0',
  `user_verified` enum('0','1') NOT NULL DEFAULT '0',
  `user_banned` enum('0','1') NOT NULL DEFAULT '0',
  `user_banned_message` text DEFAULT NULL,
  `user_live_requests_counter` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_requests_lastid` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_messages_counter` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_messages_lastid` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_calls_counter` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_notifications_counter` int(10) unsigned NOT NULL DEFAULT 0,
  `user_live_notifications_lastid` int(10) unsigned NOT NULL DEFAULT 0,
  `user_latitude` varchar(256) NOT NULL DEFAULT '0',
  `user_longitude` varchar(256) NOT NULL DEFAULT '0',
  `user_location_updated` datetime DEFAULT NULL,
  `user_firstname` varchar(256) NOT NULL,
  `user_lastname` varchar(256) DEFAULT NULL,
  `user_gender` int(10) unsigned DEFAULT NULL,
  `user_picture` varchar(255) DEFAULT NULL,
  `user_picture_id` int(10) unsigned DEFAULT NULL,
  `user_cover` varchar(256) DEFAULT NULL,
  `user_cover_id` int(10) unsigned DEFAULT NULL,
  `user_cover_position` varchar(256) DEFAULT NULL,
  `user_album_pictures` int(10) unsigned DEFAULT NULL,
  `user_album_covers` int(10) unsigned DEFAULT NULL,
  `user_album_timeline` int(10) unsigned DEFAULT NULL,
  `user_pinned_post` int(10) unsigned DEFAULT NULL,
  `user_registered` datetime DEFAULT NULL,
  `user_last_seen` timestamp NOT NULL DEFAULT current_timestamp(),
  `user_first_failed_login` datetime DEFAULT NULL,
  `user_failed_login_ip` varchar(64) DEFAULT NULL,
  `user_failed_login_count` int(10) unsigned NOT NULL DEFAULT 0,
  `user_country` int(10) unsigned DEFAULT NULL,
  `user_birthdate` date DEFAULT NULL,
  `user_relationship` varchar(256) DEFAULT NULL,
  `user_biography` text DEFAULT NULL,
  `user_website` varchar(256) DEFAULT NULL,
  `user_work_title` varchar(256) DEFAULT NULL,
  `user_work_place` varchar(256) DEFAULT NULL,
  `user_work_url` varchar(256) DEFAULT NULL,
  `user_current_city` varchar(256) DEFAULT NULL,
  `user_hometown` varchar(256) DEFAULT NULL,
  `user_edu_major` varchar(256) DEFAULT NULL,
  `user_edu_school` varchar(256) DEFAULT NULL,
  `user_edu_class` varchar(256) DEFAULT NULL,
  `user_social_facebook` varchar(256) DEFAULT NULL,
  `user_social_twitter` varchar(256) DEFAULT NULL,
  `user_social_youtube` varchar(256) DEFAULT NULL,
  `user_social_instagram` varchar(256) DEFAULT NULL,
  `user_social_twitch` varchar(256) DEFAULT NULL,
  `user_social_linkedin` varchar(256) DEFAULT NULL,
  `user_social_vkontakte` varchar(256) DEFAULT NULL,
  `user_profile_background` varchar(256) DEFAULT NULL,
  `user_chat_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `user_newsletter_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `user_tips_enabled` enum('0','1') NOT NULL DEFAULT '1',
  `user_suggestions_hidden` enum('0','1') NOT NULL DEFAULT '0',
  `user_privacy_chat` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_poke` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_gifts` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_wall` enum('me','friends','public') NOT NULL DEFAULT 'friends',
  `user_privacy_gender` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_birthdate` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_relationship` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_basic` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_work` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_location` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_education` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_other` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_friends` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_followers` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_photos` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_pages` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_groups` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_events` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `user_privacy_subscriptions` enum('me','friends','public') NOT NULL DEFAULT 'public',
  `email_post_likes` enum('0','1') NOT NULL DEFAULT '1',
  `email_post_comments` enum('0','1') NOT NULL DEFAULT '1',
  `email_post_shares` enum('0','1') NOT NULL DEFAULT '1',
  `email_wall_posts` enum('0','1') NOT NULL DEFAULT '1',
  `email_mentions` enum('0','1') NOT NULL DEFAULT '1',
  `email_profile_visits` enum('0','1') NOT NULL DEFAULT '1',
  `email_friend_requests` enum('0','1') NOT NULL DEFAULT '1',
  `email_user_verification` enum('0','1') NOT NULL DEFAULT '1',
  `email_user_post_approval` enum('0','1') NOT NULL DEFAULT '1',
  `email_admin_verifications` enum('0','1') NOT NULL DEFAULT '1',
  `email_admin_post_approval` enum('0','1') NOT NULL DEFAULT '1',
  `email_admin_user_approval` enum('0','1') NOT NULL DEFAULT '0',
  `facebook_connected` enum('0','1') NOT NULL DEFAULT '0',
  `facebook_id` varchar(128) DEFAULT NULL,
  `google_connected` enum('0','1') NOT NULL DEFAULT '0',
  `google_id` varchar(128) DEFAULT NULL,
  `twitter_connected` enum('0','1') NOT NULL DEFAULT '0',
  `twitter_id` varchar(128) DEFAULT NULL,
  `instagram_connected` enum('0','1') NOT NULL DEFAULT '0',
  `instagram_id` varchar(128) DEFAULT NULL,
  `linkedin_connected` enum('0','1') NOT NULL DEFAULT '0',
  `linkedin_id` varchar(128) DEFAULT NULL,
  `vkontakte_connected` enum('0','1') NOT NULL DEFAULT '0',
  `vkontakte_id` varchar(128) DEFAULT NULL,
  `wordpress_connected` enum('0','1') NOT NULL DEFAULT '0',
  `wordpress_id` varchar(128) DEFAULT NULL,
  `sngine_connected` enum('0','1') NOT NULL DEFAULT '0',
  `sngine_id` varchar(128) DEFAULT NULL,
  `user_referrer_id` int(11) DEFAULT NULL,
  `custom_affiliates_system` enum('0','1') NOT NULL DEFAULT '0',
  `affiliates_per_user` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_2` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_2` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_3` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_3` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_4` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_4` float unsigned NOT NULL DEFAULT 0,
  `affiliates_per_user_5` float unsigned NOT NULL DEFAULT 0,
  `affiliates_percentage_5` float unsigned NOT NULL DEFAULT 0,
  `points_earned` enum('0','1') NOT NULL DEFAULT '0',
  `user_points` float NOT NULL DEFAULT 0,
  `user_wallet_balance` float NOT NULL DEFAULT 0,
  `user_affiliate_balance` float NOT NULL DEFAULT 0,
  `user_market_balance` float NOT NULL DEFAULT 0,
  `user_funding_balance` float NOT NULL DEFAULT 0,
  `user_monetization_enabled` enum('0','1') NOT NULL DEFAULT '0',
  `user_monetization_chat_price` float NOT NULL DEFAULT 0,
  `user_monetization_call_price` float NOT NULL DEFAULT 0,
  `user_monetization_min_price` float NOT NULL DEFAULT 0,
  `user_monetization_plans` int(10) unsigned NOT NULL DEFAULT 0,
  `user_monetization_balance` float NOT NULL DEFAULT 0,
  `chat_sound` enum('0','1') NOT NULL DEFAULT '1',
  `notifications_sound` enum('0','1') NOT NULL DEFAULT '1',
  `user_language` varchar(16) DEFAULT 'en_us',
  `user_free_tried` enum('0','1') NOT NULL DEFAULT '0',
  `coinbase_hash` varchar(128) DEFAULT NULL,
  `coinbase_code` varchar(128) DEFAULT NULL,
  `is_fake` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `user_email` (`user_email`),
  UNIQUE KEY `username` (`user_name`) USING BTREE,
  UNIQUE KEY `facebook_id` (`facebook_id`),
  UNIQUE KEY `twitter_id` (`twitter_id`),
  UNIQUE KEY `linkedin_id` (`linkedin_id`),
  UNIQUE KEY `vkontakte_id` (`vkontakte_id`),
  UNIQUE KEY `instagram_id` (`instagram_id`),
  UNIQUE KEY `user_phone` (`user_phone`),
  UNIQUE KEY `google_id` (`google_id`),
  KEY `user_picture_id` (`user_picture_id`),
  KEY `user_gender` (`user_gender`),
  KEY `user_cover_id` (`user_cover_id`),
  KEY `user_country` (`user_country`),
  KEY `user_album_pictures` (`user_album_pictures`),
  KEY `user_album_covers` (`user_album_covers`),
  KEY `user_album_timeline` (`user_album_timeline`),
  KEY `user_banned` (`user_banned`) USING BTREE,
  KEY `user_subscribed` (`user_subscribed`) USING BTREE,
  KEY `user_registered` (`user_registered`) USING BTREE,
  KEY `user_id_idx` (`user_id`) USING BTREE,
  KEY `user_lastname_idx` (`user_lastname`) USING BTREE,
  KEY `user_name_idx` (`user_name`) USING BTREE,
  KEY `user_firstname_idx` (`user_firstname`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,1,1,0,'0','drew44','drew@drews-consulting.com','1',NULL,NULL,'0',NULL,'$2y$10$/uJbv/pa9cR9A6MgdLjWMO067wJzJTBC3MsYDCv1/euo0tE4d3cxm','0',NULL,NULL,NULL,'1','1','0',NULL,'0',NULL,NULL,NULL,NULL,0,0,'1','1','0',NULL,0,0,0,0,0,0,0,'0','0',NULL,'drew44',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 21:56:18','2025-05-19 22:33:18','2025-05-19 21:56:24','172.59.211.60',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1','1','1','0','public','public','public','friends','public','public','public','public','public','public','public','public','public','public','public','public','public','public','public','1','1','1','1','1','1','1','1','1','1','1','0','0',NULL,'0',NULL,'0',NULL,'0',NULL,'0',NULL,'0',NULL,'0',NULL,'0',NULL,NULL,'0',0,0,0,0,0,0,0,0,0,0,'0',0,0,0,0,0,'0',0,0,0,0,0,'1','1','en_us','0',NULL,NULL,'0');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_accounts`
--

DROP TABLE IF EXISTS `users_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `account_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_account_id` (`user_id`,`account_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_accounts`
--

LOCK TABLES `users_accounts` WRITE;
/*!40000 ALTER TABLE `users_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_addresses`
--

DROP TABLE IF EXISTS `users_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_addresses` (
  `address_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `address_title` varchar(256) NOT NULL,
  `address_country` varchar(256) NOT NULL,
  `address_city` varchar(256) NOT NULL,
  `address_zip_code` varchar(256) NOT NULL,
  `address_phone` varchar(256) NOT NULL,
  `address_details` text NOT NULL,
  PRIMARY KEY (`address_id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_addresses`
--

LOCK TABLES `users_addresses` WRITE;
/*!40000 ALTER TABLE `users_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_affiliates`
--

DROP TABLE IF EXISTS `users_affiliates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_affiliates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `referrer_id` int(10) unsigned NOT NULL,
  `referee_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `referrer_id_referee_id` (`referrer_id`,`referee_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_affiliates`
--

LOCK TABLES `users_affiliates` WRITE;
/*!40000 ALTER TABLE `users_affiliates` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_affiliates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_blocks`
--

DROP TABLE IF EXISTS `users_blocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_blocks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `blocked_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_blocked_id` (`user_id`,`blocked_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_blocks`
--

LOCK TABLES `users_blocks` WRITE;
/*!40000 ALTER TABLE `users_blocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_blocks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_gifts`
--

DROP TABLE IF EXISTS `users_gifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_gifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) unsigned NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `gift_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `from_user_id` (`from_user_id`),
  KEY `to_user_id` (`to_user_id`),
  KEY `gift_id` (`gift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_gifts`
--

LOCK TABLES `users_gifts` WRITE;
/*!40000 ALTER TABLE `users_gifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_gifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_groups`
--

DROP TABLE IF EXISTS `users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_groups` (
  `user_group_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_group_title` varchar(255) NOT NULL,
  `permissions_group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_group_id`),
  KEY `permissions_group_id` (`permissions_group_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_groups`
--

LOCK TABLES `users_groups` WRITE;
/*!40000 ALTER TABLE `users_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_invitations`
--

DROP TABLE IF EXISTS `users_invitations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_invitations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_phone` varchar(64) NOT NULL,
  `invitation_date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_email_phone` (`user_id`,`email_phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_invitations`
--

LOCK TABLES `users_invitations` WRITE;
/*!40000 ALTER TABLE `users_invitations` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_invitations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_merits`
--

DROP TABLE IF EXISTS `users_merits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_merits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_user_id` int(10) unsigned NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `message` text DEFAULT NULL,
  `image` varchar(256) DEFAULT NULL,
  `sent_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_merits`
--

LOCK TABLES `users_merits` WRITE;
/*!40000 ALTER TABLE `users_merits` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_merits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_pokes`
--

DROP TABLE IF EXISTS `users_pokes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_pokes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `poked_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_poked_id` (`user_id`,`poked_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_pokes`
--

LOCK TABLES `users_pokes` WRITE;
/*!40000 ALTER TABLE `users_pokes` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_pokes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_recurring_payments`
--

DROP TABLE IF EXISTS `users_recurring_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_recurring_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `payment_gateway` varchar(256) NOT NULL,
  `handle` varchar(256) NOT NULL,
  `handle_id` int(10) unsigned NOT NULL,
  `subscription_id` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_recurring_payments`
--

LOCK TABLES `users_recurring_payments` WRITE;
/*!40000 ALTER TABLE `users_recurring_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_recurring_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_searches`
--

DROP TABLE IF EXISTS `users_searches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_searches` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `user_id_node_id_node_type` (`user_id`,`node_id`,`node_type`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_searches`
--

LOCK TABLES `users_searches` WRITE;
/*!40000 ALTER TABLE `users_searches` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_searches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_sessions`
--

DROP TABLE IF EXISTS `users_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_sessions` (
  `session_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `session_token` varchar(64) NOT NULL,
  `session_date` datetime NOT NULL,
  `session_type` enum('W','A','I') NOT NULL DEFAULT 'W',
  `user_id` int(10) unsigned NOT NULL,
  `user_ip` varchar(64) NOT NULL,
  `user_browser` varchar(64) DEFAULT NULL,
  `user_os` varchar(64) NOT NULL,
  `user_os_version` varchar(64) DEFAULT NULL,
  `user_device_name` varchar(64) DEFAULT NULL,
  `session_onesignal_user_id` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_token` (`session_token`),
  KEY `user_ip` (`user_ip`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_sessions`
--

LOCK TABLES `users_sessions` WRITE;
/*!40000 ALTER TABLE `users_sessions` DISABLE KEYS */;
INSERT INTO `users_sessions` VALUES (1,'33b9b71d1e882489ac215d3fb195555e','2025-05-19 21:56:38','W',1,'172.59.211.60','Chrome','Windows 10',NULL,NULL,NULL);
/*!40000 ALTER TABLE `users_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_sms`
--

DROP TABLE IF EXISTS `users_sms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_sms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(256) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_sms`
--

LOCK TABLES `users_sms` WRITE;
/*!40000 ALTER TABLE `users_sms` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_sms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_top_friends`
--

DROP TABLE IF EXISTS `users_top_friends`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_top_friends` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `friend_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_friend_id` (`user_id`,`friend_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_top_friends`
--

LOCK TABLES `users_top_friends` WRITE;
/*!40000 ALTER TABLE `users_top_friends` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_top_friends` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_uploads`
--

DROP TABLE IF EXISTS `users_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `file_name` varchar(256) NOT NULL,
  `file_size` float NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_uploads`
--

LOCK TABLES `users_uploads` WRITE;
/*!40000 ALTER TABLE `users_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `verification_requests`
--

DROP TABLE IF EXISTS `verification_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `verification_requests` (
  `request_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `node_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `photo` varchar(256) DEFAULT NULL,
  `passport` varchar(256) DEFAULT NULL,
  `business_website` text DEFAULT NULL,
  `business_address` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `verification_requests`
--

LOCK TABLES `verification_requests` WRITE;
/*!40000 ALTER TABLE `verification_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `verification_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wallet_payments`
--

DROP TABLE IF EXISTS `wallet_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wallet_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(32) NOT NULL,
  `method` varchar(64) NOT NULL,
  `method_value` text NOT NULL,
  `time` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`payment_id`) USING BTREE,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wallet_payments`
--

LOCK TABLES `wallet_payments` WRITE;
/*!40000 ALTER TABLE `wallet_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `wallet_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wallet_transactions`
--

DROP TABLE IF EXISTS `wallet_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wallet_transactions` (
  `transaction_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `node_type` varchar(32) NOT NULL,
  `node_id` int(10) unsigned DEFAULT NULL,
  `amount` varchar(32) NOT NULL,
  `type` enum('in','out') NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wallet_transactions`
--

LOCK TABLES `wallet_transactions` WRITE;
/*!40000 ALTER TABLE `wallet_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `wallet_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `widgets` (
  `widget_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `place` varchar(32) NOT NULL,
  `place_order` int(10) unsigned NOT NULL DEFAULT 1,
  `code` mediumtext NOT NULL,
  `language_id` int(11) NOT NULL DEFAULT 0,
  `target_audience` enum('all','members','visitors') NOT NULL DEFAULT 'all',
  PRIMARY KEY (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-05-19 18:33:23
